/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.intrinsic.functions.factories;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.basic.FunctionIntrinsicWithReceiverComputed;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;

public class KotlinFunctionIntrinsic
extends FunctionIntrinsicWithReceiverComputed {
    @NotNull
    private final String functionName;
    private final JsExpression[] additionalArguments;

    public KotlinFunctionIntrinsic(@NotNull String functionName, JsExpression ... additionalArguments) {
        if (functionName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionName", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/KotlinFunctionIntrinsic", "<init>"));
        }
        this.functionName = functionName;
        this.additionalArguments = additionalArguments;
    }

    @Override
    @NotNull
    public JsExpression apply(@Nullable JsExpression receiver, @NotNull List<? extends JsExpression> arguments2, @NotNull TranslationContext context) {
        if (arguments2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/KotlinFunctionIntrinsic", "apply"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/KotlinFunctionIntrinsic", "apply"));
        }
        JsNameRef function2 = JsAstUtils.pureFqn(this.functionName, (JsExpression)Namer.kotlinObject());
        if (this.additionalArguments.length > 0) {
            ArrayList<? extends JsExpression> newArguments2 = new ArrayList<JsExpression>(arguments2);
            for (JsExpression e : this.additionalArguments) {
                newArguments2.add(e.deepCopy());
            }
            arguments2 = newArguments2;
        }
        JsInvocation jsInvocation = new JsInvocation((JsExpression)function2, receiver == null ? arguments2 : TranslationUtils.generateInvocationArguments(receiver, arguments2));
        if (jsInvocation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/KotlinFunctionIntrinsic", "apply"));
        }
        return jsInvocation;
    }
}

