/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.modules;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0096\u0002J\u0015\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0012H\u0016\u00a2\u0006\u0002\u0010\u0013J\b\u0010\u0014\u001a\u00020\u0003H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0018H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J \u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\u00182\u0006\u0010 \u001a\u00020\u0018H\u0016J\n\u0010!\u001a\u0004\u0018\u00010\u0001H\u0016J\b\u0010\"\u001a\u00020\u001bH\u0016J\b\u0010#\u001a\u00020\u0018H\u0016J\b\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020\u000eH\u0016J\b\u0010'\u001a\u00020\u000eH\u0016J\b\u0010(\u001a\u00020\u000eH\u0016J\"\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u000e2\u0006\u0010,\u001a\u00020\u000e2\b\u0010-\u001a\u0004\u0018\u00010.H\u0016R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/modules/CoreLocalPathVirtualFile;", "Lcom/intellij/openapi/vfs/VirtualFile;", "fileSystem", "Lcom/intellij/openapi/vfs/VirtualFileSystem;", "path", "Ljava/nio/file/Path;", "(Lcom/intellij/openapi/vfs/VirtualFileSystem;Ljava/nio/file/Path;)V", "attributes", "Ljava/nio/file/attribute/BasicFileAttributes;", "getAttributes", "()Ljava/nio/file/attribute/BasicFileAttributes;", "contentsToByteArray", "", "equals", "", "other", "", "getChildren", "", "()[Lcom/intellij/openapi/vfs/VirtualFile;", "getFileSystem", "getInputStream", "Ljava/io/InputStream;", "getLength", "", "getModificationStamp", "getName", "", "getOutputStream", "Ljava/io/OutputStream;", "requestor", "newModificationStamp", "newTimeStamp", "getParent", "getPath", "getTimeStamp", "hashCode", "", "isDirectory", "isValid", "isWritable", "refresh", "", "asynchronous", "recursive", "postRunnable", "Ljava/lang/Runnable;", "kotlin-compiler"})
public final class CoreLocalPathVirtualFile
extends VirtualFile {
    private final VirtualFileSystem fileSystem;
    private final Path path;

    private final BasicFileAttributes getAttributes() {
        BasicFileAttributes basicFileAttributes = Files.readAttributes(this.path, BasicFileAttributes.class, new LinkOption[0]);
        Intrinsics.checkExpressionValueIsNotNull(basicFileAttributes, "Files.readAttributes(pat\u2026leAttributes::class.java)");
        return basicFileAttributes;
    }

    @Override
    @NotNull
    public VirtualFileSystem getFileSystem() {
        return this.fileSystem;
    }

    @Override
    @NotNull
    public String getName() {
        return ((Object)this.path.getFileName()).toString();
    }

    @Override
    @NotNull
    public String getPath() {
        String string = FileUtil.toSystemIndependentName(((Object)this.path).toString());
        Intrinsics.checkExpressionValueIsNotNull(string, "FileUtil.toSystemIndependentName(path.toString())");
        return string;
    }

    @Override
    public boolean isWritable() {
        return false;
    }

    @Override
    public boolean isDirectory() {
        return Files.isDirectory(this.path, new LinkOption[0]);
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    @Nullable
    public VirtualFile getParent() {
        Path parentPath = this.path.getParent();
        return parentPath != null ? (VirtualFile)new CoreLocalPathVirtualFile(this.fileSystem, parentPath) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public VirtualFile[] getChildren() {
        VirtualFile[] virtualFileArray;
        List list2;
        try {
            List list3;
            List p122;
            list2 = Files.newDirectoryStream(this.path);
            boolean bl = false;
            try {
                p122 = list2;
                p122 = CollectionsKt.toList(p122);
                list3 = list2;
            }
            catch (Exception p122) {
                try {
                    bl = true;
                    try {
                        List list4 = list2;
                        if (list4 != null) {
                            list4.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw (Throwable)p122;
                }
                catch (Throwable p122) {
                    if (!bl) {
                        List list5 = list2;
                        if (list5 != null) {
                            list5.close();
                        }
                    }
                    throw p122;
                }
            }
            if (list3 != null) {
                list3.close();
            }
            list2 = p122;
        }
        catch (IOException e) {
            list2 = CollectionsKt.emptyList();
        }
        List paths = list2;
        if (paths.isEmpty()) {
            virtualFileArray = VirtualFile.EMPTY_ARRAY;
            Intrinsics.checkExpressionValueIsNotNull(VirtualFile.EMPTY_ARRAY, "VirtualFile.EMPTY_ARRAY");
        } else {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable e = $receiver$iv = (Iterable)paths;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void path;
                Path path2 = (Path)item$iv$iv;
                Collection collection = destination$iv$iv;
                CoreLocalPathVirtualFile coreLocalPathVirtualFile = new CoreLocalPathVirtualFile(this.fileSystem, (Path)path);
                collection.add(coreLocalPathVirtualFile);
            }
            $receiver$iv = (List)destination$iv$iv;
            Iterable thisCollection$iv = $receiver$iv;
            CoreLocalPathVirtualFile[] coreLocalPathVirtualFileArray = thisCollection$iv.toArray(new CoreLocalPathVirtualFile[thisCollection$iv.size()]);
            if (coreLocalPathVirtualFileArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            virtualFileArray = coreLocalPathVirtualFileArray;
        }
        return virtualFileArray;
    }

    @Override
    @NotNull
    public OutputStream getOutputStream(@NotNull Object requestor, long newModificationStamp, long newTimeStamp) {
        Intrinsics.checkParameterIsNotNull(requestor, "requestor");
        throw (Throwable)new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public byte[] contentsToByteArray() {
        byte[] byArray = Files.readAllBytes(this.path);
        Intrinsics.checkExpressionValueIsNotNull(byArray, "Files.readAllBytes(path)");
        return byArray;
    }

    @Override
    public long getTimeStamp() {
        return this.getAttributes().lastModifiedTime().toMillis();
    }

    @Override
    public long getLength() {
        return this.getAttributes().size();
    }

    @Override
    public void refresh(boolean asynchronous, boolean recursive, @Nullable Runnable postRunnable) {
    }

    @Override
    @NotNull
    public InputStream getInputStream() {
        InputStream inputStream = Files.newInputStream(this.path, new OpenOption[0]);
        int n = 8192;
        InputStream inputStream2 = VfsUtilCore.inputStreamSkippingBOM(inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream, n), this);
        Intrinsics.checkExpressionValueIsNotNull(inputStream2, "VfsUtilCore.inputStreamS\u2026m(path).buffered(), this)");
        return inputStream2;
    }

    @Override
    public long getModificationStamp() {
        return 0L;
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof CoreLocalPathVirtualFile && Intrinsics.areEqual(this.path, ((CoreLocalPathVirtualFile)other).path) && Intrinsics.areEqual(this.fileSystem, ((CoreLocalPathVirtualFile)other).fileSystem);
    }

    public int hashCode() {
        return ((Object)this.path).hashCode();
    }

    public CoreLocalPathVirtualFile(@NotNull VirtualFileSystem fileSystem, @NotNull Path path) {
        Intrinsics.checkParameterIsNotNull(fileSystem, "fileSystem");
        Intrinsics.checkParameterIsNotNull(path, "path");
        this.fileSystem = fileSystem;
        this.path = path;
    }
}

