/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.DToA;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.NativeGlobal;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;

final class NativeNumber
extends IdScriptableObject {
    static final long serialVersionUID = 3504516769741512101L;
    private static final Object NUMBER_TAG = "Number";
    private static final int MAX_PRECISION = 100;
    private static final double MAX_SAFE_INTEGER = Math.pow(2.0, 53.0) - 1.0;
    private static final double MIN_SAFE_INTEGER = -MAX_SAFE_INTEGER;
    private static final int ConstructorId_isFinite = -1;
    private static final int ConstructorId_isNaN = -2;
    private static final int ConstructorId_isInteger = -3;
    private static final int ConstructorId_isSafeInteger = -4;
    private static final int ConstructorId_parseFloat = -5;
    private static final int ConstructorId_parseInt = -6;
    private static final int Id_constructor = 1;
    private static final int Id_toString = 2;
    private static final int Id_toLocaleString = 3;
    private static final int Id_toSource = 4;
    private static final int Id_valueOf = 5;
    private static final int Id_toFixed = 6;
    private static final int Id_toExponential = 7;
    private static final int Id_toPrecision = 8;
    private static final int MAX_PROTOTYPE_ID = 8;
    private double doubleValue;

    static void init(Scriptable scriptable, boolean bl) {
        NativeNumber nativeNumber = new NativeNumber(0.0);
        nativeNumber.exportAsJSClass(8, scriptable, bl);
    }

    NativeNumber(double d) {
        this.doubleValue = d;
    }

    @Override
    public String getClassName() {
        return "Number";
    }

    @Override
    protected void fillConstructorProperties(IdFunctionObject idFunctionObject) {
        int n = 7;
        idFunctionObject.defineProperty("NaN", ScriptRuntime.NaNobj, 7);
        idFunctionObject.defineProperty("POSITIVE_INFINITY", ScriptRuntime.wrapNumber(Double.POSITIVE_INFINITY), 7);
        idFunctionObject.defineProperty("NEGATIVE_INFINITY", ScriptRuntime.wrapNumber(Double.NEGATIVE_INFINITY), 7);
        idFunctionObject.defineProperty("MAX_VALUE", ScriptRuntime.wrapNumber(Double.MAX_VALUE), 7);
        idFunctionObject.defineProperty("MIN_VALUE", ScriptRuntime.wrapNumber(Double.MIN_VALUE), 7);
        idFunctionObject.defineProperty("MAX_SAFE_INTEGER", ScriptRuntime.wrapNumber(MAX_SAFE_INTEGER), 7);
        idFunctionObject.defineProperty("MIN_SAFE_INTEGER", ScriptRuntime.wrapNumber(MIN_SAFE_INTEGER), 7);
        this.addIdFunctionProperty(idFunctionObject, NUMBER_TAG, -1, "isFinite", 1);
        this.addIdFunctionProperty(idFunctionObject, NUMBER_TAG, -2, "isNaN", 1);
        this.addIdFunctionProperty(idFunctionObject, NUMBER_TAG, -3, "isInteger", 1);
        this.addIdFunctionProperty(idFunctionObject, NUMBER_TAG, -4, "isSafeInteger", 1);
        this.addIdFunctionProperty(idFunctionObject, NUMBER_TAG, -5, "parseFloat", 1);
        this.addIdFunctionProperty(idFunctionObject, NUMBER_TAG, -6, "parseInt", 1);
        super.fillConstructorProperties(idFunctionObject);
    }

    @Override
    protected void initPrototypeId(int n) {
        String string;
        int n2;
        switch (n) {
            case 1: {
                n2 = 1;
                string = "constructor";
                break;
            }
            case 2: {
                n2 = 1;
                string = "toString";
                break;
            }
            case 3: {
                n2 = 1;
                string = "toLocaleString";
                break;
            }
            case 4: {
                n2 = 0;
                string = "toSource";
                break;
            }
            case 5: {
                n2 = 0;
                string = "valueOf";
                break;
            }
            case 6: {
                n2 = 1;
                string = "toFixed";
                break;
            }
            case 7: {
                n2 = 1;
                string = "toExponential";
                break;
            }
            case 8: {
                n2 = 1;
                string = "toPrecision";
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(n));
            }
        }
        this.initPrototypeMethod(NUMBER_TAG, n, string, n2);
    }

    @Override
    public Object execIdCall(IdFunctionObject idFunctionObject, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        if (!idFunctionObject.hasTag(NUMBER_TAG)) {
            return super.execIdCall(idFunctionObject, context, scriptable, scriptable2, objectArray);
        }
        int n = idFunctionObject.methodId();
        if (n == 1) {
            double d;
            double d2 = d = objectArray.length >= 1 ? ScriptRuntime.toNumber(objectArray[0]) : 0.0;
            if (scriptable2 == null) {
                return new NativeNumber(d);
            }
            return ScriptRuntime.wrapNumber(d);
        }
        if (n < 1) {
            return this.execConstructorCall(n, objectArray);
        }
        if (!(scriptable2 instanceof NativeNumber)) {
            throw NativeNumber.incompatibleCallError(idFunctionObject);
        }
        double d = ((NativeNumber)scriptable2).doubleValue;
        switch (n) {
            case 2: 
            case 3: {
                int n2 = objectArray.length == 0 || objectArray[0] == Undefined.instance ? 10 : ScriptRuntime.toInt32(objectArray[0]);
                return ScriptRuntime.numberToString(d, n2);
            }
            case 4: {
                return "(new Number(" + ScriptRuntime.toString(d) + "))";
            }
            case 5: {
                return ScriptRuntime.wrapNumber(d);
            }
            case 6: {
                return NativeNumber.num_to(d, objectArray, 2, 2, -20, 0);
            }
            case 7: {
                if (Double.isNaN(d)) {
                    return "NaN";
                }
                if (Double.isInfinite(d)) {
                    if (d >= 0.0) {
                        return "Infinity";
                    }
                    return "-Infinity";
                }
                return NativeNumber.num_to(d, objectArray, 1, 3, 0, 1);
            }
            case 8: {
                if (objectArray.length == 0 || objectArray[0] == Undefined.instance) {
                    return ScriptRuntime.numberToString(d, 10);
                }
                if (Double.isNaN(d)) {
                    return "NaN";
                }
                if (Double.isInfinite(d)) {
                    if (d >= 0.0) {
                        return "Infinity";
                    }
                    return "-Infinity";
                }
                return NativeNumber.num_to(d, objectArray, 0, 4, 1, 0);
            }
        }
        throw new IllegalArgumentException(String.valueOf(n));
    }

    private Object execConstructorCall(int n, Object[] objectArray) {
        switch (n) {
            case -1: {
                if (objectArray.length == 0 || Undefined.instance == objectArray[0]) {
                    return false;
                }
                if (objectArray[0] instanceof Number) {
                    return NativeNumber.isFinite(objectArray[0]);
                }
                return false;
            }
            case -2: {
                if (objectArray.length == 0 || Undefined.instance == objectArray[0]) {
                    return false;
                }
                if (objectArray[0] instanceof Number) {
                    return this.isNaN((Number)objectArray[0]);
                }
                return false;
            }
            case -3: {
                if (objectArray.length == 0 || Undefined.instance == objectArray[0]) {
                    return false;
                }
                if (objectArray[0] instanceof Number) {
                    return this.isInteger((Number)objectArray[0]);
                }
                return false;
            }
            case -4: {
                if (objectArray.length == 0 || Undefined.instance == objectArray[0]) {
                    return false;
                }
                if (objectArray[0] instanceof Number) {
                    return this.isSafeInteger((Number)objectArray[0]);
                }
                return false;
            }
            case -5: {
                return NativeGlobal.js_parseFloat(objectArray);
            }
            case -6: {
                return NativeGlobal.js_parseInt(objectArray);
            }
        }
        throw new IllegalArgumentException(String.valueOf(n));
    }

    public String toString() {
        return ScriptRuntime.numberToString(this.doubleValue, 10);
    }

    private static String num_to(double d, Object[] objectArray, int n, int n2, int n3, int n4) {
        int n5;
        if (objectArray.length == 0) {
            n5 = 0;
            n2 = n;
        } else {
            double d2 = ScriptRuntime.toInteger(objectArray[0]);
            if (d2 < (double)n3 || d2 > 100.0) {
                String string = ScriptRuntime.getMessage1("msg.bad.precision", ScriptRuntime.toString(objectArray[0]));
                throw ScriptRuntime.constructError("RangeError", string);
            }
            n5 = ScriptRuntime.toInt32(d2);
        }
        StringBuilder stringBuilder = new StringBuilder();
        DToA.JS_dtostr(stringBuilder, n2, n5 + n4, d);
        return stringBuilder.toString();
    }

    static Object isFinite(Object object) {
        double d = ScriptRuntime.toNumber(object);
        Double d2 = d;
        return ScriptRuntime.wrapBoolean(!d2.isInfinite() && !d2.isNaN());
    }

    private Object isNaN(Number number) {
        Double d = this.doubleVal(number);
        return ScriptRuntime.toBoolean(this.isDoubleNan(d));
    }

    private boolean isDoubleNan(Double d) {
        return d.isNaN();
    }

    private boolean isInteger(Number number) {
        Double d = this.doubleVal(number);
        return ScriptRuntime.toBoolean(this.isDoubleInteger(d));
    }

    private boolean isDoubleInteger(Double d) {
        return !d.isInfinite() && !d.isNaN() && Math.floor(d) == d;
    }

    private boolean isSafeInteger(Number number) {
        Double d = this.doubleVal(number);
        return ScriptRuntime.toBoolean(this.isDoubleSafeInteger(d));
    }

    private boolean isDoubleSafeInteger(Double d) {
        return this.isDoubleInteger(d) && d <= MAX_SAFE_INTEGER && d >= MIN_SAFE_INTEGER;
    }

    private Double doubleVal(Number number) {
        if (number instanceof Double) {
            return (Double)number;
        }
        double d = number.doubleValue();
        return d;
    }

    @Override
    protected int findPrototypeId(String string) {
        int n;
        block10: {
            n = 0;
            String string2 = null;
            switch (string.length()) {
                case 7: {
                    char c = string.charAt(0);
                    if (c == 't') {
                        string2 = "toFixed";
                        n = 6;
                        break;
                    }
                    if (c != 'v') break;
                    string2 = "valueOf";
                    n = 5;
                    break;
                }
                case 8: {
                    char c = string.charAt(3);
                    if (c == 'o') {
                        string2 = "toSource";
                        n = 4;
                        break;
                    }
                    if (c != 't') break;
                    string2 = "toString";
                    n = 2;
                    break;
                }
                case 11: {
                    char c = string.charAt(0);
                    if (c == 'c') {
                        string2 = "constructor";
                        n = 1;
                        break;
                    }
                    if (c != 't') break;
                    string2 = "toPrecision";
                    n = 8;
                    break;
                }
                case 13: {
                    string2 = "toExponential";
                    n = 7;
                    break;
                }
                case 14: {
                    string2 = "toLocaleString";
                    n = 3;
                    break;
                }
            }
            if (string2 == null || string2 == string || string2.equals(string)) break block10;
            n = 0;
        }
        return n;
    }
}

