/*
 * Decompiled with CFR 0.152.
 */
package sbt;

import java.io.File;
import java.io.Serializable;
import sbt.State;
import sbt.State$;
import sbt.internal.librarymanagement.cross.CrossVersionUtil$;
import sbt.internal.util.AttributeKey;
import sbt.internal.util.AttributeKey$;
import sbt.io.FileFilter;
import sbt.io.FileFilter$;
import sbt.io.GlobFilter$;
import sbt.io.Path$;
import sbt.io.RichFile$;
import sbt.io.syntax$;
import sbt.util.OptJsonWriter;
import sbt.util.OptJsonWriter$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxesRunTime;
import xsbti.compile.ScalaInstance;

public final class BuildPaths$ {
    public static BuildPaths$ MODULE$;
    private final AttributeKey<File> globalBaseDirectory;
    private final AttributeKey<File> globalPluginsDirectory;
    private final AttributeKey<File> globalSettingsDirectory;
    private final AttributeKey<File> stagingDirectory;
    private final AttributeKey<File> dependencyBaseDirectory;
    private final AttributeKey<File> globalZincDirectory;

    static {
        new BuildPaths$();
    }

    public AttributeKey<File> globalBaseDirectory() {
        return this.globalBaseDirectory;
    }

    public AttributeKey<File> globalPluginsDirectory() {
        return this.globalPluginsDirectory;
    }

    public AttributeKey<File> globalSettingsDirectory() {
        return this.globalSettingsDirectory;
    }

    public AttributeKey<File> stagingDirectory() {
        return this.stagingDirectory;
    }

    public AttributeKey<File> dependencyBaseDirectory() {
        return this.dependencyBaseDirectory;
    }

    public AttributeKey<File> globalZincDirectory() {
        return this.globalZincDirectory;
    }

    public File getGlobalBase(State state) {
        File file = this.defaultVersionedGlobalBase(this.binarySbtVersion(state));
        return this.getFileSetting(this.globalBaseDirectory(), "sbt.global.base", (Function0<File>)(Function0 & Serializable & scala.Serializable)() -> this.getDefault$1(state, file), state);
    }

    private void checkTransition(State state, File versioned) {
        block0: {
            boolean warnTransition;
            File unversioned = this.defaultGlobalBase();
            boolean bl = warnTransition = !this.globalDefined$1(versioned, state) && this.globalDefined$1(unversioned, state);
            if (!warnTransition) break block0;
            State$.MODULE$.stateOps(state).log().warn((Function0 & Serializable & scala.Serializable)() -> MODULE$.globalDirTransitionWarning(unversioned, versioned));
        }
    }

    public File getStagingDirectory(State state, File globalBase) {
        return this.fileSetting(this.stagingDirectory(), "sbt.global.staging", this.defaultStaging(globalBase), state);
    }

    public File getGlobalPluginsDirectory(State state, File globalBase) {
        return this.fileSetting(this.globalPluginsDirectory(), "sbt.global.plugins", this.defaultGlobalPlugins(globalBase), state);
    }

    public File getGlobalSettingsDirectory(State state, File globalBase) {
        return this.fileSetting(this.globalSettingsDirectory(), "sbt.global.settings", globalBase, state);
    }

    public File getDependencyDirectory(State state, File globalBase) {
        return this.fileSetting(this.dependencyBaseDirectory(), "sbt.dependency.base", this.defaultDependencyBase(globalBase), state);
    }

    public File getZincDirectory(State state, File globalBase) {
        return this.fileSetting(this.globalZincDirectory(), "sbt.global.zinc", this.defaultGlobalZinc(globalBase), state);
    }

    private File fileSetting(AttributeKey<File> stateKey, String property, File file, State state) {
        return this.getFileSetting(stateKey, property, (Function0<File>)(Function0 & Serializable & scala.Serializable)() -> file, state);
    }

    public File getFileSetting(AttributeKey<File> stateKey, String property, Function0<File> function0, State state) {
        return (File)State$.MODULE$.stateOps(state).get(stateKey).orElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.getFileProperty(property)).getOrElse(function0);
    }

    public Option<File> getFileProperty(String name) {
        return Option$.MODULE$.apply((Object)System.getProperty(name)).flatMap((Function1 & Serializable & scala.Serializable)path -> path.isEmpty() ? None$.MODULE$ : new Some((Object)new File((String)path)));
    }

    public File defaultVersionedGlobalBase(String sbtVersion) {
        return RichFile$.MODULE$.$div$extension(syntax$.MODULE$.fileToRichFile(this.defaultGlobalBase()), sbtVersion);
    }

    public File defaultGlobalBase() {
        return RichFile$.MODULE$.$div$extension(syntax$.MODULE$.fileToRichFile(Path$.MODULE$.userHome()), ".sbt");
    }

    private String binarySbtVersion(State state) {
        return CrossVersionUtil$.MODULE$.binarySbtVersion(state.configuration().provider().id().version());
    }

    private File defaultStaging(File globalBase) {
        return RichFile$.MODULE$.$div$extension(syntax$.MODULE$.fileToRichFile(globalBase), "staging");
    }

    private File defaultGlobalPlugins(File globalBase) {
        return RichFile$.MODULE$.$div$extension(syntax$.MODULE$.fileToRichFile(globalBase), "plugins");
    }

    private File defaultDependencyBase(File globalBase) {
        return RichFile$.MODULE$.$div$extension(syntax$.MODULE$.fileToRichFile(globalBase), "dependency");
    }

    private File defaultGlobalZinc(File globalBase) {
        return RichFile$.MODULE$.$div$extension(syntax$.MODULE$.fileToRichFile(globalBase), "zinc");
    }

    public Seq<File> configurationSources(File base) {
        return syntax$.MODULE$.singleFileFinder(base).$times((FileFilter)GlobFilter$.MODULE$.apply("*.sbt").$minus(FileFilter$.MODULE$.globFilter(".sbt"))).get();
    }

    public File pluginDirectory(File definitionBase) {
        return RichFile$.MODULE$.$div$extension(syntax$.MODULE$.fileToRichFile(definitionBase), "plugins");
    }

    public File evalOutputDirectory(File base) {
        return RichFile$.MODULE$.$div$extension(syntax$.MODULE$.fileToRichFile(this.outputDirectory(base)), "config-classes");
    }

    public File outputDirectory(File base) {
        return RichFile$.MODULE$.$div$extension(syntax$.MODULE$.fileToRichFile(base), "target");
    }

    public File projectStandard(File base) {
        return RichFile$.MODULE$.$div$extension(syntax$.MODULE$.fileToRichFile(base), "project");
    }

    public final String PluginsDirectoryName() {
        return "plugins";
    }

    public final String DefaultTargetName() {
        return "target";
    }

    public final String ConfigDirectoryName() {
        return ".sbt";
    }

    public final String GlobalBaseProperty() {
        return "sbt.global.base";
    }

    public final String StagingProperty() {
        return "sbt.global.staging";
    }

    public final String GlobalPluginsProperty() {
        return "sbt.global.plugins";
    }

    public final String GlobalSettingsProperty() {
        return "sbt.global.settings";
    }

    public final String DependencyBaseProperty() {
        return "sbt.dependency.base";
    }

    public final String GlobalZincProperty() {
        return "sbt.global.zinc";
    }

    public File crossPath(File base, ScalaInstance instance) {
        return RichFile$.MODULE$.$div$extension(syntax$.MODULE$.fileToRichFile(base), "scala_" + instance.version());
    }

    private String globalDirTransitionWarning(File unversioned, File versioned) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The global sbt directory is now versioned and is located at ", ".\n  You are seeing this warning because there is global configuration in ", " but not in ", ".\n  The global sbt directory may be changed via the ", " system property.\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{versioned, unversioned, versioned, "sbt.global.base"}));
    }

    private final File getDefault$1(State state$1, File default$1) {
        this.checkTransition(state$1, default$1);
        return default$1;
    }

    private final boolean globalDefined$1(File base, State state$2) {
        return this.getGlobalPluginsDirectory(state$2, base).exists() || this.configurationSources(this.getGlobalSettingsDirectory(state$2, base)).exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.exists()));
    }

    private BuildPaths$() {
        MODULE$ = this;
        this.globalBaseDirectory = AttributeKey$.MODULE$.apply("global-base-directory", "The base directory for global sbt configuration and staging.", 10000, ManifestFactory$.MODULE$.classType(File.class), (OptJsonWriter)OptJsonWriter$.MODULE$.fallback());
        this.globalPluginsDirectory = AttributeKey$.MODULE$.apply("global-plugins-directory", "The base directory for global sbt plugins.", 10000, ManifestFactory$.MODULE$.classType(File.class), (OptJsonWriter)OptJsonWriter$.MODULE$.fallback());
        this.globalSettingsDirectory = AttributeKey$.MODULE$.apply("global-settings-directory", "The base directory for global sbt settings.", 10000, ManifestFactory$.MODULE$.classType(File.class), (OptJsonWriter)OptJsonWriter$.MODULE$.fallback());
        this.stagingDirectory = AttributeKey$.MODULE$.apply("staging-directory", "The directory for staging remote projects.", 10000, ManifestFactory$.MODULE$.classType(File.class), (OptJsonWriter)OptJsonWriter$.MODULE$.fallback());
        this.dependencyBaseDirectory = AttributeKey$.MODULE$.apply("dependency-base-directory", "The base directory for caching dependency resolution.", 10000, ManifestFactory$.MODULE$.classType(File.class), (OptJsonWriter)OptJsonWriter$.MODULE$.fallback());
        this.globalZincDirectory = AttributeKey$.MODULE$.apply("global-zinc-directory", "The base directory for Zinc internals.", 10000, ManifestFactory$.MODULE$.classType(File.class), (OptJsonWriter)OptJsonWriter$.MODULE$.fallback());
    }
}

