#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: crypto-pubkey
version: 0.2.8
id: crypto-pubkey-0.2.8-CVTpgB2EELO5bfo5nddrkE
key: crypto-pubkey-0.2.8-CVTpgB2EELO5bfo5nddrkE
license: BSD3
copyright: Vincent Hanquez <vincent@snarc.org>
maintainer: Vincent Hanquez <vincent@snarc.org>
homepage: https://github.com/vincenthz/hs-crypto-pubkey
synopsis: Public Key cryptography
description:
    Public Key cryptography
    .
    Supports RSA PKCS15, RSA OAEP, RSA PSS, DSA, ElGamal signature.
    .
    Also have primitive support for Diffie Hellman, and ElGamal encryption
category: Cryptography
author: Vincent Hanquez <vincent@snarc.org>
exposed: True
exposed-modules:
    Crypto.PubKey.RSA Crypto.PubKey.RSA.PKCS15 Crypto.PubKey.RSA.OAEP
    Crypto.PubKey.RSA.PSS Crypto.PubKey.RSA.Prim Crypto.PubKey.DSA
    Crypto.PubKey.DH Crypto.PubKey.HashDescr
    Crypto.PubKey.MaskGenFunction Crypto.PubKey.ECC.Generate
    Crypto.PubKey.ECC.Prim Crypto.PubKey.ECC.DH Crypto.PubKey.ECC.ECDSA
hidden-modules: Crypto.PubKey.ElGamal Crypto.PubKey.RSA.Types
                Crypto.PubKey.Internal
abi: f5fa8a8f1fea13f83761537fad4c9983
trusted: False
import-dirs: /usr/lib/ghc-8.0.2/site-local/crypto-pubkey-0.2.8
library-dirs: /usr/lib/ghc-8.0.2/site-local/crypto-pubkey-0.2.8
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.0.2/crypto-pubkey-0.2.8
hs-libraries: HScrypto-pubkey-0.2.8-CVTpgB2EELO5bfo5nddrkE
depends:
    base-4.9.1.0 byteable-0.1.1-2lU1pexQSLj1KbNO17UifQ
    bytestring-0.10.8.1 crypto-numbers-0.2.7-Avt58yp2bGL75xD80p4jyW
    crypto-pubkey-types-0.4.3-9GfhzDdwQCrIYxAOnYPyS9
    crypto-random-0.0.9-HjtNIZKy9iZCjScOTAAUrw
    cryptohash-0.11.9-nV9PicWnhFKGeRwzGvWXI
haddock-interfaces: /usr/share/doc/haskell-crypto-pubkey/html/crypto-pubkey.haddock
haddock-html: /usr/share/doc/haskell-crypto-pubkey/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"
