/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.resources.selectors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.resources.selectors.ResourceSelector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceSelectorContainer
extends DataType {
    private final List<ResourceSelector> resourceSelectors = new ArrayList<ResourceSelector>();

    public ResourceSelectorContainer() {
    }

    public ResourceSelectorContainer(ResourceSelector[] r) {
        for (int i = 0; i < r.length; ++i) {
            this.add(r[i]);
        }
    }

    public void add(ResourceSelector s) {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        if (s == null) {
            return;
        }
        this.resourceSelectors.add(s);
        this.setChecked(false);
    }

    public boolean hasSelectors() {
        if (this.isReference()) {
            return ((ResourceSelectorContainer)this.getCheckedRef()).hasSelectors();
        }
        this.dieOnCircularReference();
        return !this.resourceSelectors.isEmpty();
    }

    public int selectorCount() {
        if (this.isReference()) {
            return ((ResourceSelectorContainer)this.getCheckedRef()).selectorCount();
        }
        this.dieOnCircularReference();
        return this.resourceSelectors.size();
    }

    public Iterator<ResourceSelector> getSelectors() {
        if (this.isReference()) {
            return ((ResourceSelectorContainer)this.getCheckedRef()).getSelectors();
        }
        this.dieOnCircularReference();
        return Collections.unmodifiableList(this.resourceSelectors).iterator();
    }

    @Override
    protected void dieOnCircularReference(Stack<Object> stk, Project p) throws BuildException {
        if (this.isChecked()) {
            return;
        }
        if (this.isReference()) {
            super.dieOnCircularReference(stk, p);
        } else {
            for (ResourceSelector resourceSelector : this.resourceSelectors) {
                if (!(resourceSelector instanceof DataType)) continue;
                ResourceSelectorContainer.pushAndInvokeCircularReferenceCheck((DataType)((Object)resourceSelector), stk, p);
            }
            this.setChecked(true);
        }
    }
}

