/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openstreetmap.josm.actions.upload.CyclicUploadDependencyException;
import org.openstreetmap.josm.data.conflict.ConflictCollection;
import org.openstreetmap.josm.data.osm.AbstractPrimitive;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveComparator;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.Utils;

public class APIDataSet {
    private List<OsmPrimitive> toAdd = new LinkedList<OsmPrimitive>();
    private List<OsmPrimitive> toUpdate = new LinkedList<OsmPrimitive>();
    private List<OsmPrimitive> toDelete = new LinkedList<OsmPrimitive>();

    public APIDataSet() {
    }

    public void init(DataSet dataSet) {
        if (dataSet == null) {
            return;
        }
        this.init(dataSet.allPrimitives());
    }

    public final void init(Collection<OsmPrimitive> collection) {
        this.toAdd.clear();
        this.toUpdate.clear();
        this.toDelete.clear();
        for (OsmPrimitive object2 : collection) {
            if (object2.isNewOrUndeleted() && !object2.isDeleted()) {
                this.toAdd.add(object2);
                continue;
            }
            if (object2.isModified() && !object2.isDeleted()) {
                this.toUpdate.add(object2);
                continue;
            }
            if (!object2.isDeleted() || object2.isNew() || !object2.isModified() || !object2.isVisible()) continue;
            this.toDelete.add(object2);
        }
        Comparator<OsmPrimitive> comparator = OsmPrimitiveComparator.orderingNodesWaysRelations();
        Comparator<OsmPrimitive> comparator2 = OsmPrimitiveComparator.comparingUniqueId();
        this.toAdd.sort(comparator.thenComparing(comparator2));
        this.toUpdate.sort(comparator.thenComparing(comparator2));
        this.toDelete.sort(comparator.reversed().thenComparing(comparator2));
    }

    public APIDataSet(DataSet dataSet) {
        this();
        this.init(dataSet);
    }

    public boolean participatesInConflict(ConflictCollection conflictCollection) {
        if (conflictCollection == null || conflictCollection.isEmpty()) {
            return false;
        }
        Set set = conflictCollection.get().stream().flatMap(conflict -> Stream.of(conflict.getMy(), conflict.getTheir())).map(AbstractPrimitive::getPrimitiveId).collect(Collectors.toSet());
        return Stream.of(this.toUpdate, this.toDelete).flatMap(Collection::stream).map(AbstractPrimitive::getPrimitiveId).anyMatch(set::contains);
    }

    public APIDataSet(Collection<OsmPrimitive> collection) {
        this();
        this.init(collection);
    }

    public boolean isEmpty() {
        return this.toAdd.isEmpty() && this.toUpdate.isEmpty() && this.toDelete.isEmpty();
    }

    public List<OsmPrimitive> getPrimitivesToAdd() {
        return this.toAdd;
    }

    public List<OsmPrimitive> getPrimitivesToUpdate() {
        return this.toUpdate;
    }

    public List<OsmPrimitive> getPrimitivesToDelete() {
        return this.toDelete;
    }

    public List<OsmPrimitive> getPrimitives() {
        LinkedList<OsmPrimitive> linkedList = new LinkedList<OsmPrimitive>();
        linkedList.addAll(this.toAdd);
        linkedList.addAll(this.toUpdate);
        linkedList.addAll(this.toDelete);
        return linkedList;
    }

    public int getSize() {
        return this.toAdd.size() + this.toUpdate.size() + this.toDelete.size();
    }

    public void removeProcessed(Collection<IPrimitive> collection) {
        if (collection == null) {
            return;
        }
        this.toAdd.removeAll(collection);
        this.toUpdate.removeAll(collection);
        this.toDelete.removeAll(collection);
    }

    public void adjustRelationUploadOrder() throws CyclicUploadDependencyException {
        LinkedList<OsmPrimitive> linkedList = new LinkedList<OsmPrimitive>();
        linkedList.addAll(Utils.filteredCollection(this.toAdd, Node.class));
        linkedList.addAll(Utils.filteredCollection(this.toAdd, Way.class));
        ArrayList<Relation> arrayList = new ArrayList<Relation>(Utils.filteredCollection(this.toAdd, Relation.class));
        List<Relation> list = this.filterRelationsNotReferringToNewRelations(arrayList);
        linkedList.addAll(list);
        arrayList.removeAll(list);
        RelationUploadDependencyGraph relationUploadDependencyGraph = new RelationUploadDependencyGraph(arrayList, true);
        linkedList.addAll(relationUploadDependencyGraph.computeUploadOrder());
        this.toAdd = linkedList;
        LinkedList<OsmPrimitive> linkedList2 = new LinkedList<OsmPrimitive>();
        relationUploadDependencyGraph = new RelationUploadDependencyGraph(Utils.filteredCollection(this.toDelete, Relation.class), false);
        linkedList2.addAll(relationUploadDependencyGraph.computeUploadOrder());
        linkedList2.addAll(Utils.filteredCollection(this.toDelete, Way.class));
        linkedList2.addAll(Utils.filteredCollection(this.toDelete, Node.class));
        this.toDelete = linkedList2;
    }

    protected List<Relation> filterRelationsNotReferringToNewRelations(Collection<Relation> collection) {
        LinkedList<Relation> linkedList = new LinkedList<Relation>();
        for (Relation relation : collection) {
            boolean bl = false;
            for (RelationMember relationMember : relation.getMembers()) {
                if (!relationMember.isRelation() || !relationMember.getMember().isNewOrUndeleted()) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            linkedList.add(relation);
        }
        return linkedList;
    }

    private static class RelationUploadDependencyGraph {
        private final Map<Relation, Set<Relation>> children = new HashMap<Relation, Set<Relation>>();
        private Collection<Relation> relations;
        private Set<Relation> visited = new HashSet<Relation>();
        private List<Relation> uploadOrder;
        private final boolean newOrUndeleted;

        RelationUploadDependencyGraph(Collection<Relation> collection, boolean bl) {
            this.newOrUndeleted = bl;
            this.build(collection);
        }

        public final void build(Collection<Relation> collection) {
            this.relations = new HashSet<Relation>();
            for (Relation relation : collection) {
                if (this.newOrUndeleted ? !relation.isNewOrUndeleted() : !relation.isDeleted()) continue;
                this.relations.add(relation);
                for (RelationMember relationMember : relation.getMembers()) {
                    if (!relationMember.isRelation() || !(this.newOrUndeleted ? relationMember.getMember().isNewOrUndeleted() : relationMember.getMember().isDeleted())) continue;
                    this.addDependency(relation, (Relation)relationMember.getMember());
                }
            }
        }

        public Set<Relation> getChildren(Relation relation) {
            Set<Relation> set = this.children.get(relation);
            if (set == null) {
                set = new HashSet<Relation>();
                this.children.put(relation, set);
            }
            return set;
        }

        public void addDependency(Relation relation, Relation relation2) {
            this.getChildren(relation).add(relation2);
        }

        protected void visit(Stack<Relation> stack, Relation relation) throws CyclicUploadDependencyException {
            if (stack.contains(relation)) {
                stack.push(relation);
                throw new CyclicUploadDependencyException(stack);
            }
            if (!this.visited.contains(relation)) {
                stack.push(relation);
                this.visited.add(relation);
                for (Relation relation2 : this.getChildren(relation)) {
                    this.visit(stack, relation2);
                }
                this.uploadOrder.add(relation);
                stack.pop();
            }
        }

        public List<Relation> computeUploadOrder() throws CyclicUploadDependencyException {
            this.visited = new HashSet<Relation>();
            this.uploadOrder = new LinkedList<Relation>();
            Stack<Relation> stack = new Stack<Relation>();
            for (Relation relation : this.relations) {
                this.visit(stack, relation);
            }
            ArrayList<Relation> arrayList = new ArrayList<Relation>(this.relations);
            arrayList.sort(Comparator.comparingInt(this.uploadOrder::indexOf));
            return arrayList;
        }
    }
}

