/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.imagery;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.gui.jmapviewer.interfaces.TemplatedTileSource;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.imagery.AbstractWMSTileSource;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.gui.layer.WMSLayer;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;

public class TemplatedWMSTileSource
extends AbstractWMSTileSource
implements TemplatedTileSource {
    private final Map<String, String> headers = new ConcurrentHashMap<String, String>();
    private final Set<String> serverProjections;
    private static final Pattern PATTERN_HEADER = Pattern.compile("\\{header\\(([^,]+),([^}]+)\\)\\}");
    private static final Pattern PATTERN_PROJ = Pattern.compile("\\{proj\\}");
    private static final Pattern PATTERN_WKID = Pattern.compile("\\{wkid\\}");
    private static final Pattern PATTERN_BBOX = Pattern.compile("\\{bbox\\}");
    private static final Pattern PATTERN_W = Pattern.compile("\\{w\\}");
    private static final Pattern PATTERN_S = Pattern.compile("\\{s\\}");
    private static final Pattern PATTERN_E = Pattern.compile("\\{e\\}");
    private static final Pattern PATTERN_N = Pattern.compile("\\{n\\}");
    private static final Pattern PATTERN_WIDTH = Pattern.compile("\\{width\\}");
    private static final Pattern PATTERN_HEIGHT = Pattern.compile("\\{height\\}");
    private static final Pattern PATTERN_PARAM = Pattern.compile("\\{([^}]+)\\}");
    private static final NumberFormat LATLON_FORMAT = new DecimalFormat("###0.0000000", new DecimalFormatSymbols(Locale.US));
    private static final Pattern[] ALL_PATTERNS = new Pattern[]{PATTERN_HEADER, PATTERN_PROJ, PATTERN_WKID, PATTERN_BBOX, PATTERN_W, PATTERN_S, PATTERN_E, PATTERN_N, PATTERN_WIDTH, PATTERN_HEIGHT};

    public TemplatedWMSTileSource(ImageryInfo imageryInfo, Projection projection) {
        super(imageryInfo, projection);
        this.serverProjections = new TreeSet<String>(imageryInfo.getServerProjections());
        this.handleTemplate();
        this.initProjection();
    }

    @Override
    public int getDefaultTileSize() {
        return WMSLayer.PROP_IMAGE_SIZE.get();
    }

    @Override
    public String getTileUrl(int n, int n2, int n3) {
        String string = this.getServerCRS();
        EastNorth eastNorth = this.getTileEastNorth(n2, n3, n);
        EastNorth eastNorth2 = this.getTileEastNorth(n2 + 1, n3 + 1, n);
        double d = eastNorth.getX();
        double d2 = eastNorth.getY();
        double d3 = eastNorth2.getY();
        double d4 = eastNorth2.getX();
        if ("EPSG:4326".equals(string) && !this.serverProjections.contains(string) && this.serverProjections.contains("CRS:84")) {
            string = "CRS:84";
        }
        boolean bl = false;
        if (this.baseUrl.toLowerCase(Locale.US).contains("crs=epsg:4326")) {
            bl = true;
        } else if (this.baseUrl.toLowerCase(Locale.US).contains("crs=")) {
            bl = Main.getProjection().switchXY();
        }
        String string2 = bl ? String.format("%s,%s,%s,%s", LATLON_FORMAT.format(d3), LATLON_FORMAT.format(d), LATLON_FORMAT.format(d2), LATLON_FORMAT.format(d4)) : String.format("%s,%s,%s,%s", LATLON_FORMAT.format(d), LATLON_FORMAT.format(d3), LATLON_FORMAT.format(d4), LATLON_FORMAT.format(d2));
        StringBuffer stringBuffer = new StringBuffer(this.baseUrl.length());
        Matcher matcher = PATTERN_PARAM.matcher(this.baseUrl);
        while (matcher.find()) {
            String string3;
            switch (matcher.group(1)) {
                case "proj": {
                    string3 = string;
                    break;
                }
                case "wkid": {
                    string3 = string.startsWith("EPSG:") ? string.substring(5) : string;
                    break;
                }
                case "bbox": {
                    string3 = string2;
                    break;
                }
                case "w": {
                    string3 = LATLON_FORMAT.format(d);
                    break;
                }
                case "s": {
                    string3 = LATLON_FORMAT.format(d3);
                    break;
                }
                case "e": {
                    string3 = LATLON_FORMAT.format(d4);
                    break;
                }
                case "n": {
                    string3 = LATLON_FORMAT.format(d2);
                    break;
                }
                case "width": 
                case "height": {
                    string3 = String.valueOf(this.getTileSize());
                    break;
                }
                default: {
                    string3 = '{' + matcher.group(1) + '}';
                }
            }
            matcher.appendReplacement(stringBuffer, string3);
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString().replace(" ", "%20");
    }

    @Override
    public String getTileId(int n, int n2, int n3) {
        return this.getTileUrl(n, n2, n3);
    }

    @Override
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public static void checkUrl(String string) {
        CheckParameterUtil.ensureParameterNotNull(string, "url");
        Matcher matcher = PATTERN_PARAM.matcher(string);
        while (matcher.find()) {
            boolean bl = false;
            for (Pattern pattern : ALL_PATTERNS) {
                if (!pattern.matcher(matcher.group()).matches()) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            throw new IllegalArgumentException(I18n.tr("{0} is not a valid WMS argument. Please check this server URL:\n{1}", matcher.group(), string));
        }
    }

    private void handleTemplate() {
        StringBuffer stringBuffer = new StringBuffer();
        Matcher matcher = PATTERN_HEADER.matcher(this.baseUrl);
        while (matcher.find()) {
            this.headers.put(matcher.group(1), matcher.group(2));
            matcher.appendReplacement(stringBuffer, "");
        }
        matcher.appendTail(stringBuffer);
        this.baseUrl = stringBuffer.toString();
    }
}

