/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.preferences;

import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.preferences.AbstractProperty;
import org.openstreetmap.josm.data.preferences.AbstractToStringProperty;

public class IntegerProperty
extends AbstractToStringProperty<Integer> {
    public IntegerProperty(String string, int n) {
        super(string, n);
        if (Main.pref != null) {
            this.get();
        }
    }

    @Override
    public Integer get() {
        return (Integer)super.get();
    }

    @Override
    public boolean put(Integer n) {
        return super.put(n);
    }

    @Override
    protected Integer fromString(String string) {
        try {
            return Integer.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new AbstractProperty.InvalidPreferenceValueException(numberFormatException);
        }
    }

    @Override
    protected String toString(Integer n) {
        return n.toString();
    }

    public boolean parseAndPut(String string) {
        try {
            return this.put(Integer.valueOf(string));
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }
}

