/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.Closeable;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;

public class XmlWriter
implements Closeable {
    protected final PrintWriter out;
    private static final Map<Character, String> ENCODING = new HashMap<Character, String>();

    public XmlWriter(PrintWriter printWriter) {
        this.out = printWriter;
    }

    public void flush() {
        if (this.out != null) {
            this.out.flush();
        }
    }

    public static String encode(String string) {
        return XmlWriter.encode(string, false);
    }

    public static String encode(String string, boolean bl) {
        StringBuilder stringBuilder = null;
        if (string != null) {
            for (int i = 0; i < string.length(); ++i) {
                String string2 = null;
                if (!bl || string.charAt(i) != '\'') {
                    string2 = ENCODING.get(Character.valueOf(string.charAt(i)));
                }
                if (string2 != null) {
                    if (stringBuilder == null) {
                        stringBuilder = new StringBuilder(string.substring(0, i));
                    }
                    stringBuilder.append(string2);
                    continue;
                }
                if (stringBuilder == null) continue;
                stringBuilder.append(string.charAt(i));
            }
        }
        return stringBuilder == null ? string : stringBuilder.toString();
    }

    @Override
    public void close() throws IOException {
        if (this.out != null) {
            this.out.close();
        }
    }

    static {
        ENCODING.put(Character.valueOf('<'), "&lt;");
        ENCODING.put(Character.valueOf('>'), "&gt;");
        ENCODING.put(Character.valueOf('\"'), "&quot;");
        ENCODING.put(Character.valueOf('\''), "&apos;");
        ENCODING.put(Character.valueOf('&'), "&amp;");
        ENCODING.put(Character.valueOf('\n'), "&#xA;");
        ENCODING.put(Character.valueOf('\r'), "&#xD;");
        ENCODING.put(Character.valueOf('\t'), "&#x9;");
    }
}

