/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.PrioritizedDocumentListener;
import com.intellij.openapi.editor.ex.PrioritizedInternalDocumentListener;
import com.intellij.openapi.editor.ex.RangeMarkerEx;
import com.intellij.openapi.editor.impl.IntervalTreeImpl;
import com.intellij.openapi.editor.impl.RangeMarkerImpl;
import com.intellij.openapi.editor.impl.RedBlackTree;
import com.intellij.openapi.util.Getter;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RangeMarkerTree<T extends RangeMarkerEx>
extends IntervalTreeImpl<T> {
    private final PrioritizedDocumentListener myListener;
    private final Document myDocument;

    protected RangeMarkerTree(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/editor/impl/RangeMarkerTree", "<init>"));
        }
        this.myDocument = document;
        this.myListener = new PrioritizedInternalDocumentListener(){

            @Override
            public int getPriority() {
                return 40;
            }

            @Override
            public void beforeDocumentChange(DocumentEvent event) {
            }

            @Override
            public void documentChanged(DocumentEvent e) {
                RangeMarkerTree.this.updateMarkersOnChange(e);
            }
        };
        document.addDocumentListener(this.myListener);
    }

    @Override
    protected int compareEqualStartIntervals(@NotNull IntervalTreeImpl.IntervalNode<T> i1, @NotNull IntervalTreeImpl.IntervalNode<T> i2) {
        boolean greedyR2;
        int o2Length;
        boolean greedyL2;
        if (i1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "i1", "com/intellij/openapi/editor/impl/RangeMarkerTree", "compareEqualStartIntervals"));
        }
        if (i2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "i2", "com/intellij/openapi/editor/impl/RangeMarkerTree", "compareEqualStartIntervals"));
        }
        RMNode o1 = (RMNode)i1;
        RMNode o2 = (RMNode)i2;
        boolean greedyL1 = o1.isGreedyToLeft();
        if (greedyL1 != (greedyL2 = o2.isGreedyToLeft())) {
            return greedyL1 ? -1 : 1;
        }
        int o1Length = o1.intervalEnd() - o1.intervalStart();
        int d = o1Length - (o2Length = o2.intervalEnd() - o2.intervalStart());
        if (d != 0) {
            return d;
        }
        boolean greedyR1 = o1.isGreedyToRight();
        if (greedyR1 != (greedyR2 = o2.isGreedyToRight())) {
            return greedyR1 ? -1 : 1;
        }
        return 0;
    }

    void dispose() {
        this.myDocument.removeDocumentListener(this.myListener);
    }

    @Override
    protected void checkBelongsToTheTree(@NotNull T interval, boolean assertInvalid) {
        if (interval == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interval", "com/intellij/openapi/editor/impl/RangeMarkerTree", "checkBelongsToTheTree"));
        }
        assert (interval.getDocument() == this.myDocument);
        super.checkBelongsToTheTree(interval, assertInvalid);
    }

    @Override
    protected RMNode<T> lookupNode(@NotNull T key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/editor/impl/RangeMarkerTree", "lookupNode"));
        }
        return ((RangeMarkerImpl)key).myNode;
    }

    @Override
    protected void setNode(@NotNull T key, IntervalTreeImpl.IntervalNode<T> intervalNode) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/editor/impl/RangeMarkerTree", "setNode"));
        }
        ((RangeMarkerImpl)key).myNode = (RMNode)intervalNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMarkersOnChange(@NotNull DocumentEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/RangeMarkerTree", "updateMarkersOnChange"));
        }
        try {
            this.l.writeLock().lock();
            if (this.size() == 0) {
                return;
            }
            this.checkMax(true);
            ++this.modCount;
            SmartList<IntervalTreeImpl.IntervalNode<T>> affected = new SmartList<IntervalTreeImpl.IntervalNode<T>>();
            this.collectAffectedMarkersAndShiftSubtrees(this.getRoot(), e, affected);
            this.checkMax(false);
            if (!affected.isEmpty()) {
                for (int i = affected.size() - 1; i >= 0; --i) {
                    IntervalTreeImpl.IntervalNode intervalNode = (IntervalTreeImpl.IntervalNode)affected.get(i);
                    int startOffset = intervalNode.intervalStart();
                    int endOffset = intervalNode.intervalEnd();
                    this.removeNode(intervalNode);
                    this.checkMax(false);
                    intervalNode.clearDelta();
                    intervalNode.setParent(null);
                    intervalNode.setLeft(null);
                    intervalNode.setRight(null);
                    intervalNode.setValid(true);
                    assert (intervalNode.intervalStart() == startOffset);
                    assert (intervalNode.intervalEnd() == endOffset);
                }
                this.checkMax(true);
                for (IntervalTreeImpl.IntervalNode intervalNode : affected) {
                    List keys = intervalNode.intervals;
                    if (keys.isEmpty()) continue;
                    RangeMarkerImpl marker = null;
                    for (int i = keys.size() - 1; i >= 0; --i) {
                        Getter key = keys.get(i);
                        marker = (RangeMarkerImpl)key.get();
                        if (marker == null) continue;
                        if (marker.isValid()) break;
                        intervalNode.removeIntervalInternal(i);
                        marker = null;
                    }
                    if (marker == null) continue;
                    marker.documentChanged(e);
                    if (marker.isValid()) {
                        this.findOrInsertWithIntervals(intervalNode);
                        assert (marker.isValid());
                        continue;
                    }
                    intervalNode.setValid(false);
                }
            }
            this.checkMax(true);
            IntervalTreeImpl.IntervalNode root2 = this.getRoot();
            assert (root2 == null || root2.maxEnd + root2.delta <= this.myDocument.getTextLength());
        }
        finally {
            this.l.writeLock().unlock();
        }
    }

    private void findOrInsertWithIntervals(IntervalTreeImpl.IntervalNode<T> node) {
        IntervalTreeImpl.IntervalNode<T> insertedNode = this.findOrInsert(node);
        if (insertedNode != node) {
            for (Getter key : node.intervals) {
                RangeMarkerEx interval = (RangeMarkerEx)key.get();
                if (interval == null) continue;
                insertedNode.addInterval(interval);
            }
        }
    }

    private boolean collectAffectedMarkersAndShiftSubtrees(@Nullable IntervalTreeImpl.IntervalNode<T> root2, @NotNull DocumentEvent e, @NotNull List<IntervalTreeImpl.IntervalNode<T>> affected) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/RangeMarkerTree", "collectAffectedMarkersAndShiftSubtrees"));
        }
        if (affected == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "affected", "com/intellij/openapi/editor/impl/RangeMarkerTree", "collectAffectedMarkersAndShiftSubtrees"));
        }
        if (root2 == null) {
            return true;
        }
        boolean norm = this.pushDelta(root2);
        int maxEnd = root2.maxEnd;
        assert (root2.isValid());
        int offset2 = e.getOffset();
        int affectedEndOffset = offset2 + e.getOldLength();
        boolean hasAliveKeys = root2.hasAliveKey(false);
        if (!hasAliveKeys) {
            affected.add(root2);
        }
        if (offset2 <= maxEnd) {
            if (affectedEndOffset < root2.intervalStart()) {
                int lengthDelta = e.getNewLength() - e.getOldLength();
                int newD = root2.changeDelta(lengthDelta);
                norm &= newD == 0;
                RedBlackTree.Node left = root2.getLeft();
                if (left != null) {
                    int newL = ((IntervalTreeImpl.IntervalNode)left).changeDelta(-lengthDelta);
                    norm &= newL == 0;
                }
                norm &= this.pushDelta(root2);
                norm &= this.collectAffectedMarkersAndShiftSubtrees((IntervalTreeImpl.IntervalNode<T>)left, e, affected);
                this.correctMax(root2, 0);
            } else {
                if (offset2 <= root2.intervalEnd()) {
                    if (hasAliveKeys) {
                        affected.add(root2);
                    }
                    root2.setValid(false);
                }
                norm &= this.collectAffectedMarkersAndShiftSubtrees((IntervalTreeImpl.IntervalNode<T>)root2.getLeft(), e, affected);
                norm &= this.collectAffectedMarkersAndShiftSubtrees((IntervalTreeImpl.IntervalNode<T>)root2.getRight(), e, affected);
                this.correctMax(root2, 0);
            }
        }
        return norm;
    }

    static class RMNode<T extends RangeMarkerEx>
    extends IntervalTreeImpl.IntervalNode<T> {
        boolean isGreedyToLeft() {
            return this.isFlagSet((byte)8);
        }

        boolean isGreedyToRight() {
            return this.isFlagSet((byte)16);
        }

        @Override
        public String toString() {
            return (this.isGreedyToLeft() ? "[" : "(") + this.intervalStart() + "," + this.intervalEnd() + (this.isGreedyToRight() ? "]" : ")");
        }
    }
}

