/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ArrayUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@FunctionalInterface
public interface CachedValueProvider<T> {
    @Nullable
    public Result<T> compute();

    public static class Result<T> {
        private static final Logger LOG = Logger.getInstance("#com.intellij.psi.util.CachedValueProvider.Result");
        private final T myValue;
        private final Object[] myDependencyItems;

        public Result(@Nullable T value, Object ... dependencyItems) {
            if (dependencyItems == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencyItems", "com/intellij/psi/util/CachedValueProvider$Result", "<init>"));
            }
            this.myValue = value;
            this.myDependencyItems = dependencyItems;
            if (dependencyItems.length == 0) {
                LOG.error("No dependencies provided which causes CachedValue to be never recalculated again. If this is intentional, please use ModificationTracker.NEVER_CHANGED");
            }
            for (int i = 0; i < dependencyItems.length; ++i) {
                if (dependencyItems[i] != null) continue;
                LOG.error("Null dependencies are not allowed, index=" + i);
            }
        }

        public T getValue() {
            return this.myValue;
        }

        @NotNull
        public Object[] getDependencyItems() {
            if (this.myDependencyItems == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/CachedValueProvider$Result", "getDependencyItems"));
            }
            return this.myDependencyItems;
        }

        public static <T> Result<T> createSingleDependency(@Nullable T value, @NotNull Object dependency) {
            if (dependency == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependency", "com/intellij/psi/util/CachedValueProvider$Result", "createSingleDependency"));
            }
            return Result.create(value, dependency);
        }

        public static <T> Result<T> create(@Nullable T value, Object ... dependencies) {
            if (dependencies == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencies", "com/intellij/psi/util/CachedValueProvider$Result", "create"));
            }
            return new Result<T>(value, dependencies);
        }

        public static <T> Result<T> create(@Nullable T value, @NotNull Collection<?> dependencies) {
            if (dependencies == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencies", "com/intellij/psi/util/CachedValueProvider$Result", "create"));
            }
            return new Result<T>(value, ArrayUtil.toObjectArray(dependencies));
        }
    }
}

