/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.google.common.collect.Lists;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.codeInsight.CommentUtilCore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.impl.SyntheticFieldDescriptor;
import org.jetbrains.kotlin.kdoc.psi.api.KDocElement;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.parsing.KotlinExpressionParsing;
import org.jetbrains.kotlin.psi.KtAnnotatedExpression;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtCatchClause;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtContainerNodeForControlStructureBody;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtDelegatedSuperTypeEntry;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtDoubleColonExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtFunctionType;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtLabelReferenceExpression;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtOperationExpression;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPostfixExpression;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtStatementExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtTryExpression;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.KtVariableDeclaration;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.StatementFilter;
import org.jetbrains.kotlin.resolve.StatementFilterKt;

public class KtPsiUtil {
    private KtPsiUtil() {
    }

    public static <D> void visitChildren(@NotNull KtElement element, @NotNull KtVisitor<Void, D> visitor2, D data) {
        if (element == null) {
            KtPsiUtil.$$$reportNull$$$0(0);
        }
        if (visitor2 == null) {
            KtPsiUtil.$$$reportNull$$$0(1);
        }
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof KtElement)) continue;
            ((KtElement)child).accept(visitor2, data);
        }
    }

    @NotNull
    public static KtExpression safeDeparenthesize(@NotNull KtExpression expression2) {
        if (expression2 == null) {
            KtPsiUtil.$$$reportNull$$$0(2);
        }
        KtExpression ktExpression = KtPsiUtil.safeDeparenthesize(expression2, false);
        if (ktExpression == null) {
            KtPsiUtil.$$$reportNull$$$0(3);
        }
        return ktExpression;
    }

    @NotNull
    public static KtExpression safeDeparenthesize(@NotNull KtExpression expression2, boolean keepAnnotations) {
        KtExpression deparenthesized;
        if (expression2 == null) {
            KtPsiUtil.$$$reportNull$$$0(4);
        }
        KtExpression ktExpression = (deparenthesized = KtPsiUtil.deparenthesize(expression2, keepAnnotations)) != null ? deparenthesized : expression2;
        if (ktExpression == null) {
            KtPsiUtil.$$$reportNull$$$0(5);
        }
        return ktExpression;
    }

    @Nullable
    public static KtExpression deparenthesize(@Nullable KtExpression expression2) {
        return KtPsiUtil.deparenthesize(expression2, false);
    }

    @Nullable
    public static KtExpression deparenthesize(@Nullable KtExpression expression2, boolean keepAnnotations) {
        KtExpression baseExpression;
        while ((baseExpression = KtPsiUtil.deparenthesizeOnce(expression2, keepAnnotations)) != expression2) {
            expression2 = baseExpression;
        }
        return baseExpression;
    }

    @Nullable
    public static KtExpression deparenthesizeOnce(@Nullable KtExpression expression2) {
        return KtPsiUtil.deparenthesizeOnce(expression2, false);
    }

    @Nullable
    public static KtExpression deparenthesizeOnce(@Nullable KtExpression expression2, boolean keepAnnotations) {
        if (expression2 instanceof KtAnnotatedExpression && !keepAnnotations) {
            return ((KtAnnotatedExpression)expression2).getBaseExpression();
        }
        if (expression2 instanceof KtLabeledExpression) {
            return ((KtLabeledExpression)expression2).getBaseExpression();
        }
        if (expression2 instanceof KtExpressionWrapper) {
            return ((KtExpressionWrapper)((Object)expression2)).getBaseExpression();
        }
        if (expression2 instanceof KtParenthesizedExpression) {
            return ((KtParenthesizedExpression)expression2).getExpression();
        }
        return expression2;
    }

    @NotNull
    public static Name safeName(@Nullable String name) {
        Name name2 = name == null ? SpecialNames.NO_NAME_PROVIDED : Name.identifier(name);
        if (name2 == null) {
            KtPsiUtil.$$$reportNull$$$0(6);
        }
        return name2;
    }

    @NotNull
    public static Set<KtElement> findRootExpressions(@NotNull Collection<KtElement> unreachableElements) {
        if (unreachableElements == null) {
            KtPsiUtil.$$$reportNull$$$0(7);
        }
        HashSet<KtElement> rootElements = new HashSet<KtElement>();
        final HashSet shadowedElements = new HashSet();
        KtVisitorVoid shadowAllChildren = new KtVisitorVoid(){

            @Override
            public void visitKtElement(@NotNull KtElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (shadowedElements.add(element)) {
                    element.acceptChildren(this);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/psi/KtPsiUtil$1", "visitKtElement"));
            }
        };
        for (KtElement element : unreachableElements) {
            if (shadowedElements.contains(element)) continue;
            element.acceptChildren(shadowAllChildren);
            rootElements.removeAll(shadowedElements);
            rootElements.add(element);
        }
        HashSet<KtElement> hashSet = rootElements;
        if (hashSet == null) {
            KtPsiUtil.$$$reportNull$$$0(8);
        }
        return hashSet;
    }

    @NotNull
    public static String unquoteIdentifier(@NotNull String quoted) {
        if (quoted == null) {
            KtPsiUtil.$$$reportNull$$$0(9);
        }
        if (quoted.indexOf(96) < 0) {
            String string = quoted;
            if (string == null) {
                KtPsiUtil.$$$reportNull$$$0(10);
            }
            return string;
        }
        if (quoted.startsWith("`") && quoted.endsWith("`") && quoted.length() >= 2) {
            String string = quoted.substring(1, quoted.length() - 1);
            if (string == null) {
                KtPsiUtil.$$$reportNull$$$0(11);
            }
            return string;
        }
        String string = quoted;
        if (string == null) {
            KtPsiUtil.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    public static String unquoteIdentifierOrFieldReference(@NotNull String quoted) {
        if (quoted == null) {
            KtPsiUtil.$$$reportNull$$$0(13);
        }
        if (quoted.indexOf(96) < 0) {
            String string = quoted;
            if (string == null) {
                KtPsiUtil.$$$reportNull$$$0(14);
            }
            return string;
        }
        if (quoted.startsWith("$")) {
            String string = "$" + KtPsiUtil.unquoteIdentifier(quoted.substring(1));
            if (string == null) {
                KtPsiUtil.$$$reportNull$$$0(15);
            }
            return string;
        }
        String string = KtPsiUtil.unquoteIdentifier(quoted);
        if (string == null) {
            KtPsiUtil.$$$reportNull$$$0(16);
        }
        return string;
    }

    @Nullable
    public static Name getShortName(@NotNull KtAnnotationEntry annotation2) {
        KtUserType userType;
        String shortName;
        if (annotation2 == null) {
            KtPsiUtil.$$$reportNull$$$0(17);
        }
        KtTypeReference typeReference = annotation2.getTypeReference();
        assert (typeReference != null) : "Annotation entry hasn't typeReference " + annotation2.getText();
        KtTypeElement typeElement = typeReference.getTypeElement();
        if (typeElement instanceof KtUserType && (shortName = (userType = (KtUserType)typeElement).getReferencedName()) != null) {
            return Name.identifier(shortName);
        }
        return null;
    }

    public static boolean isDeprecated(@NotNull KtModifierListOwner owner) {
        KtModifierList modifierList;
        if (owner == null) {
            KtPsiUtil.$$$reportNull$$$0(18);
        }
        if ((modifierList = owner.getModifierList()) != null) {
            List<KtAnnotationEntry> annotationEntries = modifierList.getAnnotationEntries();
            for (KtAnnotationEntry annotation2 : annotationEntries) {
                Name shortName = KtPsiUtil.getShortName(annotation2);
                if (!KotlinBuiltIns.FQ_NAMES.deprecated.shortName().equals(shortName)) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static <T extends PsiElement> T getDirectParentOfTypeForBlock(@NotNull KtBlockExpression block, @NotNull Class<T> aClass2) {
        KtFunctionLiteral functionLiteral;
        KtIfExpression ifExpression;
        T parent2;
        if (block == null) {
            KtPsiUtil.$$$reportNull$$$0(19);
        }
        if (aClass2 == null) {
            KtPsiUtil.$$$reportNull$$$0(20);
        }
        if ((parent2 = PsiTreeUtil.getParentOfType((PsiElement)block, aClass2)) instanceof KtIfExpression && ((ifExpression = (KtIfExpression)parent2).getElse() == block || ifExpression.getThen() == block)) {
            return parent2;
        }
        if (parent2 instanceof KtWhenExpression) {
            KtWhenExpression whenExpression = (KtWhenExpression)parent2;
            for (KtWhenEntry whenEntry : whenExpression.getEntries()) {
                if (whenEntry.getExpression() != block) continue;
                return parent2;
            }
        }
        if (parent2 instanceof KtFunctionLiteral && (functionLiteral = (KtFunctionLiteral)parent2).getBodyExpression() == block) {
            return parent2;
        }
        if (parent2 instanceof KtTryExpression) {
            KtTryExpression tryExpression = (KtTryExpression)parent2;
            if (tryExpression.getTryBlock() == block) {
                return parent2;
            }
            for (KtCatchClause clause : tryExpression.getCatchClauses()) {
                if (clause.getCatchBody() != block) continue;
                return parent2;
            }
        }
        return null;
    }

    @Nullable
    public static Name getAliasName(@NotNull KtImportDirective importDirective) {
        if (importDirective == null) {
            KtPsiUtil.$$$reportNull$$$0(21);
        }
        if (importDirective.isAllUnder()) {
            return null;
        }
        String aliasName = importDirective.getAliasName();
        KtExpression importedReference = importDirective.getImportedReference();
        if (importedReference == null) {
            return null;
        }
        KtSimpleNameExpression referenceExpression = KtPsiUtil.getLastReference(importedReference);
        if (aliasName == null) {
            aliasName = referenceExpression != null ? referenceExpression.getReferencedName() : null;
        }
        return aliasName != null && !aliasName.isEmpty() ? Name.identifier(aliasName) : null;
    }

    @Nullable
    public static KtSimpleNameExpression getLastReference(@NotNull KtExpression importedReference) {
        KtElement selector;
        if (importedReference == null) {
            KtPsiUtil.$$$reportNull$$$0(22);
        }
        return (selector = KtPsiUtilKt.getQualifiedElementSelector(importedReference)) instanceof KtSimpleNameExpression ? (KtSimpleNameExpression)selector : null;
    }

    public static boolean isSelectorInQualified(@NotNull KtSimpleNameExpression nameExpression) {
        KtElement qualifiedElement;
        if (nameExpression == null) {
            KtPsiUtil.$$$reportNull$$$0(23);
        }
        return (qualifiedElement = KtPsiUtilKt.getQualifiedElement(nameExpression)) instanceof KtQualifiedExpression || qualifiedElement instanceof KtUserType && ((KtUserType)qualifiedElement).getQualifier() != null;
    }

    public static boolean isLHSOfDot(@NotNull KtExpression expression2) {
        PsiElement parent2;
        if (expression2 == null) {
            KtPsiUtil.$$$reportNull$$$0(24);
        }
        if (!((parent2 = expression2.getParent()) instanceof KtQualifiedExpression)) {
            return false;
        }
        KtQualifiedExpression qualifiedParent = (KtQualifiedExpression)parent2;
        return qualifiedParent.getReceiverExpression() == expression2 || KtPsiUtil.isLHSOfDot(qualifiedParent);
    }

    public static boolean isScriptDeclaration(@NotNull KtDeclaration namedDeclaration) {
        if (namedDeclaration == null) {
            KtPsiUtil.$$$reportNull$$$0(25);
        }
        return KtPsiUtil.getScript(namedDeclaration) != null;
    }

    @Nullable
    public static KtScript getScript(@NotNull KtDeclaration namedDeclaration) {
        PsiElement parent2;
        if (namedDeclaration == null) {
            KtPsiUtil.$$$reportNull$$$0(26);
        }
        if ((parent2 = namedDeclaration.getParent()) != null && parent2.getParent() instanceof KtScript) {
            return (KtScript)parent2.getParent();
        }
        return null;
    }

    public static boolean isRemovableVariableDeclaration(@NotNull KtDeclaration declaration) {
        if (declaration == null) {
            KtPsiUtil.$$$reportNull$$$0(27);
        }
        if (!(declaration instanceof KtVariableDeclaration)) {
            return false;
        }
        if (declaration instanceof KtProperty) {
            return true;
        }
        assert (declaration instanceof KtDestructuringDeclarationEntry);
        return true;
    }

    @Nullable
    @Contract(value="null, _ -> null")
    public static PsiElement getTopmostParentOfTypes(@Nullable PsiElement element, Class<? extends PsiElement> ... parentTypes) {
        PsiElement next;
        if (parentTypes == null) {
            KtPsiUtil.$$$reportNull$$$0(28);
        }
        if (element instanceof PsiFile) {
            return null;
        }
        PsiElement answer = PsiTreeUtil.getParentOfType(element, parentTypes);
        if (answer instanceof PsiFile) {
            return answer;
        }
        while ((next = PsiTreeUtil.getParentOfType(answer, parentTypes)) != null) {
            answer = next;
        }
        return answer;
    }

    public static boolean isNullConstant(@NotNull KtExpression expression2) {
        KtExpression deparenthesized;
        if (expression2 == null) {
            KtPsiUtil.$$$reportNull$$$0(29);
        }
        return (deparenthesized = KtPsiUtil.deparenthesize(expression2)) instanceof KtConstantExpression && deparenthesized.getNode().getElementType() == KtNodeTypes.NULL;
    }

    public static boolean isTrueConstant(@Nullable KtExpression condition) {
        return KtPsiUtil.isBooleanConstant(condition) && condition.getNode().findChildByType(KtTokens.TRUE_KEYWORD) != null;
    }

    public static boolean isFalseConstant(@Nullable KtExpression condition) {
        return KtPsiUtil.isBooleanConstant(condition) && condition.getNode().findChildByType(KtTokens.FALSE_KEYWORD) != null;
    }

    public static boolean isBooleanConstant(@Nullable KtExpression condition) {
        return condition != null && condition.getNode().getElementType() == KtNodeTypes.BOOLEAN_CONSTANT;
    }

    public static boolean isAbstract(@NotNull KtDeclarationWithBody declaration) {
        if (declaration == null) {
            KtPsiUtil.$$$reportNull$$$0(30);
        }
        return declaration.getBodyExpression() == null;
    }

    public static boolean isBackingFieldReference(@Nullable DeclarationDescriptor descriptor2) {
        return descriptor2 instanceof SyntheticFieldDescriptor;
    }

    @Nullable
    public static KtExpression getExpressionOrLastStatementInBlock(@Nullable KtExpression expression2) {
        if (expression2 instanceof KtBlockExpression) {
            return KtPsiUtil.getLastStatementInABlock((KtBlockExpression)expression2);
        }
        return expression2;
    }

    @Nullable
    public static KtExpression getLastStatementInABlock(@Nullable KtBlockExpression blockExpression) {
        if (blockExpression == null) {
            return null;
        }
        List<KtExpression> statements = blockExpression.getStatements();
        return statements.isEmpty() ? null : statements.get(statements.size() - 1);
    }

    public static boolean isTrait(@NotNull KtClassOrObject classOrObject) {
        if (classOrObject == null) {
            KtPsiUtil.$$$reportNull$$$0(31);
        }
        return classOrObject instanceof KtClass && ((KtClass)classOrObject).isInterface();
    }

    @Nullable
    public static KtClassOrObject getOutermostClassOrObject(@NotNull KtClassOrObject classOrObject) {
        if (classOrObject == null) {
            KtPsiUtil.$$$reportNull$$$0(32);
        }
        KtClassOrObject current = classOrObject;
        while (true) {
            PsiElement parent2 = current.getParent();
            assert (classOrObject.getParent() != null) : "Class with no parent: " + classOrObject.getText();
            if (parent2 instanceof PsiFile) {
                return current;
            }
            if (!(parent2 instanceof KtClassBody)) {
                return current;
            }
            current = (KtClassOrObject)parent2.getParent();
        }
    }

    @Nullable
    public static KtClassOrObject getClassIfParameterIsProperty(@NotNull KtParameter jetParameter) {
        PsiElement grandParent;
        if (jetParameter == null) {
            KtPsiUtil.$$$reportNull$$$0(33);
        }
        if (jetParameter.hasValOrVar() && (grandParent = jetParameter.getParent().getParent()) instanceof KtPrimaryConstructor) {
            return ((KtPrimaryConstructor)grandParent).getContainingClassOrObject();
        }
        return null;
    }

    @Nullable
    private static IElementType getOperation(@NotNull KtExpression expression2) {
        if (expression2 == null) {
            KtPsiUtil.$$$reportNull$$$0(34);
        }
        if (expression2 instanceof KtQualifiedExpression) {
            return ((KtQualifiedExpression)expression2).getOperationSign();
        }
        if (expression2 instanceof KtOperationExpression) {
            return ((KtOperationExpression)expression2).getOperationReference().getReferencedNameElementType();
        }
        return null;
    }

    private static int getPriority(@NotNull KtExpression expression2) {
        if (expression2 == null) {
            KtPsiUtil.$$$reportNull$$$0(35);
        }
        int maxPriority = KotlinExpressionParsing.Precedence.values().length + 1;
        if (expression2 instanceof KtPostfixExpression || expression2 instanceof KtQualifiedExpression || expression2 instanceof KtCallExpression || expression2 instanceof KtArrayAccessExpression || expression2 instanceof KtDoubleColonExpression) {
            return maxPriority - 1;
        }
        if (expression2 instanceof KtPrefixExpression || expression2 instanceof KtLabeledExpression) {
            return maxPriority - 2;
        }
        if (expression2 instanceof KtIfExpression) {
            return KotlinExpressionParsing.Precedence.ASSIGNMENT.ordinal();
        }
        if (expression2 instanceof KtSuperExpression) {
            return maxPriority;
        }
        if (expression2 instanceof KtDeclaration || expression2 instanceof KtStatementExpression) {
            return 0;
        }
        IElementType operation = KtPsiUtil.getOperation(expression2);
        for (KotlinExpressionParsing.Precedence precedence : KotlinExpressionParsing.Precedence.values()) {
            if (precedence == KotlinExpressionParsing.Precedence.PREFIX || precedence == KotlinExpressionParsing.Precedence.POSTFIX || !precedence.getOperations().contains(operation)) continue;
            return maxPriority - precedence.ordinal() - 1;
        }
        return maxPriority;
    }

    public static boolean areParenthesesUseless(@NotNull KtParenthesizedExpression expression2) {
        KtExpression innerExpression;
        if (expression2 == null) {
            KtPsiUtil.$$$reportNull$$$0(36);
        }
        if ((innerExpression = expression2.getExpression()) == null) {
            return true;
        }
        PsiElement parent2 = expression2.getParent();
        if (!(parent2 instanceof KtExpression)) {
            return true;
        }
        return !KtPsiUtil.areParenthesesNecessary(innerExpression, expression2, (KtExpression)parent2);
    }

    public static boolean areParenthesesNecessary(@NotNull KtExpression innerExpression, @NotNull KtExpression currentInner, @NotNull KtElement parentElement) {
        int parentPriority;
        if (innerExpression == null) {
            KtPsiUtil.$$$reportNull$$$0(37);
        }
        if (currentInner == null) {
            KtPsiUtil.$$$reportNull$$$0(38);
        }
        if (parentElement == null) {
            KtPsiUtil.$$$reportNull$$$0(39);
        }
        if (parentElement instanceof KtParenthesizedExpression || innerExpression instanceof KtParenthesizedExpression) {
            return false;
        }
        if (parentElement instanceof KtPackageDirective) {
            return false;
        }
        if (parentElement instanceof KtWhenExpression || innerExpression instanceof KtWhenExpression) {
            return false;
        }
        if (innerExpression instanceof KtIfExpression) {
            if (parentElement instanceof KtQualifiedExpression) {
                return true;
            }
            PsiElement current = parentElement;
            while (!(current instanceof KtBlockExpression || current instanceof KtDeclaration || current instanceof KtStatementExpression || current instanceof KtFile)) {
                if (current.getTextRange().getEndOffset() != currentInner.getTextRange().getEndOffset()) {
                    return !(current instanceof KtParenthesizedExpression) && !(current instanceof KtValueArgumentList);
                }
                current = current.getParent();
            }
        }
        if (parentElement instanceof KtCallExpression && currentInner == ((KtCallExpression)parentElement).getCalleeExpression()) {
            KtCallExpression parentCall = (KtCallExpression)parentElement;
            if (innerExpression instanceof KtSimpleNameExpression) {
                return false;
            }
            if (KtPsiUtilKt.getQualifiedExpressionForSelector(parentElement) != null) {
                return true;
            }
            if (innerExpression instanceof KtCallExpression && parentCall.getValueArgumentList() == null) {
                return true;
            }
            return !(innerExpression instanceof KtThisExpression) && !(innerExpression instanceof KtArrayAccessExpression) && !(innerExpression instanceof KtConstantExpression) && !(innerExpression instanceof KtStringTemplateExpression) && !(innerExpression instanceof KtCallExpression);
        }
        if (parentElement instanceof KtValueArgument) {
            KtExpression nextExpression;
            KtValueArgument nextArg = PsiTreeUtil.getNextSiblingOfType(parentElement, KtValueArgument.class);
            KtExpression ktExpression = nextExpression = nextArg != null ? nextArg.getArgumentExpression() : null;
            if (innerExpression instanceof KtBinaryExpression && ((KtBinaryExpression)innerExpression).getOperationToken() == KtTokens.LT && nextExpression instanceof KtBinaryExpression && ((KtBinaryExpression)nextExpression).getOperationToken() == KtTokens.GT) {
                return true;
            }
        }
        if (!(parentElement instanceof KtExpression)) {
            return false;
        }
        IElementType innerOperation = KtPsiUtil.getOperation(innerExpression);
        IElementType parentOperation = KtPsiUtil.getOperation((KtExpression)parentElement);
        if (parentElement instanceof KtReturnExpression && (innerExpression instanceof KtLabeledExpression || innerExpression instanceof KtAnnotatedExpression)) {
            return true;
        }
        if (innerExpression instanceof KtBinaryExpressionWithTypeRHS && parentOperation == KtTokens.LT) {
            return true;
        }
        if (parentElement instanceof KtLabeledExpression) {
            return false;
        }
        if (parentElement instanceof KtBinaryExpression && parentOperation == KtTokens.ELVIS && !(innerExpression instanceof KtBinaryExpression) && currentInner == ((KtBinaryExpression)parentElement).getRight()) {
            return false;
        }
        int innerPriority = KtPsiUtil.getPriority(innerExpression);
        if (innerPriority == (parentPriority = KtPsiUtil.getPriority((KtExpression)parentElement))) {
            if (parentElement instanceof KtBinaryExpression) {
                if (innerOperation == KtTokens.ANDAND || innerOperation == KtTokens.OROR) {
                    return false;
                }
                return ((KtBinaryExpression)parentElement).getRight() == currentInner;
            }
            if (parentElement instanceof KtPrefixExpression && innerExpression instanceof KtPrefixExpression) {
                return innerOperation == parentOperation && (innerOperation == KtTokens.PLUS || innerOperation == KtTokens.MINUS);
            }
            return false;
        }
        return innerPriority < parentPriority;
    }

    public static boolean isAssignment(@NotNull PsiElement element) {
        if (element == null) {
            KtPsiUtil.$$$reportNull$$$0(40);
        }
        return element instanceof KtBinaryExpression && KtTokens.ALL_ASSIGNMENTS.contains(((KtBinaryExpression)element).getOperationToken());
    }

    public static boolean isOrdinaryAssignment(@NotNull PsiElement element) {
        if (element == null) {
            KtPsiUtil.$$$reportNull$$$0(41);
        }
        return element instanceof KtBinaryExpression && ((KtBinaryExpression)element).getOperationToken().equals(KtTokens.EQ);
    }

    public static boolean isSafeCast(@NotNull KtBinaryExpressionWithTypeRHS expression2) {
        if (expression2 == null) {
            KtPsiUtil.$$$reportNull$$$0(42);
        }
        return expression2.getOperationReference().getReferencedNameElementType() == KtTokens.AS_SAFE;
    }

    public static boolean isUnsafeCast(@NotNull KtBinaryExpressionWithTypeRHS expression2) {
        if (expression2 == null) {
            KtPsiUtil.$$$reportNull$$$0(43);
        }
        return expression2.getOperationReference().getReferencedNameElementType() == KtTokens.AS_KEYWORD;
    }

    public static boolean checkVariableDeclarationInBlock(@NotNull KtBlockExpression block, @NotNull String varName) {
        if (block == null) {
            KtPsiUtil.$$$reportNull$$$0(44);
        }
        if (varName == null) {
            KtPsiUtil.$$$reportNull$$$0(45);
        }
        for (KtExpression element : block.getStatements()) {
            if (!(element instanceof KtVariableDeclaration) || !((KtVariableDeclaration)element).getNameAsSafeName().asString().equals(varName)) continue;
            return true;
        }
        return false;
    }

    public static boolean checkWhenExpressionHasSingleElse(@NotNull KtWhenExpression whenExpression) {
        if (whenExpression == null) {
            KtPsiUtil.$$$reportNull$$$0(46);
        }
        int elseCount = 0;
        for (KtWhenEntry entry : whenExpression.getEntries()) {
            if (!entry.isElse()) continue;
            ++elseCount;
        }
        return elseCount == 1;
    }

    @Nullable
    public static PsiElement skipTrailingWhitespacesAndComments(@Nullable PsiElement element) {
        return PsiTreeUtil.skipSiblingsForward(element, PsiWhiteSpace.class, PsiComment.class);
    }

    @Nullable
    public static PsiElement prevLeafIgnoringWhitespaceAndComments(@NotNull PsiElement element) {
        if (element == null) {
            KtPsiUtil.$$$reportNull$$$0(47);
        }
        PsiElement prev = PsiTreeUtil.prevLeaf(element, true);
        while (prev != null && KtTokens.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(prev.getNode().getElementType())) {
            prev = PsiTreeUtil.prevLeaf(prev, true);
        }
        return prev;
    }

    @Nullable
    public static PsiElement getPreviousWord(@NotNull PsiElement element, @NotNull String word) {
        PsiElement prev;
        if (element == null) {
            KtPsiUtil.$$$reportNull$$$0(48);
        }
        if (word == null) {
            KtPsiUtil.$$$reportNull$$$0(49);
        }
        if ((prev = KtPsiUtil.prevLeafIgnoringWhitespaceAndComments(element)) != null && prev.getNode().getElementType() == KtTokens.IDENTIFIER && word.equals(prev.getText())) {
            return prev;
        }
        return null;
    }

    @NotNull
    public static String getText(@Nullable PsiElement element) {
        String string = element != null ? element.getText() : "";
        if (string == null) {
            KtPsiUtil.$$$reportNull$$$0(50);
        }
        return string;
    }

    @Nullable
    public static String getNullableText(@Nullable PsiElement element) {
        return element != null ? element.getText() : null;
    }

    public static boolean isInComment(PsiElement element) {
        return CommentUtilCore.isComment(element) || element instanceof KDocElement;
    }

    @Nullable
    public static PsiElement getOutermostParent(@NotNull PsiElement element, @NotNull PsiElement upperBound, boolean strict) {
        PsiElement parent2;
        if (element == null) {
            KtPsiUtil.$$$reportNull$$$0(51);
        }
        if (upperBound == null) {
            KtPsiUtil.$$$reportNull$$$0(52);
        }
        PsiElement psiElement = parent2 = strict ? element.getParent() : element;
        while (parent2 != null && parent2.getParent() != upperBound) {
            parent2 = parent2.getParent();
        }
        return parent2;
    }

    public static <T extends PsiElement> T getLastChildByType(@NotNull PsiElement root2, Class<? extends T> ... elementTypes) {
        if (root2 == null) {
            KtPsiUtil.$$$reportNull$$$0(53);
        }
        if (elementTypes == null) {
            KtPsiUtil.$$$reportNull$$$0(54);
        }
        PsiElement[] children = root2.getChildren();
        for (int i = children.length - 1; i >= 0; --i) {
            if (!PsiTreeUtil.instanceOf(children[i], elementTypes)) continue;
            return (T)children[i];
        }
        return null;
    }

    @Nullable
    public static KtElement getOutermostDescendantElement(@Nullable PsiElement root2, boolean first, final @NotNull Predicate<KtElement> predicate) {
        if (predicate == null) {
            KtPsiUtil.$$$reportNull$$$0(55);
        }
        if (!(root2 instanceof KtElement)) {
            return null;
        }
        final ArrayList results = Lists.newArrayList();
        root2.accept(new KtVisitorVoid(){

            @Override
            public void visitKtElement(@NotNull KtElement element) {
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (predicate.test(element)) {
                    results.add(element);
                } else {
                    element.acceptChildren(this);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/psi/KtPsiUtil$2", "visitKtElement"));
            }
        });
        if (results.isEmpty()) {
            return null;
        }
        return first ? (KtElement)results.get(0) : (KtElement)results.get(results.size() - 1);
    }

    @Nullable
    public static PsiElement findChildByType(@NotNull PsiElement element, @NotNull IElementType type2) {
        ASTNode node;
        if (element == null) {
            KtPsiUtil.$$$reportNull$$$0(56);
        }
        if (type2 == null) {
            KtPsiUtil.$$$reportNull$$$0(57);
        }
        return (node = element.getNode().findChildByType(type2)) == null ? null : node.getPsi();
    }

    @Nullable
    public static PsiElement skipSiblingsBackwardByPredicate(@Nullable PsiElement element, Predicate<PsiElement> elementsToSkip) {
        if (element == null) {
            return null;
        }
        for (PsiElement e = element.getPrevSibling(); e != null; e = e.getPrevSibling()) {
            if (elementsToSkip.test(e)) continue;
            return e;
        }
        return null;
    }

    public static PsiElement ascendIfPropertyAccessor(PsiElement element) {
        if (element instanceof KtPropertyAccessor) {
            return element.getParent();
        }
        return element;
    }

    @Nullable
    @Contract(value="_, !null -> !null")
    public static KtModifierList replaceModifierList(@NotNull KtModifierListOwner owner, @Nullable KtModifierList modifierList) {
        if (owner == null) {
            KtPsiUtil.$$$reportNull$$$0(58);
        }
        KtModifierList oldModifierList = owner.getModifierList();
        if (modifierList == null) {
            if (oldModifierList != null) {
                oldModifierList.delete();
            }
            return null;
        }
        if (oldModifierList == null) {
            PsiElement firstChild = owner.getFirstChild();
            return (KtModifierList)owner.addBefore(modifierList, firstChild);
        }
        return (KtModifierList)oldModifierList.replace(modifierList);
    }

    @Nullable
    public static String getPackageName(@NotNull KtElement element) {
        KtFile file;
        KtPackageDirective header;
        if (element == null) {
            KtPsiUtil.$$$reportNull$$$0(59);
        }
        return (header = PsiTreeUtil.findChildOfType(file = element.getContainingKtFile(), KtPackageDirective.class)) != null ? header.getQualifiedName() : null;
    }

    @Nullable
    public static KtElement getEnclosingElementForLocalDeclaration(@NotNull KtDeclaration declaration) {
        if (declaration == null) {
            KtPsiUtil.$$$reportNull$$$0(60);
        }
        return KtPsiUtil.getEnclosingElementForLocalDeclaration(declaration, true);
    }

    private static boolean isMemberOfObjectExpression(@NotNull KtCallableDeclaration propertyOrFunction) {
        PsiElement parent2;
        if (propertyOrFunction == null) {
            KtPsiUtil.$$$reportNull$$$0(61);
        }
        if (!((parent2 = PsiTreeUtil.getStubOrPsiParent(propertyOrFunction)) instanceof KtClassBody)) {
            return false;
        }
        PsiElement grandparent = PsiTreeUtil.getStubOrPsiParent(parent2);
        if (!(grandparent instanceof KtObjectDeclaration)) {
            return false;
        }
        return PsiTreeUtil.getStubOrPsiParent(grandparent) instanceof KtObjectLiteralExpression;
    }

    @Nullable
    public static KtElement getEnclosingElementForLocalDeclaration(@NotNull KtDeclaration declaration, boolean skipParameters) {
        PsiElement parent2;
        if (declaration == null) {
            KtPsiUtil.$$$reportNull$$$0(62);
        }
        if (declaration instanceof KtTypeParameter && skipParameters) {
            declaration = PsiTreeUtil.getParentOfType((PsiElement)declaration, KtNamedDeclaration.class);
        } else if (declaration instanceof KtParameter) {
            KtFunctionType functionType = PsiTreeUtil.getParentOfType((PsiElement)declaration, KtFunctionType.class);
            if (functionType != null) {
                return functionType;
            }
            parent2 = declaration.getParent();
            if (((KtParameter)declaration).hasValOrVar() && parent2 != null && parent2.getParent() instanceof KtPrimaryConstructor) {
                return KtPsiUtil.getEnclosingElementForLocalDeclaration(((KtPrimaryConstructor)parent2.getParent()).getContainingClassOrObject(), skipParameters);
            }
            if (skipParameters && parent2 != null && parent2.getParent() instanceof KtNamedFunction) {
                declaration = (KtNamedFunction)parent2.getParent();
            }
        }
        if (declaration instanceof PsiFile) {
            return declaration;
        }
        PsiElement current = PsiTreeUtil.getStubOrPsiParent(declaration);
        while (current != null) {
            PsiElement grandParent;
            parent2 = PsiTreeUtil.getStubOrPsiParent(current);
            if (parent2 instanceof KtScript) {
                return null;
            }
            if (current instanceof KtAnonymousInitializer) {
                return ((KtAnonymousInitializer)current).getBody();
            }
            if (current instanceof KtProperty || current instanceof KtFunction) {
                if (parent2 instanceof KtFile) {
                    return (KtElement)current;
                }
                if (parent2 instanceof KtClassBody && !KtPsiUtil.isMemberOfObjectExpression((KtCallableDeclaration)current)) {
                    return (KtElement)parent2;
                }
            }
            if (current instanceof KtBlockExpression || current instanceof KtParameter || current instanceof KtValueArgument) {
                return (KtElement)current;
            }
            if (current instanceof KtDelegatedSuperTypeEntry && (grandParent = current.getParent().getParent()) instanceof KtClassOrObject && !(grandParent.getParent() instanceof KtObjectLiteralExpression)) {
                return (KtElement)grandParent;
            }
            current = parent2;
        }
        return null;
    }

    public static boolean isLocal(@NotNull KtDeclaration declaration) {
        if (declaration == null) {
            KtPsiUtil.$$$reportNull$$$0(63);
        }
        return KtPsiUtil.getEnclosingElementForLocalDeclaration(declaration) != null;
    }

    @Nullable
    public static KtToken getOperationToken(@NotNull KtOperationExpression expression2) {
        if (expression2 == null) {
            KtPsiUtil.$$$reportNull$$$0(64);
        }
        KtSimpleNameExpression operationExpression = expression2.getOperationReference();
        IElementType elementType = operationExpression.getReferencedNameElementType();
        assert (elementType == null || elementType instanceof KtToken) : "JetOperationExpression should have operation token of type KtToken: " + expression2;
        return (KtToken)elementType;
    }

    public static boolean isLabelIdentifierExpression(PsiElement element) {
        return element instanceof KtLabelReferenceExpression;
    }

    @Nullable
    public static KtExpression getParentCallIfPresent(@NotNull KtExpression expression2) {
        if (expression2 == null) {
            KtPsiUtil.$$$reportNull$$$0(65);
        }
        PsiElement parent2 = expression2.getParent();
        while (parent2 != null) {
            if (parent2 instanceof KtBinaryExpression || parent2 instanceof KtUnaryExpression || parent2 instanceof KtLabeledExpression || parent2 instanceof KtDotQualifiedExpression || parent2 instanceof KtCallExpression || parent2 instanceof KtArrayAccessExpression || parent2 instanceof KtDestructuringDeclaration) {
                if (parent2 instanceof KtLabeledExpression) {
                    parent2 = parent2.getParent();
                    continue;
                }
                return (KtExpression)parent2;
            }
            if (parent2 instanceof KtParenthesizedExpression || parent2 instanceof KtBinaryExpressionWithTypeRHS) {
                parent2 = parent2.getParent();
                continue;
            }
            if (parent2 instanceof KtValueArgument || parent2 instanceof KtValueArgumentList) {
                parent2 = parent2.getParent();
                continue;
            }
            if (parent2 instanceof KtLambdaExpression || parent2 instanceof KtAnnotatedExpression) {
                parent2 = parent2.getParent();
                continue;
            }
            return null;
        }
        return null;
    }

    @Nullable
    public static KtExpression getLastElementDeparenthesized(@Nullable KtExpression expression2, @NotNull StatementFilter statementFilter) {
        KtBlockExpression blockExpression;
        KtExpression lastStatementInABlock;
        KtExpression deparenthesizedExpression;
        if (statementFilter == null) {
            KtPsiUtil.$$$reportNull$$$0(66);
        }
        if ((deparenthesizedExpression = KtPsiUtil.deparenthesize(expression2)) instanceof KtBlockExpression && (lastStatementInABlock = StatementFilterKt.getLastStatementInABlock(statementFilter, blockExpression = (KtBlockExpression)deparenthesizedExpression)) != null) {
            return KtPsiUtil.getLastElementDeparenthesized(lastStatementInABlock, statementFilter);
        }
        return deparenthesizedExpression;
    }

    public static boolean isStatementContainer(@Nullable PsiElement container2) {
        return container2 instanceof KtBlockExpression || container2 instanceof KtContainerNodeForControlStructureBody || container2 instanceof KtWhenEntry;
    }

    public static boolean isStatement(@NotNull PsiElement element) {
        if (element == null) {
            KtPsiUtil.$$$reportNull$$$0(67);
        }
        return KtPsiUtil.isStatementContainer(element.getParent());
    }

    public static boolean isInOrNotInOperation(@NotNull KtBinaryExpression binaryExpression) {
        if (binaryExpression == null) {
            KtPsiUtil.$$$reportNull$$$0(68);
        }
        return KtPsiUtil.isInOperation(binaryExpression) || KtPsiUtil.isNotInOperation(binaryExpression);
    }

    public static boolean isNotInOperation(@NotNull KtBinaryExpression binaryExpression) {
        if (binaryExpression == null) {
            KtPsiUtil.$$$reportNull$$$0(69);
        }
        return binaryExpression.getOperationToken() == KtTokens.NOT_IN;
    }

    private static boolean isInOperation(@NotNull KtBinaryExpression binaryExpression) {
        if (binaryExpression == null) {
            KtPsiUtil.$$$reportNull$$$0(70);
        }
        return binaryExpression.getOperationToken() == KtTokens.IN_KEYWORD;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 50: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 50: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 2: 
            case 4: 
            case 24: 
            case 29: 
            case 34: 
            case 35: 
            case 36: 
            case 42: 
            case 43: 
            case 64: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/psi/KtPsiUtil";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unreachableElements";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quoted";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 18: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 19: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importDirective";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importedReference";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameExpression";
                break;
            }
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namedDeclaration";
                break;
            }
            case 27: 
            case 30: 
            case 60: 
            case 62: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentTypes";
                break;
            }
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classOrObject";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetParameter";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "innerExpression";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentInner";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentElement";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "varName";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "whenExpression";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "word";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "upperBound";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementTypes";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyOrFunction";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statementFilter";
                break;
            }
            case 68: 
            case 69: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/psi/KtPsiUtil";
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "safeDeparenthesize";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "safeName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "findRootExpressions";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "unquoteIdentifier";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "unquoteIdentifierOrFieldReference";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "visitChildren";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "safeDeparenthesize";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 50: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findRootExpressions";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "unquoteIdentifier";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "unquoteIdentifierOrFieldReference";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getShortName";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isDeprecated";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getDirectParentOfTypeForBlock";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getAliasName";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getLastReference";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isSelectorInQualified";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isLHSOfDot";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isScriptDeclaration";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getScript";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isRemovableVariableDeclaration";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getTopmostParentOfTypes";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isNullConstant";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isAbstract";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isTrait";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getOutermostClassOrObject";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getClassIfParameterIsProperty";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getOperation";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getPriority";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "areParenthesesUseless";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "areParenthesesNecessary";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "isAssignment";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "isOrdinaryAssignment";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "isSafeCast";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "isUnsafeCast";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "checkVariableDeclarationInBlock";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "checkWhenExpressionHasSingleElse";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "prevLeafIgnoringWhitespaceAndComments";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getPreviousWord";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getOutermostParent";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getLastChildByType";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getOutermostDescendantElement";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "findChildByType";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "replaceModifierList";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "getPackageName";
                break;
            }
            case 60: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "getEnclosingElementForLocalDeclaration";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "isMemberOfObjectExpression";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "isLocal";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "getOperationToken";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "getParentCallIfPresent";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "getLastElementDeparenthesized";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "isStatement";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "isInOrNotInOperation";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "isNotInOperation";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "isInOperation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 50: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface KtExpressionWrapper {
        public KtExpression getBaseExpression();
    }
}

