/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationArgumentVisitor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.resolve.constants.AnnotationValue;
import org.jetbrains.kotlin.resolve.constants.ArrayValue;
import org.jetbrains.kotlin.resolve.constants.BooleanValue;
import org.jetbrains.kotlin.resolve.constants.ByteValue;
import org.jetbrains.kotlin.resolve.constants.CharValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.DoubleValue;
import org.jetbrains.kotlin.resolve.constants.EnumValue;
import org.jetbrains.kotlin.resolve.constants.ErrorValue;
import org.jetbrains.kotlin.resolve.constants.FloatValue;
import org.jetbrains.kotlin.resolve.constants.IntValue;
import org.jetbrains.kotlin.resolve.constants.KClassValue;
import org.jetbrains.kotlin.resolve.constants.LongValue;
import org.jetbrains.kotlin.resolve.constants.NullValue;
import org.jetbrains.kotlin.resolve.constants.ShortValue;
import org.jetbrains.kotlin.resolve.constants.StringValue;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.serialization.StringTable;
import org.jetbrains.kotlin.types.ErrorUtils;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0012\u0010\t\u001a\u00020\n2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/serialization/AnnotationSerializer;", "", "stringTable", "Lorg/jetbrains/kotlin/serialization/StringTable;", "(Lorg/jetbrains/kotlin/serialization/StringTable;)V", "serializeAnnotation", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$Annotation;", "annotation", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "valueProto", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$Annotation$Argument$Value$Builder;", "constant", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;", "kotlin-compiler"})
public final class AnnotationSerializer {
    private final StringTable stringTable;

    @NotNull
    public final ProtoBuf.Annotation serializeAnnotation(@NotNull AnnotationDescriptor annotation2) {
        ProtoBuf.Annotation.Builder builder;
        Intrinsics.checkParameterIsNotNull(annotation2, "annotation");
        ProtoBuf.Annotation.Builder $receiver = builder = ProtoBuf.Annotation.newBuilder();
        ClassDescriptor classDescriptor = DescriptorUtilsKt.getAnnotationClass(annotation2);
        if (classDescriptor == null) {
            String string = "Annotation type is not a class: " + annotation2.getType();
            throw (Throwable)new IllegalStateException(string.toString());
        }
        ClassDescriptor annotationClass = classDescriptor;
        if (ErrorUtils.isError(annotationClass)) {
            String string = "Unresolved annotation type: " + annotation2.getType() + " at " + annotation2.getSource().getContainingFile();
            throw (Throwable)new IllegalStateException(string.toString());
        }
        $receiver.setId(this.stringTable.getFqNameIndex(annotationClass));
        Map<ValueParameterDescriptor, ConstantValue<?>> map2 = annotation2.getAllValueArguments();
        Iterator<Map.Entry<ValueParameterDescriptor, ConstantValue<?>>> iterator2 = map2.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<ValueParameterDescriptor, ConstantValue<?>> entry;
            Map.Entry<ValueParameterDescriptor, ConstantValue<?>> entry2 = entry = iterator2.next();
            ValueParameterDescriptor parameter = entry2.getKey();
            entry2 = entry;
            ConstantValue<?> value = entry2.getValue();
            ProtoBuf.Annotation.Argument.Builder argument = ProtoBuf.Annotation.Argument.newBuilder();
            String string = parameter.getName().asString();
            Intrinsics.checkExpressionValueIsNotNull(string, "parameter.name.asString()");
            argument.setNameId(this.stringTable.getStringIndex(string));
            ConstantValue<?> constantValue = value;
            Intrinsics.checkExpressionValueIsNotNull(constantValue, "value");
            argument.setValue(this.valueProto(constantValue));
            $receiver.addArgument(argument);
        }
        ProtoBuf.Annotation annotation3 = builder.build();
        Intrinsics.checkExpressionValueIsNotNull(annotation3, "ProtoBuf.Annotation.newB\u2026)\n        }\n    }.build()");
        return annotation3;
    }

    @NotNull
    public final ProtoBuf.Annotation.Argument.Value.Builder valueProto(@NotNull ConstantValue<?> constant) {
        ProtoBuf.Annotation.Argument.Value.Builder builder;
        Intrinsics.checkParameterIsNotNull(constant, "constant");
        ProtoBuf.Annotation.Argument.Value.Builder $receiver = builder = ProtoBuf.Annotation.Argument.Value.newBuilder();
        constant.accept(new AnnotationArgumentVisitor<Unit, Unit>($receiver, this, constant){
            final /* synthetic */ ProtoBuf.Annotation.Argument.Value.Builder receiver$0;
            final /* synthetic */ AnnotationSerializer this$0;
            final /* synthetic */ ConstantValue $constant$inlined;
            {
                this.receiver$0 = $receiver;
                this.this$0 = annotationSerializer2;
                this.$constant$inlined = constantValue;
            }

            public void visitAnnotationValue(AnnotationValue value, Unit data) {
                this.receiver$0.setType(ProtoBuf.Annotation.Argument.Value.Type.ANNOTATION);
                this.receiver$0.setAnnotation(this.this$0.serializeAnnotation((AnnotationDescriptor)value.getValue()));
            }

            public void visitArrayValue(ArrayValue value, Unit data) {
                this.receiver$0.setType(ProtoBuf.Annotation.Argument.Value.Type.ARRAY);
                for (ConstantValue element : (List)value.getValue()) {
                    this.receiver$0.addArrayElement(this.this$0.valueProto(element).build());
                }
            }

            public void visitBooleanValue(BooleanValue value, Unit data) {
                this.receiver$0.setType(ProtoBuf.Annotation.Argument.Value.Type.BOOLEAN);
                this.receiver$0.setIntValue((Boolean)value.getValue() != false ? 1L : 0L);
            }

            public void visitByteValue(ByteValue value, Unit data) {
                this.receiver$0.setType(ProtoBuf.Annotation.Argument.Value.Type.BYTE);
                this.receiver$0.setIntValue(((Number)value.getValue()).byteValue());
            }

            public void visitCharValue(CharValue value, Unit data) {
                this.receiver$0.setType(ProtoBuf.Annotation.Argument.Value.Type.CHAR);
                this.receiver$0.setIntValue(((Character)value.getValue()).charValue());
            }

            public void visitDoubleValue(DoubleValue value, Unit data) {
                this.receiver$0.setType(ProtoBuf.Annotation.Argument.Value.Type.DOUBLE);
                this.receiver$0.setDoubleValue(((Number)value.getValue()).doubleValue());
            }

            public void visitEnumValue(EnumValue value, Unit data) {
                this.receiver$0.setType(ProtoBuf.Annotation.Argument.Value.Type.ENUM);
                ClassDescriptor enumEntry = (ClassDescriptor)value.getValue();
                DeclarationDescriptor declarationDescriptor = enumEntry.getContainingDeclaration();
                if (declarationDescriptor == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
                }
                this.receiver$0.setClassId(AnnotationSerializer.access$getStringTable$p(this.this$0).getFqNameIndex((ClassDescriptor)declarationDescriptor));
                StringTable stringTable = AnnotationSerializer.access$getStringTable$p(this.this$0);
                String string = enumEntry.getName().asString();
                Intrinsics.checkExpressionValueIsNotNull(string, "enumEntry.name.asString()");
                this.receiver$0.setEnumValueId(stringTable.getStringIndex(string));
            }

            public void visitErrorValue(ErrorValue value, Unit data) {
                throw (Throwable)new UnsupportedOperationException("Error value: " + value);
            }

            public void visitFloatValue(FloatValue value, Unit data) {
                this.receiver$0.setType(ProtoBuf.Annotation.Argument.Value.Type.FLOAT);
                this.receiver$0.setFloatValue(((Number)value.getValue()).floatValue());
            }

            public void visitIntValue(IntValue value, Unit data) {
                this.receiver$0.setType(ProtoBuf.Annotation.Argument.Value.Type.INT);
                this.receiver$0.setIntValue(((Number)value.getValue()).intValue());
            }

            public void visitKClassValue(KClassValue value, Unit data) {
                throw (Throwable)new UnsupportedOperationException("Class literal annotation arguments are not yet supported: " + value);
            }

            public void visitLongValue(LongValue value, Unit data) {
                this.receiver$0.setType(ProtoBuf.Annotation.Argument.Value.Type.LONG);
                this.receiver$0.setIntValue(((Number)value.getValue()).longValue());
            }

            public void visitNullValue(NullValue value, Unit data) {
                throw (Throwable)new UnsupportedOperationException("Null should not appear in annotation arguments");
            }

            public void visitShortValue(ShortValue value, Unit data) {
                this.receiver$0.setType(ProtoBuf.Annotation.Argument.Value.Type.SHORT);
                this.receiver$0.setIntValue(((Number)value.getValue()).shortValue());
            }

            public void visitStringValue(StringValue value, Unit data) {
                this.receiver$0.setType(ProtoBuf.Annotation.Argument.Value.Type.STRING);
                this.receiver$0.setStringValue(AnnotationSerializer.access$getStringTable$p(this.this$0).getStringIndex((String)value.getValue()));
            }
        }, Unit.INSTANCE);
        ProtoBuf.Annotation.Argument.Value.Builder builder2 = builder;
        Intrinsics.checkExpressionValueIsNotNull(builder2, "Value.newBuilder().apply\u2026 }\n        }, Unit)\n    }");
        return builder2;
    }

    public AnnotationSerializer(@NotNull StringTable stringTable) {
        Intrinsics.checkParameterIsNotNull(stringTable, "stringTable");
        this.stringTable = stringTable;
    }

    @NotNull
    public static final /* synthetic */ StringTable access$getStringTable$p(AnnotationSerializer $this) {
        return $this.stringTable;
    }
}

