#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: tamarin-prover-term
version: 1.2.2
id: tamarin-prover-term-1.2.2-AAX5pCkSPqj7TesI35mR1r
key: tamarin-prover-term-1.2.2-AAX5pCkSPqj7TesI35mR1r
license: GPL
copyright: Benedikt Schmidt, Simon Meier, ETH Zurich, 2010-2012
maintainer: Benedikt Schmidt <benedikt.schmidt@inf.ethz.ch>
homepage: http://www.infsec.ethz.ch/research/software/tamarin
synopsis: Term manipulation library for the tamarin prover.
description:
    This is an internal library of the Tamarin prover for
    security protocol verification
    (<hackage.haskell.org/package/tamarin-prover>).
    .
    This library provides term manipulation infrastructure
    (matching, unification, narrowing, finite variants) for
    the Tamarin prover. It uses maude
    (<http://maude.cs.uiuc.edu/>) as a backend for
    normalization, equational matching, and unification.
category: Theorem Provers
author: Benedikt Schmidt <benedikt.schmidt@inf.ethz.ch>,
        Simon Meier <simon.meier@inf.ethz.ch>
exposed: True
exposed-modules:
    Term.Unification Term.VTerm Term.LTerm Term.Positions
    Term.SubtermRule Term.Subsumption Term.Substitution
    Term.Rewriting.Definitions Term.Rewriting.Norm
    Term.Narrowing.Variants Term.Narrowing.Variants.Check
    Term.Narrowing.Variants.Compute Term.Builtin.Convenience
    Term.Builtin.Rules Term.Builtin.Signature Term.Maude.Process
    Term.Maude.Signature Term.Maude.Types Term.Maude.Parser
    Term.UnitTests
hidden-modules: Term.Term Term.Term.Classes Term.Term.Raw
                Term.Term.FunctionSymbols Term.Narrowing.Narrow
                Term.Substitution.SubstVFree Term.Substitution.SubstVFresh
abi: 2fd0e8a9908efb120c83d2680596e654
trusted: False
import-dirs: /usr/lib/ghc-8.0.2/site-local/tamarin-prover-term-1.2.2
library-dirs: /usr/lib/ghc-8.0.2/site-local/tamarin-prover-term-1.2.2
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.0.2/tamarin-prover-term-1.2.2
hs-libraries: HStamarin-prover-term-1.2.2-AAX5pCkSPqj7TesI35mR1r
depends:
    HUnit-1.6.0.0-60ZLMGxowdyCquCGGOoE3I
    attoparsec-0.13.2.0-JkqjYPxw7sG9Iq2J4E1Ndn base-4.9.1.0
    binary-0.8.3.0 bytestring-0.10.8.1 containers-0.5.7.1
    deepseq-1.4.2.0 dlist-0.8.0.3-BHFBNaw8k6n9WiaUNzoXpk
    mtl-2.2.1-BLKBelFsPB3BoFeSWSOYj6 process-1.4.3.0
    safe-0.3.15-2Yd45VWFfdcKqKyispOifY
    tamarin-prover-utils-1.2.2-DJZpg9PLIgz1PvIcXekJ5D
haddock-interfaces: /usr/share/doc/haskell-tamarin-prover-term/html/tamarin-prover-term.haddock
haddock-html: /usr/share/doc/haskell-tamarin-prover-term/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"
