/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.updatesite.xml;

import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.ivy.osgi.updatesite.xml.EclipseFeature;
import org.apache.ivy.osgi.updatesite.xml.EclipsePlugin;
import org.apache.ivy.osgi.updatesite.xml.Require;
import org.apache.ivy.osgi.util.DelegetingHandler;
import org.apache.ivy.osgi.util.Version;
import org.apache.ivy.util.XMLHelper;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class FeatureParser {
    public static EclipseFeature parse(InputStream inputStream) throws ParseException, IOException, SAXException {
        FeatureHandler featureHandler = new FeatureHandler();
        try {
            XMLHelper.parse(inputStream, null, (DefaultHandler)featureHandler, null);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new SAXException(parserConfigurationException);
        }
        return featureHandler.feature;
    }

    static class DiscoveryHandler
    extends DelegetingHandler {
        private static final String DISCOVERY = "discovery";
        private static final String URL = "url";
        private static final String LABEL = "label";
        private static final String TYPE = "type";

        public DiscoveryHandler() {
            super(DISCOVERY);
        }

        @Override
        protected void handleAttributes(Attributes attributes) throws SAXException {
            String string = attributes.getValue(TYPE);
            String string2 = attributes.getValue(LABEL);
            String string3 = attributes.getValue(URL);
        }
    }

    static class UpdateHandler
    extends DelegetingHandler {
        private static final String UPDATE = "update";
        private static final String LABEL = "label";
        private static final String URL = "url";

        public UpdateHandler() {
            super(UPDATE);
        }

        @Override
        protected void handleAttributes(Attributes attributes) throws SAXException {
            String string = attributes.getValue(LABEL);
            String string2 = attributes.getValue(URL);
        }
    }

    static class UrlHandler
    extends DelegetingHandler {
        private static final String URL = "url";

        public UrlHandler() {
            super(URL);
            this.addChild(new UpdateHandler(), new DelegetingHandler.ChildElementHandler(){

                @Override
                public void childHanlded(DelegetingHandler delegetingHandler) {
                }
            });
            this.addChild(new DiscoveryHandler(), new DelegetingHandler.ChildElementHandler(){

                @Override
                public void childHanlded(DelegetingHandler delegetingHandler) {
                }
            });
        }
    }

    static class InstallHandlerHandler
    extends DelegetingHandler {
        private static final String INSTALL_HANDLER = "install-handler";
        private static final String URL = "url";
        private static final String LIBRARY = "library";
        private static final String HANDLER = "handler";

        public InstallHandlerHandler() {
            super(INSTALL_HANDLER);
        }

        @Override
        protected void handleAttributes(Attributes attributes) throws SAXException {
            String string = attributes.getValue(HANDLER);
            String string2 = attributes.getValue(LIBRARY);
            String string3 = attributes.getValue(URL);
        }
    }

    static class IncludesHandler
    extends DelegetingHandler {
        private static final String INCLUDES = "includes";
        private static final String FILTER = "filter";
        private static final String OPTIONAL = "optional";
        private static final String VERSION = "version";
        private static final String ID = "id";

        public IncludesHandler() {
            super(INCLUDES);
        }

        @Override
        protected void handleAttributes(Attributes attributes) throws SAXException {
            String string = attributes.getValue(ID);
            String string2 = attributes.getValue(VERSION);
            String string3 = attributes.getValue(OPTIONAL);
            String string4 = attributes.getValue(FILTER);
        }
    }

    static class ImportHandler
    extends DelegetingHandler {
        Require require;
        private static final String IMPORT = "import";
        private static final String FILTER = "filter";
        private static final String MATCH = "match";
        private static final String VERSION = "version";
        private static final String PLUGIN = "plugin";
        private static final String FEATURE = "feature";

        public ImportHandler() {
            super(IMPORT);
        }

        @Override
        protected void handleAttributes(Attributes attributes) throws SAXException {
            this.require = new Require();
            String string = attributes.getValue(VERSION);
            this.require.setFeature(attributes.getValue(FEATURE));
            this.require.setPlugin(attributes.getValue(PLUGIN));
            try {
                this.require.setVersion(new Version(string));
            }
            catch (ParseException parseException) {
                throw new SAXException("Incorrect version on feature's import: " + string + " (" + parseException.getMessage() + ")");
            }
            this.require.setMatch(attributes.getValue(MATCH));
            this.require.setFilter(attributes.getValue(FILTER));
        }
    }

    static class RequiresHandler
    extends DelegetingHandler {
        private static final String REQUIRES = "requires";
        List requires = new ArrayList();

        public RequiresHandler() {
            super(REQUIRES);
            this.addChild(new ImportHandler(), new DelegetingHandler.ChildElementHandler(){

                @Override
                public void childHanlded(DelegetingHandler delegetingHandler) {
                    RequiresHandler.this.requires.add(((ImportHandler)delegetingHandler).require);
                }
            });
        }
    }

    static class CopyrightHandler
    extends DelegetingHandler {
        private static final String COPYRIGHT = "copyright";
        private static final String URL = "url";

        public CopyrightHandler() {
            super(COPYRIGHT);
            this.setBufferingChar(true);
        }

        @Override
        protected void handleAttributes(Attributes attributes) throws SAXException {
            String string = attributes.getValue(URL);
        }
    }

    static class LicenseHandler
    extends DelegetingHandler {
        private static final String LICENSE = "license";
        private static final String URL = "url";

        public LicenseHandler() {
            super(LICENSE);
            this.setBufferingChar(true);
        }

        @Override
        protected void handleAttributes(Attributes attributes) throws SAXException {
            String string = attributes.getValue(URL);
        }
    }

    static class DescriptionHandler
    extends DelegetingHandler {
        private static final String DESCRIPTION = "description";
        private static final String URL = "url";

        public DescriptionHandler() {
            super(DESCRIPTION);
            this.setBufferingChar(true);
        }

        @Override
        protected void handleAttributes(Attributes attributes) throws SAXException {
            String string = attributes.getValue(URL);
        }
    }

    static class PluginHandler
    extends DelegetingHandler {
        private static final String PLUGIN = "plugin";
        private static final String FILTER = "filter";
        private static final String FRAGMENT = "fragment";
        private static final String UNPACK = "unpack";
        private static final String VERSION = "version";
        private static final String ID = "id";
        private EclipsePlugin plugin;

        public PluginHandler() {
            super(PLUGIN);
        }

        @Override
        protected void handleAttributes(Attributes attributes) throws SAXException {
            this.plugin = new EclipsePlugin();
            String string = attributes.getValue(ID);
            String string2 = attributes.getValue(VERSION);
            this.plugin.setId(string);
            try {
                this.plugin.setVersion(new Version(string2));
            }
            catch (ParseException parseException) {
                throw new SAXException("Incorrect version on feature's plugin '" + string + "': " + string2 + " (" + parseException.getMessage() + ")");
            }
            this.plugin.setUnpack(Boolean.valueOf(attributes.getValue(UNPACK)));
            this.plugin.setFragment(attributes.getValue(FRAGMENT));
            this.plugin.setFilter(attributes.getValue(FILTER));
        }
    }

    static class FeatureHandler
    extends DelegetingHandler {
        private static final String FEATURE = "feature";
        private static final String COLOCATION_AFFINITY = "colocation-affinity";
        private static final String PRIMARY = "primary";
        private static final String EXCLUSIVE = "exclusive";
        private static final String PLUGIN = "plugin";
        private static final String APPLICATION = "application";
        private static final String ARCH = "arch";
        private static final String NL = "nl";
        private static final String WS = "ws";
        private static final String OS = "os";
        private static final String VERSION = "version";
        private static final String ID = "id";
        private static final String PROVIDER_NAME = "provider-name";
        private static final String LABEL = "label";
        private static final String IMAGE = "image";
        EclipseFeature feature;

        public FeatureHandler() {
            super(FEATURE);
            this.addChild(new DescriptionHandler(), new DelegetingHandler.ChildElementHandler(){

                @Override
                public void childHanlded(DelegetingHandler delegetingHandler) {
                    FeatureHandler.this.feature.setDescription(delegetingHandler.getBufferedChars().trim());
                }
            });
            this.addChild(new LicenseHandler(), new DelegetingHandler.ChildElementHandler(){

                @Override
                public void childHanlded(DelegetingHandler delegetingHandler) {
                    FeatureHandler.this.feature.setLicense(delegetingHandler.getBufferedChars().trim());
                }
            });
            this.addChild(new CopyrightHandler(), new DelegetingHandler.ChildElementHandler(){

                @Override
                public void childHanlded(DelegetingHandler delegetingHandler) {
                    FeatureHandler.this.feature.setCopyright(delegetingHandler.getBufferedChars().trim());
                }
            });
            this.addChild(new PluginHandler(), new DelegetingHandler.ChildElementHandler(){

                @Override
                public void childHanlded(DelegetingHandler delegetingHandler) {
                    FeatureHandler.this.feature.addPlugin(((PluginHandler)delegetingHandler).plugin);
                }
            });
            this.addChild(new RequiresHandler(), new DelegetingHandler.ChildElementHandler(){

                @Override
                public void childHanlded(DelegetingHandler delegetingHandler) {
                    Iterator iterator = ((RequiresHandler)delegetingHandler).requires.iterator();
                    while (iterator.hasNext()) {
                        FeatureHandler.this.feature.addRequire((Require)iterator.next());
                    }
                }
            });
            this.addChild(new UrlHandler(), new DelegetingHandler.ChildElementHandler(){

                @Override
                public void childHanlded(DelegetingHandler delegetingHandler) {
                }
            });
        }

        @Override
        protected void handleAttributes(Attributes attributes) throws SAXException {
            String string = attributes.getValue(ID);
            String string2 = attributes.getValue(VERSION);
            try {
                this.feature = new EclipseFeature(string, new Version(string2));
            }
            catch (ParseException parseException) {
                throw new SAXException("Incorrect version on feature '" + string + "': " + string2 + " (" + parseException.getMessage() + ")");
            }
            this.feature.setOS(attributes.getValue(OS));
            this.feature.setWS(attributes.getValue(WS));
            this.feature.setNL(attributes.getValue(NL));
            this.feature.setArch(attributes.getValue(ARCH));
            this.feature.setApplication(attributes.getValue(APPLICATION));
            this.feature.setPlugin(attributes.getValue(PLUGIN));
            this.feature.setExclusive(Boolean.valueOf(attributes.getValue(EXCLUSIVE)));
            this.feature.setPrimary(Boolean.valueOf(attributes.getValue(PRIMARY)));
            this.feature.setColocationAffinity(attributes.getValue(COLOCATION_AFFINITY));
            this.feature.setProviderName(attributes.getValue(PROVIDER_NAME));
            this.feature.setLabel(attributes.getValue(LABEL));
            this.feature.setImage(attributes.getValue(IMAGE));
        }
    }
}

