/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv.xs;

import org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.xs.TypeValidator;
import org.apache.xerces.impl.validation.ValidationContext;

public class DoubleDV
extends TypeValidator {
    public short getAllowedFacets() {
        return 1016;
    }

    public Object getActualValue(String string, ValidationContext validationContext) throws InvalidDatatypeValueException {
        try {
            return DoubleDV.dValueOf(string);
        }
        catch (Exception exception) {
            throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.1", new Object[]{string, "double"});
        }
    }

    public int compare(Object object, Object object2) {
        return this.compareDoubles((Double)object, (Double)object2);
    }

    private static Double dValueOf(String string) throws NumberFormatException {
        Double d;
        try {
            d = Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            if (string.equals("INF")) {
                d = new Double(Double.POSITIVE_INFINITY);
            }
            if (string.equals("-INF")) {
                d = new Double(Double.NEGATIVE_INFINITY);
            }
            if (string.equals("NaN")) {
                d = new Double(Double.NaN);
            }
            throw numberFormatException;
        }
        return d;
    }

    private int compareDoubles(Double d, Double d2) {
        long l;
        double d3;
        double d4 = d;
        if (d4 < (d3 = d2.doubleValue())) {
            return -1;
        }
        if (d4 > d3) {
            return 1;
        }
        long l2 = Double.doubleToLongBits(d4);
        return l2 == (l = Double.doubleToLongBits(d3)) ? 0 : (l2 < l ? -1 : 1);
    }
}

