/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.rfb;

import com.tigervnc.rdr.InStream;
import com.tigervnc.rdr.OutStream;
import com.tigervnc.rfb.Exception;
import com.tigervnc.rfb.Rect;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.HashMap;

public class PixelFormat {
    private static HashMap<Integer, ColorConvertOp> converters;
    public int bpp;
    public int depth;
    public boolean bigEndian;
    public boolean trueColour;
    public int redMax;
    public int greenMax;
    public int blueMax;
    public int redShift;
    public int greenShift;
    public int blueShift;
    protected int redBits;
    protected int greenBits;
    protected int blueBits;
    protected int maxBits;
    protected int minBits;
    protected boolean endianMismatch;
    private ColorModel model;

    public PixelFormat(int n, int n2, boolean bl, boolean bl2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.bpp = n;
        this.depth = n2;
        this.trueColour = bl2;
        this.bigEndian = bl;
        this.redMax = n3;
        this.greenMax = n4;
        this.blueMax = n5;
        this.redShift = n6;
        this.greenShift = n7;
        this.blueShift = n8;
        converters = new HashMap();
        assert (this.isSane());
        this.updateState();
    }

    public PixelFormat() {
        this(8, 8, false, true, 7, 7, 3, 0, 3, 6);
        this.updateState();
    }

    public boolean equal(PixelFormat pixelFormat) {
        if (this.bpp != pixelFormat.bpp || this.depth != pixelFormat.depth) {
            return false;
        }
        if (this.redMax != pixelFormat.redMax) {
            return false;
        }
        if (this.greenMax != pixelFormat.greenMax) {
            return false;
        }
        if (this.blueMax != pixelFormat.blueMax) {
            return false;
        }
        if (this.bigEndian == pixelFormat.bigEndian || this.bpp == 8) {
            if (this.redShift != pixelFormat.redShift) {
                return false;
            }
            if (this.greenShift != pixelFormat.greenShift) {
                return false;
            }
            if (this.blueShift != pixelFormat.blueShift) {
                return false;
            }
        } else {
            if (this.redShift / 8 != 3 - pixelFormat.redShift / 8) {
                return false;
            }
            if (this.greenShift / 8 != 3 - pixelFormat.greenShift / 8) {
                return false;
            }
            if (this.blueShift / 8 != 3 - pixelFormat.blueShift / 8) {
                return false;
            }
            if (this.redShift % 8 != pixelFormat.redShift % 8) {
                return false;
            }
            if (this.greenShift % 8 != pixelFormat.greenShift % 8) {
                return false;
            }
            if (this.blueShift % 8 != pixelFormat.blueShift % 8) {
                return false;
            }
            if (this.redShift / 8 != (this.redShift + this.redBits - 1) / 8) {
                return false;
            }
            if (this.greenShift / 8 != (this.greenShift + this.greenBits - 1) / 8) {
                return false;
            }
            if (this.blueShift / 8 != (this.blueShift + this.blueBits - 1) / 8) {
                return false;
            }
        }
        return true;
    }

    public void read(InStream inStream) {
        this.bpp = inStream.readU8();
        this.depth = inStream.readU8();
        this.bigEndian = inStream.readU8() != 0;
        this.trueColour = inStream.readU8() != 0;
        this.redMax = inStream.readU16();
        this.greenMax = inStream.readU16();
        this.blueMax = inStream.readU16();
        this.redShift = inStream.readU8();
        this.greenShift = inStream.readU8();
        this.blueShift = inStream.readU8();
        inStream.skip(3);
        if (!this.trueColour) {
            this.redMax = 7;
            this.greenMax = 7;
            this.blueMax = 3;
            this.redShift = 0;
            this.greenShift = 3;
            this.blueShift = 6;
        }
        if (!this.isSane()) {
            throw new Exception("invalid pixel format: " + this.print());
        }
        this.updateState();
    }

    public void write(OutStream outStream) {
        outStream.writeU8(this.bpp);
        outStream.writeU8(this.depth);
        outStream.writeU8(this.bigEndian ? 1 : 0);
        outStream.writeU8(this.trueColour ? 1 : 0);
        outStream.writeU16(this.redMax);
        outStream.writeU16(this.greenMax);
        outStream.writeU16(this.blueMax);
        outStream.writeU8(this.redShift);
        outStream.writeU8(this.greenShift);
        outStream.writeU8(this.blueShift);
        outStream.pad(3);
    }

    public final boolean isBigEndian() {
        return this.bigEndian;
    }

    public final boolean isLittleEndian() {
        return !this.bigEndian;
    }

    public final boolean is888() {
        if (!this.trueColour) {
            return false;
        }
        if (this.bpp != 32) {
            return false;
        }
        if (this.depth != 24) {
            return false;
        }
        if (this.redMax != 255) {
            return false;
        }
        if (this.greenMax != 255) {
            return false;
        }
        return this.blueMax == 255;
    }

    public int pixelFromRGB(int n, int n2, int n3, ColorModel colorModel) {
        if (this.trueColour) {
            int n4 = (n * this.redMax + Short.MAX_VALUE) / 65535;
            int n5 = (n2 * this.greenMax + Short.MAX_VALUE) / 65535;
            int n6 = (n3 * this.blueMax + Short.MAX_VALUE) / 65535;
            return n4 << this.redShift | n5 << this.greenShift | n6 << this.blueShift;
        }
        if (colorModel != null) {
            int n7 = 1 << this.depth;
            int n8 = 262144;
            int n9 = 0;
            for (int i = 0; i < n7; ++i) {
                int n10;
                int n11;
                int n12;
                int n13;
                int n14 = colorModel.getRed(i);
                int n15 = n14 - n >> 8;
                int n16 = n15 * n15 + (n13 = (n12 = colorModel.getGreen(i)) - n2 >> 8) * n13 + (n11 = (n10 = colorModel.getBlue(i)) - n3 >> 8) * n11;
                if (n16 >= n8) continue;
                n9 = i;
                n8 = n16;
            }
            return n9;
        }
        return 0;
    }

    public void bufferFromRGB(ByteBuffer byteBuffer, ByteBuffer byteBuffer2, int n) {
        this.bufferFromRGB(byteBuffer, byteBuffer2, n, n, 1);
    }

    public void bufferFromRGB(ByteBuffer byteBuffer, ByteBuffer byteBuffer2, int n, int n2, int n3) {
        if (this.is888()) {
            int n4;
            int n5;
            int n6;
            int n7;
            if (this.bigEndian) {
                n7 = byteBuffer.position() + (24 - this.redShift) / 8;
                n6 = byteBuffer.position() + (24 - this.greenShift) / 8;
                n5 = byteBuffer.position() + (24 - this.blueShift) / 8;
                n4 = byteBuffer.position() + (24 - (48 - this.redShift - this.greenShift - this.blueShift)) / 8;
            } else {
                n7 = byteBuffer.position() + this.redShift / 8;
                n6 = byteBuffer.position() + this.greenShift / 8;
                n5 = byteBuffer.position() + this.blueShift / 8;
                n4 = byteBuffer.position() + (48 - this.redShift - this.greenShift - this.blueShift) / 8;
            }
            int n8 = (n2 - n) * 4;
            while (n3-- > 0) {
                int n9 = n;
                while (n9-- > 0) {
                    byteBuffer.put(n7, byteBuffer2.get());
                    byteBuffer.put(n6, byteBuffer2.get());
                    byteBuffer.put(n5, byteBuffer2.get());
                    byteBuffer.put(n4, (byte)0);
                    n7 += 4;
                    n6 += 4;
                    n5 += 4;
                    n4 += 4;
                }
                n7 += n8;
                n6 += n8;
                n5 += n8;
                n4 += n8;
            }
        } else {
            int n10 = (n2 - n) * this.bpp / 8;
            while (n3-- > 0) {
                int n11 = n;
                while (n11-- > 0) {
                    byte by = byteBuffer2.get();
                    byte by2 = byteBuffer2.get();
                    byte by3 = byteBuffer2.get();
                    int n12 = this.pixelFromRGB(by, by2, by3, this.model);
                    this.bufferFromPixel(byteBuffer, n12);
                    byteBuffer.position(byteBuffer.position() + this.bpp / 8);
                }
                byteBuffer.position(byteBuffer.position() + n10);
            }
        }
    }

    public void rgbFromBuffer(ByteBuffer byteBuffer, ByteBuffer byteBuffer2, int n) {
        this.rgbFromBuffer(byteBuffer, byteBuffer2, n, n, 1);
    }

    public void rgbFromBuffer(ByteBuffer byteBuffer, ByteBuffer byteBuffer2, int n, int n2, int n3) {
        if (this.is888()) {
            int n4;
            int n5;
            int n6;
            if (this.bigEndian) {
                n6 = byteBuffer2.position() + (24 - this.redShift) / 8;
                n5 = byteBuffer2.position() + (24 - this.greenShift) / 8;
                n4 = byteBuffer2.position() + (24 - this.blueShift) / 8;
            } else {
                n6 = byteBuffer2.position() + this.redShift / 8;
                n5 = byteBuffer2.position() + this.greenShift / 8;
                n4 = byteBuffer2.position() + this.blueShift / 8;
            }
            int n7 = (n2 - n) * 4;
            while (n3-- > 0) {
                int n8 = n;
                while (n8-- > 0) {
                    byteBuffer.put(byteBuffer2.get(n6));
                    byteBuffer.put(byteBuffer2.get(n5));
                    byteBuffer.put(byteBuffer2.get(n4));
                    n6 += 4;
                    n5 += 4;
                    n4 += 4;
                }
                n6 += n7;
                n5 += n7;
                n4 += n7;
            }
        } else {
            int n9 = (n2 - n) * this.bpp / 8;
            while (n3-- > 0) {
                int n10 = n;
                while (n10-- > 0) {
                    int n11 = this.pixelFromBuffer(byteBuffer2.duplicate());
                    byte by = (byte)this.getColorModel().getRed(n11);
                    byte by2 = (byte)this.getColorModel().getGreen(n11);
                    byte by3 = (byte)this.getColorModel().getBlue(n11);
                    byteBuffer.put(by);
                    byteBuffer.put(by2);
                    byteBuffer.put(by3);
                    byteBuffer2.position(byteBuffer2.position() + this.bpp / 8);
                }
                byteBuffer2.reset().position(byteBuffer2.position() + n9).mark();
            }
        }
    }

    public void rgbFromPixels(byte[] byArray, int n, int[] nArray, int n2, int n3, ColorModel colorModel) {
        for (int i = 0; i < n3; ++i) {
            int n4 = nArray[i];
            byArray[n++] = (byte)colorModel.getRed(n4);
            byArray[n++] = (byte)colorModel.getGreen(n4);
            byArray[n++] = (byte)colorModel.getBlue(n4);
        }
    }

    public int pixelFromBuffer(ByteBuffer byteBuffer) {
        int n = -16777216;
        if (!this.bigEndian) {
            switch (this.bpp) {
                case 32: {
                    n |= byteBuffer.get() << 24;
                    n |= byteBuffer.get() << 16;
                }
                case 16: {
                    n |= byteBuffer.get() << 8;
                }
                case 8: {
                    n |= byteBuffer.get();
                }
            }
        } else {
            n |= byteBuffer.get(0);
            if (this.bpp >= 16) {
                n |= byteBuffer.get(1) << 8;
                if (this.bpp == 32) {
                    n |= byteBuffer.get(2) << 16;
                    n |= byteBuffer.get(3) << 24;
                }
            }
        }
        return n;
    }

    public String print() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("depth " + this.depth + " (" + this.bpp + "bpp)");
        if (this.bpp != 8) {
            if (this.bigEndian) {
                stringBuffer.append(" big-endian");
            } else {
                stringBuffer.append(" little-endian");
            }
        }
        if (!this.trueColour) {
            stringBuffer.append(" colour-map");
            return stringBuffer.toString();
        }
        if (this.blueShift == 0 && this.greenShift > this.blueShift && this.redShift > this.greenShift && this.blueMax == (1 << this.greenShift) - 1 && this.greenMax == (1 << this.redShift - this.greenShift) - 1 && this.redMax == (1 << this.depth - this.redShift) - 1) {
            stringBuffer.append(" rgb" + (this.depth - this.redShift) + (this.redShift - this.greenShift) + this.greenShift);
            return stringBuffer.toString();
        }
        if (this.redShift == 0 && this.greenShift > this.redShift && this.blueShift > this.greenShift && this.redMax == (1 << this.greenShift) - 1 && this.greenMax == (1 << this.blueShift - this.greenShift) - 1 && this.blueMax == (1 << this.depth - this.blueShift) - 1) {
            stringBuffer.append(" bgr" + (this.depth - this.blueShift) + (this.blueShift - this.greenShift) + this.greenShift);
            return stringBuffer.toString();
        }
        stringBuffer.append(" rgb max " + this.redMax + "," + this.greenMax + "," + this.blueMax + " shift " + this.redShift + "," + this.greenShift + "," + this.blueShift);
        return stringBuffer.toString();
    }

    private static int bits(int n) {
        int n2 = 16;
        if ((n & 0xFF00) == 0) {
            n2 -= 8;
            n <<= 8;
        }
        if ((n & 0xF000) == 0) {
            n2 -= 4;
            n <<= 4;
        }
        if ((n & 0xC000) == 0) {
            n2 -= 2;
            n <<= 2;
        }
        if ((n & 0x8000) == 0) {
            --n2;
            n <<= 1;
        }
        return n2;
    }

    private void updateState() {
        boolean bl = true;
        this.redBits = PixelFormat.bits(this.redMax);
        this.greenBits = PixelFormat.bits(this.greenMax);
        this.blueBits = PixelFormat.bits(this.blueMax);
        this.maxBits = this.redBits;
        if (this.greenBits > this.maxBits) {
            this.maxBits = this.greenBits;
        }
        if (this.blueBits > this.maxBits) {
            this.maxBits = this.blueBits;
        }
        this.minBits = this.redBits;
        if (this.greenBits < this.minBits) {
            this.minBits = this.greenBits;
        }
        if (this.blueBits < this.minBits) {
            this.minBits = this.blueBits;
        }
        this.endianMismatch = (char)(bl ? 1 : 0) == '\u0000' != this.bigEndian;
        this.model = PixelFormat.getColorModel(this);
    }

    private boolean isSane() {
        if (this.bpp != 8 && this.bpp != 16 && this.bpp != 32) {
            return false;
        }
        if (this.depth > this.bpp) {
            return false;
        }
        if (!this.trueColour && this.depth != 8) {
            return false;
        }
        if ((this.redMax & this.redMax + 1) != 0) {
            return false;
        }
        if ((this.greenMax & this.greenMax + 1) != 0) {
            return false;
        }
        if ((this.blueMax & this.blueMax + 1) != 0) {
            return false;
        }
        if (this.redMax >= 256) {
            return false;
        }
        if (this.greenMax >= 256) {
            return false;
        }
        if (this.blueMax >= 256) {
            return false;
        }
        int n = PixelFormat.bits(this.redMax) + PixelFormat.bits(this.greenMax) + PixelFormat.bits(this.blueMax);
        if (n > this.bpp) {
            return false;
        }
        if ((this.redMax << this.redShift & this.greenMax << this.greenShift) != 0) {
            return false;
        }
        if ((this.redMax << this.redShift & this.blueMax << this.blueShift) != 0) {
            return false;
        }
        return (this.greenMax << this.greenShift & this.blueMax << this.blueShift) == 0;
    }

    public void bufferFromPixel(ByteBuffer byteBuffer, int n) {
        if (this.bigEndian) {
            switch (this.bpp) {
                case 32: {
                    byteBuffer.put((byte)(n >> 24 & 0xFF));
                    byteBuffer.put((byte)(n >> 16 & 0xFF));
                    break;
                }
                case 16: {
                    byteBuffer.put((byte)(n >> 8 & 0xFF));
                    break;
                }
                case 8: {
                    byteBuffer.put((byte)(n >> 0 & 0xFF));
                }
            }
        } else {
            byteBuffer.put(0, (byte)(n >> 0 & 0xFF));
            if (this.bpp >= 16) {
                byteBuffer.put(1, (byte)(n >> 8 & 0xFF));
                if (this.bpp == 32) {
                    byteBuffer.put(2, (byte)(n >> 16 & 0xFF));
                    byteBuffer.put(3, (byte)(n >> 24 & 0xFF));
                }
            }
        }
    }

    public ColorModel getColorModel() {
        return this.model;
    }

    public static ColorModel getColorModel(PixelFormat pixelFormat) {
        DirectColorModel directColorModel;
        if (pixelFormat.bpp != 32 && pixelFormat.bpp != 16 && pixelFormat.bpp != 8) {
            throw new Exception("Internal error: bpp must be 8, 16, or 32 in PixelBuffer (" + pixelFormat.bpp + ")");
        }
        switch (pixelFormat.depth) {
            case 3: 
            case 6: 
            case 8: {
                int n = pixelFormat.redMax << pixelFormat.redShift;
                int n2 = pixelFormat.greenMax << pixelFormat.greenShift;
                int n3 = pixelFormat.blueMax << pixelFormat.blueShift;
                directColorModel = new DirectColorModel(8, n, n2, n3);
                break;
            }
            case 16: {
                directColorModel = new DirectColorModel(32, 63488, 1984, 62);
                break;
            }
            case 24: {
                directColorModel = new DirectColorModel(32, 0xFF0000, 65280, 255);
                break;
            }
            case 32: {
                directColorModel = new DirectColorModel(32, 255 << pixelFormat.redShift, 255 << pixelFormat.greenShift, 255 << pixelFormat.blueShift);
                break;
            }
            default: {
                throw new Exception("Unsupported color depth (" + pixelFormat.depth + ")");
            }
        }
        assert (directColorModel != null);
        return directColorModel;
    }

    public ColorConvertOp getColorConvertOp(ColorSpace colorSpace) {
        if (converters.containsKey(colorSpace.getType())) {
            return converters.get(colorSpace.getType());
        }
        ColorSpace colorSpace2 = this.model.getColorSpace();
        converters.put(colorSpace.getType(), new ColorConvertOp(colorSpace, colorSpace2, null));
        return converters.get(colorSpace.getType());
    }

    public ByteOrder getByteOrder() {
        if (this.isBigEndian()) {
            return ByteOrder.BIG_ENDIAN;
        }
        return ByteOrder.LITTLE_ENDIAN;
    }

    public Raster rasterFromBuffer(Rect rect, ByteBuffer byteBuffer) {
        DataBuffer dataBuffer = null;
        SampleModel sampleModel = this.model.createCompatibleSampleModel(rect.width(), rect.height());
        switch (sampleModel.getTransferType()) {
            case 3: {
                IntBuffer intBuffer = IntBuffer.allocate(rect.area()).put(byteBuffer.asIntBuffer());
                dataBuffer = new DataBufferInt(intBuffer.array(), rect.area());
                break;
            }
            case 0: {
                dataBuffer = new DataBufferByte(byteBuffer.array(), rect.area());
                break;
            }
            case 2: {
                ShortBuffer shortBuffer = ShortBuffer.allocate(rect.area()).put(byteBuffer.asShortBuffer());
                dataBuffer = new DataBufferShort(shortBuffer.array(), rect.area());
            }
        }
        assert (dataBuffer != null);
        return Raster.createRaster(sampleModel, dataBuffer, new Point(0, 0));
    }
}

