#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: cassava
version: 0.5.1.0
id: cassava-0.5.1.0-IziCH9MccNRDFXn8aW8fS0
key: cassava-0.5.1.0-IziCH9MccNRDFXn8aW8fS0
license: BSD3
copyright: (c) 2012 Johan Tibell
           (c) 2012 Bryan O'\''Sullivan
           (c) 2011 MailRank, Inc.
maintainer: hvr@gnu.org
homepage: https://github.com/hvr/cassava
synopsis: A CSV parsing and encoding library
description:
    @cassava@ is a library for parsing and encoding [RFC 4180](https://tools.ietf.org/html/rfc4180)
    compliant [comma-separated values (CSV)](https://en.wikipedia.org/wiki/Comma-separated_values) data,
    which is a textual line-oriented format commonly used for exchanging tabular data.
    .
    @cassava@'\''s API includes support for
    .
    - Index-based record-conversion
    - Name-based record-conversion
    - Typeclass directed conversion of fields and records
    - Built-in field-conversion instances for standard types
    - Customizable record-conversion instance derivation via GHC generics
    - Low-level [bytestring](https://hackage.haskell.org/package/bytestring) builders (see "Data.Csv.Builder")
    - Incremental decoding and encoding API (see "Data.Csv.Incremental")
    - Streaming API for constant-space decoding (see "Data.Csv.Streaming")
    .
    Moreover, this library is designed to be easy to use; for instance, here'\''s a
    very simple example of encoding CSV data:
    .
    >>> Data.Csv.encode [("John",27),("Jane",28)]
    "John,27\r\nJane,28\r\n"
    .
    Please refer to the documentation in "Data.Csv" and the included [README](#readme) for more usage examples.
category: Text, Web, CSV
author: Johan Tibell
exposed: True
exposed-modules:
    Data.Csv Data.Csv.Builder Data.Csv.Incremental Data.Csv.Parser
    Data.Csv.Streaming
hidden-modules: Data.Csv.Conversion Data.Csv.Conversion.Internal
                Data.Csv.Encoding Data.Csv.Types Data.Csv.Util
abi: 82dee823e7751473ea07a14cf4d754b6
trusted: False
import-dirs: /usr/lib/ghc-8.0.2/site-local/cassava-0.5.1.0
library-dirs: /usr/lib/ghc-8.0.2/site-local/cassava-0.5.1.0
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.0.2/cassava-0.5.1.0
hs-libraries: HScassava-0.5.1.0-IziCH9MccNRDFXn8aW8fS0
depends:
    Only-0.1-1dkiXHtbc8zGqo2Q6b73I6 array-0.5.1.1
    attoparsec-0.13.2.0-JkqjYPxw7sG9Iq2J4E1Ndn base-4.9.1.0
    bytestring-0.10.8.1 containers-0.5.7.1 deepseq-1.4.2.0
    hashable-1.2.6.1-2nPqxcHq7mUGgurrYaLtXr
    scientific-0.3.5.1-3aJEdQvcyho88FhIoGrzGS
    text-1.2.2.2-3ENqlljngKa6xj1Go2fVWq
    text-short-0.1-A5My3POkYrKIsx4tZcD2Wl
    unordered-containers-0.2.8.0-1tqMF698WJE3INvmpuzQZc
    vector-0.12.0.1-692PQMDMB6pIQ1uGwefDcQ
haddock-interfaces: /usr/share/doc/haskell-cassava/html/cassava.haddock
haddock-html: /usr/share/doc/haskell-cassava/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"
