/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.TransferHandler;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.SwingGUI;
import net.sf.freecol.client.gui.panel.AbstractGoodsLabel;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.client.gui.panel.PortPanel;
import net.sf.freecol.client.gui.panel.QuickActionMenu;
import net.sf.freecol.client.gui.panel.UnitLabel;
import net.sf.freecol.common.model.Unit;

public final class DragListener
extends MouseAdapter {
    private static final Logger logger = Logger.getLogger(DragListener.class.getName());
    private final FreeColPanel parentPanel;
    private final FreeColClient freeColClient;

    public DragListener(FreeColClient freeColClient, FreeColPanel parentPanel) {
        this.freeColClient = freeColClient;
        this.parentPanel = parentPanel;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        JComponent comp = (JComponent)e.getSource();
        if (e.getButton() == 3 || e.isPopupTrigger()) {
            boolean small;
            if (!this.parentPanel.isEditable()) {
                logger.warning("Button3 disabled on non-editable panel: " + this.parentPanel);
                return;
            }
            QuickActionMenu menu = new QuickActionMenu(this.freeColClient, this.parentPanel).addMenuItems(comp);
            int lastIdx = menu.getComponentCount() - 1;
            if (lastIdx >= 0 && menu.getComponent(lastIdx) instanceof JPopupMenu.Separator) {
                menu.remove(lastIdx);
            }
            if (menu.getComponentCount() <= 0) {
                return;
            }
            SwingGUI gui = (SwingGUI)this.freeColClient.getGUI();
            boolean windows = System.getProperty("os.name").startsWith("Windows");
            boolean bl = small = Toolkit.getDefaultToolkit().getScreenSize().getHeight() < 768.0;
            if (gui.isWindowed() && windows) {
                menu.show(gui.getCanvas(), menu.getLocation().x, 0);
            } else if (!gui.isWindowed() && small) {
                menu.show(gui.getCanvas(), menu.getLocation().x, 0);
            } else {
                menu.show(comp, e.getX(), e.getY());
            }
        } else {
            Unit u;
            JLabel label;
            if (comp instanceof AbstractGoodsLabel) {
                label = (AbstractGoodsLabel)comp;
                if (e.isShiftDown()) {
                    ((AbstractGoodsLabel)label).setPartialChosen(true);
                } else if (e.isControlDown()) {
                    ((AbstractGoodsLabel)label).setFullChosen(true);
                } else {
                    ((AbstractGoodsLabel)label).setPartialChosen(false);
                    ((AbstractGoodsLabel)label).setDefaultAmount();
                }
            } else if (comp instanceof UnitLabel && (u = ((UnitLabel)(label = (UnitLabel)comp)).getUnit()).isCarrier() && !u.isAtSea() && this.parentPanel instanceof PortPanel) {
                ((PortPanel)this.parentPanel).setSelectedUnitLabel((UnitLabel)label);
            }
            TransferHandler handler = comp.getTransferHandler();
            if (handler != null) {
                handler.exportAsDrag(comp, e, 1);
            }
        }
    }
}

