/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.engine.control;

import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.jcs.auxiliary.AuxiliaryCache;
import org.apache.commons.jcs.auxiliary.AuxiliaryCacheAttributes;
import org.apache.commons.jcs.auxiliary.AuxiliaryCacheConfigurator;
import org.apache.commons.jcs.auxiliary.AuxiliaryCacheFactory;
import org.apache.commons.jcs.engine.behavior.ICompositeCacheAttributes;
import org.apache.commons.jcs.engine.behavior.IElementAttributes;
import org.apache.commons.jcs.engine.behavior.IElementSerializer;
import org.apache.commons.jcs.engine.behavior.IRequireScheduler;
import org.apache.commons.jcs.engine.control.CompositeCache;
import org.apache.commons.jcs.engine.control.CompositeCacheManager;
import org.apache.commons.jcs.engine.logging.behavior.ICacheEventLogger;
import org.apache.commons.jcs.engine.match.KeyMatcherPatternImpl;
import org.apache.commons.jcs.engine.match.behavior.IKeyMatcher;
import org.apache.commons.jcs.utils.config.OptionConverter;
import org.apache.commons.jcs.utils.config.PropertySetter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CompositeCacheConfigurator {
    private static final Log log = LogFactory.getLog(CompositeCacheConfigurator.class);
    protected static final String SYSTEM_PROPERTY_KEY_PREFIX = "jcs";
    protected static final String REGION_PREFIX = "jcs.region.";
    protected static final String SYSTEM_REGION_PREFIX = "jcs.system.";
    protected static final String AUXILIARY_PREFIX = "jcs.auxiliary.";
    protected static final String ATTRIBUTE_PREFIX = ".attributes";
    protected static final String CACHE_ATTRIBUTE_PREFIX = ".cacheattributes";
    protected static final String ELEMENT_ATTRIBUTE_PREFIX = ".elementattributes";
    public static final String KEY_MATCHER_PREFIX = ".keymatcher";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseSystemRegions(Properties properties, CompositeCacheManager compositeCacheManager) {
        for (String string : properties.stringPropertyNames()) {
            CompositeCache compositeCache;
            if (!string.startsWith(SYSTEM_REGION_PREFIX) || string.indexOf("attributes") != -1) continue;
            String string2 = string.substring(SYSTEM_REGION_PREFIX.length());
            String string3 = OptionConverter.findAndSubst(string, properties);
            String string4 = string2;
            synchronized (string4) {
                compositeCache = this.parseRegion(properties, compositeCacheManager, string2, string3, null, SYSTEM_REGION_PREFIX);
            }
            compositeCacheManager.addCache(string2, compositeCache);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseRegions(Properties properties, CompositeCacheManager compositeCacheManager) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : properties.stringPropertyNames()) {
            CompositeCache compositeCache;
            if (!string.startsWith(REGION_PREFIX) || string.indexOf("attributes") != -1) continue;
            String string2 = string.substring(REGION_PREFIX.length());
            arrayList.add(string2);
            String string3 = OptionConverter.findAndSubst(string, properties);
            String string4 = string2;
            synchronized (string4) {
                compositeCache = this.parseRegion(properties, compositeCacheManager, string2, string3);
            }
            compositeCacheManager.addCache(string2, compositeCache);
        }
        if (log.isInfoEnabled()) {
            log.info("Parsed regions " + arrayList);
        }
    }

    protected <K, V> CompositeCache<K, V> parseRegion(Properties properties, CompositeCacheManager compositeCacheManager, String string, String string2) {
        return this.parseRegion(properties, compositeCacheManager, string, string2, null, REGION_PREFIX);
    }

    protected <K, V> CompositeCache<K, V> parseRegion(Properties properties, CompositeCacheManager compositeCacheManager, String string, String string2, ICompositeCacheAttributes iCompositeCacheAttributes) {
        return this.parseRegion(properties, compositeCacheManager, string, string2, iCompositeCacheAttributes, REGION_PREFIX);
    }

    protected <K, V> CompositeCache<K, V> parseRegion(Properties properties, CompositeCacheManager compositeCacheManager, String string, String string2, ICompositeCacheAttributes iCompositeCacheAttributes, String string3) {
        IElementAttributes iElementAttributes = this.parseElementAttributes(properties, string, compositeCacheManager.getDefaultElementAttributes(), string3);
        CompositeCache compositeCache = iCompositeCacheAttributes == null ? new CompositeCache(this.parseCompositeCacheAttributes(properties, string, compositeCacheManager.getDefaultCacheAttributes(), string3), iElementAttributes) : new CompositeCache(iCompositeCacheAttributes, iElementAttributes);
        compositeCache.setCompositeCacheManager(compositeCacheManager);
        compositeCache.setScheduledExecutorService(compositeCacheManager.getScheduledExecutorService());
        compositeCache.setElementEventQueue(compositeCacheManager.getElementEventQueue());
        if (compositeCache.getMemoryCache() instanceof IRequireScheduler) {
            ((IRequireScheduler)((Object)compositeCache.getMemoryCache())).setScheduledExecutorService(compositeCacheManager.getScheduledExecutorService());
        }
        if (string2 != null) {
            ArrayList<AuxiliaryCache<K, V>> arrayList = new ArrayList<AuxiliaryCache<K, V>>();
            if (log.isDebugEnabled()) {
                log.debug("Parsing region name '" + string + "', value '" + string2 + "'");
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            if (!(string2.startsWith(",") || string2.equals("") || stringTokenizer.hasMoreTokens())) {
                return null;
            }
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken().trim();
                if (string4 == null || string4.equals(",")) continue;
                log.debug("Parsing auxiliary named \"" + string4 + "\".");
                AuxiliaryCache<K, V> auxiliaryCache = this.parseAuxiliary(properties, compositeCacheManager, string4, string);
                if (auxiliaryCache == null) continue;
                if (auxiliaryCache instanceof IRequireScheduler) {
                    ((IRequireScheduler)((Object)auxiliaryCache)).setScheduledExecutorService(compositeCacheManager.getScheduledExecutorService());
                }
                arrayList.add(auxiliaryCache);
            }
            AuxiliaryCache[] auxiliaryCacheArray = arrayList.toArray(new AuxiliaryCache[0]);
            compositeCache.setAuxCaches(auxiliaryCacheArray);
        }
        return compositeCache;
    }

    protected ICompositeCacheAttributes parseCompositeCacheAttributes(Properties properties, String string, ICompositeCacheAttributes iCompositeCacheAttributes) {
        return this.parseCompositeCacheAttributes(properties, string, iCompositeCacheAttributes, REGION_PREFIX);
    }

    protected ICompositeCacheAttributes parseCompositeCacheAttributes(Properties properties, String string, ICompositeCacheAttributes iCompositeCacheAttributes, String string2) {
        String string3 = string2 + string + CACHE_ATTRIBUTE_PREFIX;
        ICompositeCacheAttributes iCompositeCacheAttributes2 = OptionConverter.instantiateByKey(properties, string3, null);
        if (iCompositeCacheAttributes2 == null) {
            if (log.isInfoEnabled()) {
                log.info("No special CompositeCacheAttributes class defined for key [" + string3 + "], using default class.");
            }
            iCompositeCacheAttributes2 = iCompositeCacheAttributes;
        }
        if (log.isDebugEnabled()) {
            log.debug("Parsing options for '" + string3 + "'");
        }
        PropertySetter.setProperties(iCompositeCacheAttributes2, properties, string3 + ".");
        iCompositeCacheAttributes2.setCacheName(string);
        if (log.isDebugEnabled()) {
            log.debug("End of parsing for \"" + string3 + "\".");
        }
        iCompositeCacheAttributes2.setCacheName(string);
        return iCompositeCacheAttributes2;
    }

    protected IElementAttributes parseElementAttributes(Properties properties, String string, IElementAttributes iElementAttributes, String string2) {
        String string3 = string2 + string + ELEMENT_ATTRIBUTE_PREFIX;
        IElementAttributes iElementAttributes2 = OptionConverter.instantiateByKey(properties, string3, null);
        if (iElementAttributes2 == null) {
            if (log.isInfoEnabled()) {
                log.info("No special ElementAttribute class defined for key [" + string3 + "], using default class.");
            }
            iElementAttributes2 = iElementAttributes;
        }
        if (log.isDebugEnabled()) {
            log.debug("Parsing options for '" + string3 + "'");
        }
        PropertySetter.setProperties(iElementAttributes2, properties, string3 + ".");
        if (log.isDebugEnabled()) {
            log.debug("End of parsing for \"" + string3 + "\".");
        }
        return iElementAttributes2;
    }

    protected <K, V> AuxiliaryCache<K, V> parseAuxiliary(Properties properties, CompositeCacheManager compositeCacheManager, String string, String string2) {
        AuxiliaryCache auxiliaryCache;
        if (log.isDebugEnabled()) {
            log.debug("parseAuxiliary " + string);
        }
        if ((auxiliaryCache = compositeCacheManager.getAuxiliaryCache(string, string2)) == null) {
            String string3;
            Object object;
            AuxiliaryCacheFactory auxiliaryCacheFactory = compositeCacheManager.registryFacGet(string);
            if (auxiliaryCacheFactory == null) {
                object = AUXILIARY_PREFIX + string;
                auxiliaryCacheFactory = OptionConverter.instantiateByKey(properties, (String)object, null);
                if (auxiliaryCacheFactory == null) {
                    log.error("Could not instantiate auxFactory named \"" + string + "\".");
                    return null;
                }
                auxiliaryCacheFactory.setName(string);
                if (auxiliaryCacheFactory instanceof IRequireScheduler) {
                    ((IRequireScheduler)((Object)auxiliaryCacheFactory)).setScheduledExecutorService(compositeCacheManager.getScheduledExecutorService());
                }
                auxiliaryCacheFactory.initialize();
                compositeCacheManager.registryFacPut(auxiliaryCacheFactory);
            }
            object = compositeCacheManager.registryAttrGet(string);
            String string4 = AUXILIARY_PREFIX + string + ATTRIBUTE_PREFIX;
            if (object == null) {
                string3 = AUXILIARY_PREFIX + string + ATTRIBUTE_PREFIX;
                object = OptionConverter.instantiateByKey(properties, string3, null);
                if (object == null) {
                    log.error("Could not instantiate auxAttr named '" + string4 + "'");
                    return null;
                }
                object.setName(string);
                compositeCacheManager.registryAttrPut((AuxiliaryCacheAttributes)object);
            }
            object = object.clone();
            if (log.isDebugEnabled()) {
                log.debug("Parsing options for '" + string4 + "'");
            }
            PropertySetter.setProperties(object, properties, string4 + ".");
            object.setCacheName(string2);
            if (log.isDebugEnabled()) {
                log.debug("End of parsing for '" + string4 + "'");
            }
            object.setCacheName(string2);
            string3 = AUXILIARY_PREFIX + string;
            ICacheEventLogger iCacheEventLogger = AuxiliaryCacheConfigurator.parseCacheEventLogger(properties, string3);
            IElementSerializer iElementSerializer = AuxiliaryCacheConfigurator.parseElementSerializer(properties, string3);
            try {
                auxiliaryCache = auxiliaryCacheFactory.createCache((AuxiliaryCacheAttributes)object, compositeCacheManager, iCacheEventLogger, iElementSerializer);
            }
            catch (Exception exception) {
                log.error("Could not instantiate auxiliary cache named \"" + string2 + "\".");
                return null;
            }
            compositeCacheManager.addAuxiliaryCache(string, string2, auxiliaryCache);
        }
        return auxiliaryCache;
    }

    protected static void overrideWithSystemProperties(Properties properties) {
        Properties properties2 = System.getProperties();
        for (String string : properties2.stringPropertyNames()) {
            if (!string.startsWith(SYSTEM_PROPERTY_KEY_PREFIX)) continue;
            if (log.isInfoEnabled()) {
                log.info("Using system property [[" + string + "] [" + properties2.getProperty(string) + "]]");
            }
            properties.setProperty(string, properties2.getProperty(string));
        }
    }

    protected <K> IKeyMatcher<K> parseKeyMatcher(Properties properties, String string) {
        String string2 = string + KEY_MATCHER_PREFIX;
        KeyMatcherPatternImpl keyMatcherPatternImpl = OptionConverter.instantiateByKey(properties, string2, null);
        if (keyMatcherPatternImpl != null) {
            String string3 = string + KEY_MATCHER_PREFIX + ATTRIBUTE_PREFIX;
            PropertySetter.setProperties(keyMatcherPatternImpl, properties, string3 + ".");
            if (log.isInfoEnabled()) {
                log.info("Using custom key matcher [" + keyMatcherPatternImpl + "] for auxiliary [" + string + "]");
            }
        } else {
            keyMatcherPatternImpl = new KeyMatcherPatternImpl();
            if (log.isInfoEnabled()) {
                log.info("Using standard key matcher [" + keyMatcherPatternImpl + "] for auxiliary [" + string + "]");
            }
        }
        return keyMatcherPatternImpl;
    }
}

