/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;

public class RelationToChildReference {
    private final Relation parent;
    private final int position;
    private final String role;
    private final OsmPrimitive child;

    public static Set<RelationToChildReference> getRelationToChildReferences(OsmPrimitive osmPrimitive) {
        Set<Relation> set = OsmPrimitive.getFilteredSet(osmPrimitive.getReferrers(), Relation.class);
        HashSet<RelationToChildReference> hashSet = new HashSet<RelationToChildReference>();
        for (Relation relation : set) {
            for (int i = 0; i < relation.getMembersCount(); ++i) {
                if (!relation.getMember(i).refersTo(osmPrimitive)) continue;
                hashSet.add(new RelationToChildReference(relation, i, relation.getMember(i)));
            }
        }
        return hashSet;
    }

    public static Set<RelationToChildReference> getRelationToChildReferences(Collection<? extends OsmPrimitive> collection) {
        HashSet<RelationToChildReference> hashSet = new HashSet<RelationToChildReference>();
        for (OsmPrimitive osmPrimitive : collection) {
            hashSet.addAll(RelationToChildReference.getRelationToChildReferences(osmPrimitive));
        }
        return hashSet;
    }

    public RelationToChildReference(Relation relation, int n, String string, OsmPrimitive osmPrimitive) {
        this.parent = relation;
        this.position = n;
        this.role = string;
        this.child = osmPrimitive;
    }

    public RelationToChildReference(Relation relation, int n, RelationMember relationMember) {
        this(relation, n, relationMember.getRole(), relationMember.getMember());
    }

    public Relation getParent() {
        return this.parent;
    }

    public int getPosition() {
        return this.position;
    }

    public String getRole() {
        return this.role;
    }

    public OsmPrimitive getChild() {
        return this.child;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        RelationToChildReference relationToChildReference = (RelationToChildReference)object;
        return this.position == relationToChildReference.position && Objects.equals(this.parent, relationToChildReference.parent) && Objects.equals(this.role, relationToChildReference.role) && Objects.equals(this.child, relationToChildReference.child);
    }

    public int hashCode() {
        return Objects.hash(this.parent, this.position, this.role, this.child);
    }
}

