/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.progress.PleaseWaitProgressMonitor;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.JosmTextArea;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class PleaseWaitDialog
extends JDialog
implements PleaseWaitProgressMonitor.ProgressMonitorDialog {
    private final JProgressBar progressBar = new JProgressBar();
    private final JLabel currentAction = new JLabel("");
    private final JLabel customText = new JLabel("");
    private JButton btnCancel;
    private JButton btnInBackground;
    private final JosmTextArea taLog = new JosmTextArea(5, 50);
    private final JScrollPane spLog = new JScrollPane(this.taLog);

    public PleaseWaitDialog(Component component) {
        super((Window)GuiHelper.getFrameForComponent(component), Dialog.ModalityType.DOCUMENT_MODAL);
        this.initDialog();
    }

    private void initDialog() {
        this.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel.add((Component)this.currentAction, GBC.eol().fill(2));
        jPanel.add((Component)this.customText, GBC.eol().fill(2));
        jPanel.add((Component)this.progressBar, GBC.eop().fill(2));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        this.btnCancel = new JButton(I18n.tr("Cancel", new Object[0]));
        this.btnCancel.setIcon(ImageProvider.get("cancel"));
        this.btnCancel.setToolTipText(I18n.tr("Click to cancel the current operation", new Object[0]));
        jPanel2.add(this.btnCancel);
        this.btnInBackground = new JButton(I18n.tr("In background", new Object[0]));
        this.btnInBackground.setToolTipText(I18n.tr("Click to run job in background", new Object[0]));
        jPanel2.add((Component)this.btnInBackground, GBC.std().fill(3).insets(5, 0, 0, 0));
        jPanel.add((Component)jPanel2, GBC.eol().anchor(10));
        GBC gBC = GBC.eol().fill(1);
        gBC.weighty = 1.0;
        gBC.weightx = 1.0;
        jPanel.add((Component)this.spLog, gBC);
        this.spLog.setVisible(false);
        this.setContentPane(jPanel);
        this.setCustomText("");
        this.setLocationRelativeTo(this.getParent());
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                int n = PleaseWaitDialog.this.getWidth();
                if (n > 200) {
                    Main.pref.putInteger("progressdialog.size", n);
                }
            }
        });
    }

    @Override
    public void setIndeterminate(boolean bl) {
        UIManager.put("ProgressBar.cycleTime", UIManager.getInt("ProgressBar.repaintInterval") * 100);
        this.progressBar.setIndeterminate(bl);
    }

    protected void adjustLayout() {
        this.invalidate();
        this.setDropTarget(null);
        this.pack();
        this.setSize(Main.pref.getInteger("progressdialog.size", 600), this.getSize().height);
    }

    @Override
    public void setCustomText(String string) {
        if (string == null || string.trim().isEmpty()) {
            this.customText.setVisible(false);
            this.adjustLayout();
            return;
        }
        this.customText.setText(string);
        if (!this.customText.isVisible()) {
            this.customText.setVisible(true);
            this.adjustLayout();
        }
    }

    @Override
    public void setCurrentAction(String string) {
        this.currentAction.setText(string);
    }

    @Override
    public void appendLogMessage(String string) {
        if (string == null || string.trim().isEmpty()) {
            return;
        }
        if (!this.spLog.isVisible()) {
            this.spLog.setVisible(true);
            this.taLog.setVisible(true);
            this.adjustLayout();
        }
        this.taLog.append(string);
        this.taLog.append("\n");
        this.spLog.getVerticalScrollBar().setValue(this.spLog.getVerticalScrollBar().getMaximum());
    }

    public void setCancelEnabled(boolean bl) {
        this.btnCancel.setEnabled(bl);
    }

    public void setInBackgroundPossible(boolean bl) {
        this.btnInBackground.setVisible(bl);
    }

    public void setCancelCallback(ActionListener actionListener) {
        if (actionListener == null) {
            ActionListener[] actionListenerArray;
            for (ActionListener actionListener2 : actionListenerArray = this.btnCancel.getActionListeners()) {
                this.btnCancel.removeActionListener(actionListener2);
            }
        } else {
            this.btnCancel.addActionListener(actionListener);
        }
    }

    public void setInBackgroundCallback(ActionListener actionListener) {
        if (actionListener == null) {
            ActionListener[] actionListenerArray;
            for (ActionListener actionListener2 : actionListenerArray = this.btnInBackground.getActionListeners()) {
                this.btnInBackground.removeActionListener(actionListener2);
            }
        } else {
            this.btnInBackground.addActionListener(actionListener);
        }
    }

    @Override
    public void updateProgress(int n) {
        this.progressBar.setValue(n);
        this.progressBar.repaint();
    }

    public void setMaximumProgress(int n) {
        this.progressBar.setMaximum(n);
    }
}

