/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.changes;

import java.util.Collection;
import javax.annotation.Nullable;
import org.gradle.StartParameter;
import org.gradle.api.internal.TaskExecutionHistory;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.changedetection.TaskArtifactState;
import org.gradle.api.internal.changedetection.TaskArtifactStateRepository;
import org.gradle.api.internal.changedetection.changes.NoHistoryArtifactState;
import org.gradle.api.internal.changedetection.changes.RebuildIncrementalTaskInputs;
import org.gradle.api.tasks.incremental.IncrementalTaskInputs;
import org.gradle.caching.internal.tasks.TaskOutputCachingBuildCacheKey;
import org.gradle.internal.id.UniqueId;
import org.gradle.internal.reflect.Instantiator;

public class ShortCircuitTaskArtifactStateRepository
implements TaskArtifactStateRepository {
    private final StartParameter startParameter;
    private final TaskArtifactStateRepository repository;
    private final Instantiator instantiator;

    public ShortCircuitTaskArtifactStateRepository(StartParameter startParameter, Instantiator instantiator, TaskArtifactStateRepository repository) {
        this.startParameter = startParameter;
        this.instantiator = instantiator;
        this.repository = repository;
    }

    public TaskArtifactState getStateFor(TaskInternal task) {
        if (!task.getOutputs().getHasOutput()) {
            return new NoHistoryArtifactState();
        }
        TaskArtifactState state = this.repository.getStateFor(task);
        if (this.startParameter.isRerunTasks()) {
            return new RerunTaskArtifactState(state, task, "Executed with '--rerun-tasks'.");
        }
        if (!task.getOutputs().getUpToDateSpec().isSatisfiedBy((Object)task)) {
            return new RerunTaskArtifactState(state, task, "Task.upToDateWhen is false.");
        }
        return state;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RerunTaskArtifactState
    implements TaskArtifactState {
        private final TaskArtifactState delegate;
        private final TaskInternal task;
        private final String reason;

        private RerunTaskArtifactState(TaskArtifactState delegate, TaskInternal task, String reason) {
            this.delegate = delegate;
            this.task = task;
            this.reason = reason;
        }

        @Override
        public boolean isUpToDate(Collection<String> messages) {
            messages.add(this.reason);
            return false;
        }

        @Override
        public IncrementalTaskInputs getInputChanges() {
            return (IncrementalTaskInputs)ShortCircuitTaskArtifactStateRepository.this.instantiator.newInstance(RebuildIncrementalTaskInputs.class, new Object[]{this.task});
        }

        @Override
        public boolean isAllowedToUseCachedResults() {
            return false;
        }

        @Override
        public TaskOutputCachingBuildCacheKey calculateCacheKey() {
            return this.delegate.calculateCacheKey();
        }

        @Override
        public TaskExecutionHistory getExecutionHistory() {
            return this.delegate.getExecutionHistory();
        }

        @Override
        @Nullable
        public UniqueId getOriginBuildInvocationId() {
            return null;
        }

        @Override
        public void ensureSnapshotBeforeTask() {
            this.delegate.ensureSnapshotBeforeTask();
        }

        @Override
        public void afterOutputsRemovedBeforeTask() {
            this.delegate.afterOutputsRemovedBeforeTask();
        }

        @Override
        public void afterTask(Throwable failure) {
            this.delegate.afterTask(failure);
        }
    }
}

