/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.rules;

import java.io.File;
import java.util.Set;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.changedetection.rules.CachingTaskStateChanges;
import org.gradle.api.internal.changedetection.rules.DiscoveredInputsListener;
import org.gradle.api.internal.changedetection.rules.DiscoveredInputsTaskStateChanges;
import org.gradle.api.internal.changedetection.rules.ErrorHandlingTaskStateChanges;
import org.gradle.api.internal.changedetection.rules.InputFilesTaskStateChanges;
import org.gradle.api.internal.changedetection.rules.InputPropertiesTaskStateChanges;
import org.gradle.api.internal.changedetection.rules.NoHistoryTaskStateChanges;
import org.gradle.api.internal.changedetection.rules.OutputFilesTaskStateChanges;
import org.gradle.api.internal.changedetection.rules.PreviousSuccessTaskStateChanges;
import org.gradle.api.internal.changedetection.rules.SummaryTaskStateChanges;
import org.gradle.api.internal.changedetection.rules.TaskStateChanges;
import org.gradle.api.internal.changedetection.rules.TaskTypeTaskStateChanges;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshotterRegistry;
import org.gradle.api.internal.changedetection.state.TaskExecution;
import org.gradle.api.internal.changedetection.state.TaskHistoryRepository;
import org.gradle.api.internal.changedetection.state.ValueSnapshotter;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.internal.classloader.ClassLoaderHierarchyHasher;
import org.gradle.normalization.internal.InputNormalizationHandlerInternal;
import org.gradle.normalization.internal.InputNormalizationStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskUpToDateState {
    public static final int MAX_OUT_OF_DATE_MESSAGES = 3;
    private final TaskStateChanges inputFileChanges;
    private final OutputFilesTaskStateChanges outputFileChanges;
    private final DiscoveredInputsListener discoveredInputsListener;
    private final TaskStateChanges allTaskChanges;
    private final TaskStateChanges rebuildChanges;

    public TaskUpToDateState(TaskInternal task, TaskHistoryRepository.History history, FileCollectionSnapshotterRegistry fileCollectionSnapshotterRegistry, FileCollectionFactory fileCollectionFactory, ClassLoaderHierarchyHasher classLoaderHierarchyHasher, ValueSnapshotter valueSnapshotter) {
        TaskExecution thisExecution = history.getCurrentExecution();
        TaskExecution lastExecution = history.getPreviousExecution();
        InputNormalizationStrategy inputNormalizationStrategy = ((InputNormalizationHandlerInternal)task.getProject().getNormalization()).buildFinalStrategy();
        NoHistoryTaskStateChanges noHistoryState = new NoHistoryTaskStateChanges(lastExecution);
        PreviousSuccessTaskStateChanges previousSuccessState = new PreviousSuccessTaskStateChanges(lastExecution, thisExecution, task);
        TaskTypeTaskStateChanges taskTypeState = new TaskTypeTaskStateChanges(lastExecution, thisExecution, task.getPath(), task.getClass(), task.getTaskActions(), classLoaderHierarchyHasher);
        InputPropertiesTaskStateChanges inputPropertiesState = new InputPropertiesTaskStateChanges(lastExecution, thisExecution, task, valueSnapshotter);
        OutputFilesTaskStateChanges uncachedOutputChanges = new OutputFilesTaskStateChanges(lastExecution, thisExecution, task, fileCollectionSnapshotterRegistry, inputNormalizationStrategy);
        TaskStateChanges outputFileChanges = TaskUpToDateState.caching(uncachedOutputChanges);
        this.outputFileChanges = uncachedOutputChanges;
        InputFilesTaskStateChanges directInputFileChanges = new InputFilesTaskStateChanges(lastExecution, thisExecution, task, fileCollectionSnapshotterRegistry, inputNormalizationStrategy);
        TaskStateChanges inputFileChanges = TaskUpToDateState.caching(directInputFileChanges);
        this.inputFileChanges = new ErrorHandlingTaskStateChanges(task, inputFileChanges);
        DiscoveredInputsTaskStateChanges discoveredChanges = new DiscoveredInputsTaskStateChanges(lastExecution, thisExecution, fileCollectionSnapshotterRegistry, fileCollectionFactory, task, inputNormalizationStrategy);
        this.discoveredInputsListener = discoveredChanges;
        TaskStateChanges discoveredInputFilesChanges = TaskUpToDateState.caching(discoveredChanges);
        this.allTaskChanges = new ErrorHandlingTaskStateChanges(task, new SummaryTaskStateChanges(3, previousSuccessState, noHistoryState, taskTypeState, inputPropertiesState, outputFileChanges, inputFileChanges, discoveredInputFilesChanges));
        this.rebuildChanges = new ErrorHandlingTaskStateChanges(task, new SummaryTaskStateChanges(1, previousSuccessState, noHistoryState, taskTypeState, inputPropertiesState, outputFileChanges));
    }

    private static TaskStateChanges caching(TaskStateChanges wrapped) {
        return new CachingTaskStateChanges(3, wrapped);
    }

    public TaskStateChanges getInputFilesChanges() {
        return this.inputFileChanges;
    }

    public boolean hasAnyOutputFileChanges() {
        return this.outputFileChanges.iteratorIncludingAdded().hasNext();
    }

    public TaskStateChanges getAllTaskChanges() {
        return this.allTaskChanges;
    }

    public TaskStateChanges getRebuildChanges() {
        return this.rebuildChanges;
    }

    public void newInputs(Set<File> discoveredInputs) {
        this.discoveredInputsListener.newInputs(discoveredInputs);
    }
}

