/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.hash.HashCode;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshot;
import org.gradle.api.internal.changedetection.state.FileSnapshotRepository;
import org.gradle.api.internal.changedetection.state.ImplementationSnapshot;
import org.gradle.api.internal.changedetection.state.InputPropertiesSerializer;
import org.gradle.api.internal.changedetection.state.TaskExecution;
import org.gradle.api.internal.changedetection.state.TaskExecutionSnapshot;
import org.gradle.api.internal.changedetection.state.TaskHistoryRepository;
import org.gradle.api.internal.changedetection.state.TaskHistoryStore;
import org.gradle.api.internal.changedetection.state.ValueSnapshot;
import org.gradle.api.internal.tasks.CacheableTaskOutputFilePropertySpec;
import org.gradle.api.internal.tasks.TaskOutputFilePropertySpec;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.internal.id.UniqueId;
import org.gradle.internal.scopeids.id.BuildInvocationScopeId;
import org.gradle.internal.serialize.AbstractSerializer;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheBackedTaskHistoryRepository
implements TaskHistoryRepository {
    private final FileSnapshotRepository snapshotRepository;
    private final PersistentIndexedCache<String, TaskExecutionSnapshot> taskHistoryCache;
    private final StringInterner stringInterner;
    private final BuildInvocationScopeId buildInvocationScopeId;

    public CacheBackedTaskHistoryRepository(TaskHistoryStore cacheAccess, FileSnapshotRepository snapshotRepository, StringInterner stringInterner, BuildInvocationScopeId buildInvocationScopeId) {
        this.snapshotRepository = snapshotRepository;
        this.stringInterner = stringInterner;
        this.buildInvocationScopeId = buildInvocationScopeId;
        LazyTaskExecution.TaskExecutionSnapshotSerializer serializer = new LazyTaskExecution.TaskExecutionSnapshotSerializer(stringInterner);
        this.taskHistoryCache = cacheAccess.createCache("taskHistory", String.class, serializer, 10000, false);
    }

    @Override
    public TaskHistoryRepository.History getHistory(final TaskInternal task) {
        final LazyTaskExecution previousExecution = this.loadPreviousExecution(task);
        final LazyTaskExecution currentExecution = new LazyTaskExecution(this.buildInvocationScopeId.getId(), this.snapshotRepository);
        currentExecution.setOutputPropertyNamesForCacheKey(this.getOutputPropertyNamesForCacheKey(task));
        currentExecution.setDeclaredOutputFilePaths(this.getDeclaredOutputFilePaths(task));
        return new TaskHistoryRepository.History(){

            public TaskExecution getPreviousExecution() {
                return previousExecution;
            }

            public TaskExecution getCurrentExecution() {
                return currentExecution;
            }

            public void update() {
                this.storeSnapshots(currentExecution);
                if (previousExecution != null) {
                    this.removeUnnecessarySnapshots(previousExecution);
                }
                CacheBackedTaskHistoryRepository.this.taskHistoryCache.put(task.getPath(), currentExecution.snapshot());
            }

            private void storeSnapshots(LazyTaskExecution execution) {
                ImmutableSortedMap.Builder builder;
                if (execution.inputFilesSnapshotIds == null && execution.inputFilesSnapshot != null) {
                    builder = ImmutableSortedMap.naturalOrder();
                    for (Map.Entry entry : execution.inputFilesSnapshot.entrySet()) {
                        builder.put(entry.getKey(), (Object)CacheBackedTaskHistoryRepository.this.snapshotRepository.add((FileCollectionSnapshot)entry.getValue()));
                    }
                    execution.inputFilesSnapshotIds = builder.build();
                }
                if (execution.outputFilesSnapshotIds == null && execution.outputFilesSnapshot != null) {
                    builder = ImmutableSortedMap.naturalOrder();
                    for (Map.Entry entry : execution.outputFilesSnapshot.entrySet()) {
                        builder.put(entry.getKey(), (Object)CacheBackedTaskHistoryRepository.this.snapshotRepository.add((FileCollectionSnapshot)entry.getValue()));
                    }
                    execution.outputFilesSnapshotIds = builder.build();
                }
                if (execution.discoveredFilesSnapshotId == null && execution.discoveredFilesSnapshot != null) {
                    execution.discoveredFilesSnapshotId = CacheBackedTaskHistoryRepository.this.snapshotRepository.add(execution.discoveredFilesSnapshot);
                }
            }

            private void removeUnnecessarySnapshots(LazyTaskExecution execution) {
                if (execution.inputFilesSnapshotIds != null) {
                    for (Long id : execution.inputFilesSnapshotIds.values()) {
                        CacheBackedTaskHistoryRepository.this.snapshotRepository.remove(id);
                    }
                }
                if (execution.outputFilesSnapshotIds != null) {
                    for (Long id : execution.outputFilesSnapshotIds.values()) {
                        CacheBackedTaskHistoryRepository.this.snapshotRepository.remove(id);
                    }
                }
                if (execution.discoveredFilesSnapshotId != null) {
                    CacheBackedTaskHistoryRepository.this.snapshotRepository.remove(execution.discoveredFilesSnapshotId);
                }
            }
        };
    }

    private LazyTaskExecution loadPreviousExecution(TaskInternal task) {
        TaskExecutionSnapshot taskExecutionSnapshot = this.taskHistoryCache.get(task.getPath());
        if (taskExecutionSnapshot != null) {
            return new LazyTaskExecution(taskExecutionSnapshot, this.snapshotRepository);
        }
        return null;
    }

    private Iterable<String> getOutputPropertyNamesForCacheKey(TaskInternal task) {
        Iterable outputPropertiesForCacheKey = Iterables.filter(task.getOutputs().getFileProperties(), (Predicate)new Predicate<TaskOutputFilePropertySpec>(){

            public boolean apply(TaskOutputFilePropertySpec propertySpec) {
                if (propertySpec instanceof CacheableTaskOutputFilePropertySpec) {
                    CacheableTaskOutputFilePropertySpec cacheablePropertySpec = (CacheableTaskOutputFilePropertySpec)propertySpec;
                    return cacheablePropertySpec.getOutputFile() != null;
                }
                return false;
            }
        });
        return Iterables.transform((Iterable)outputPropertiesForCacheKey, (Function)new Function<TaskOutputFilePropertySpec, String>(){

            public String apply(TaskOutputFilePropertySpec propertySpec) {
                return propertySpec.getPropertyName();
            }
        });
    }

    private ImmutableSet<String> getDeclaredOutputFilePaths(TaskInternal task) {
        ImmutableSortedSet.Builder declaredOutputFilePaths = ImmutableSortedSet.naturalOrder();
        for (File file : task.getOutputs().getFiles()) {
            declaredOutputFilePaths.add((Object)this.stringInterner.intern(file.getAbsolutePath()));
        }
        return declaredOutputFilePaths.build();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LazyTaskExecution
    extends TaskExecution {
        private ImmutableSortedMap<String, Long> inputFilesSnapshotIds;
        private ImmutableSortedMap<String, Long> outputFilesSnapshotIds;
        private Long discoveredFilesSnapshotId;
        private final FileSnapshotRepository snapshotRepository;
        private ImmutableSortedMap<String, FileCollectionSnapshot> inputFilesSnapshot;
        private ImmutableSortedMap<String, FileCollectionSnapshot> outputFilesSnapshot;
        private FileCollectionSnapshot discoveredFilesSnapshot;

        LazyTaskExecution(TaskExecutionSnapshot taskExecutionSnapshot, FileSnapshotRepository snapshotRepository) {
            this(snapshotRepository);
            this.setSuccessful(taskExecutionSnapshot.isSuccessful());
            this.setBuildInvocationId(taskExecutionSnapshot.getBuildInvocationId());
            this.setTaskImplementation(taskExecutionSnapshot.getTaskImplementation());
            this.setTaskActionImplementations(taskExecutionSnapshot.getTaskActionsImplementations());
            this.setInputProperties(taskExecutionSnapshot.getInputProperties());
            this.setOutputPropertyNamesForCacheKey((Iterable<String>)taskExecutionSnapshot.getCacheableOutputProperties());
            this.setDeclaredOutputFilePaths(taskExecutionSnapshot.getDeclaredOutputFilePaths());
            this.inputFilesSnapshotIds = taskExecutionSnapshot.getInputFilesSnapshotIds();
            this.outputFilesSnapshotIds = taskExecutionSnapshot.getOutputFilesSnapshotIds();
            this.discoveredFilesSnapshotId = taskExecutionSnapshot.getDiscoveredFilesSnapshotId();
        }

        LazyTaskExecution(UniqueId buildInvocationId, FileSnapshotRepository snapshotRepository) {
            this(snapshotRepository);
            this.setBuildInvocationId(buildInvocationId);
        }

        private LazyTaskExecution(FileSnapshotRepository snapshotRepository) {
            this.snapshotRepository = snapshotRepository;
        }

        @Override
        public ImmutableSortedMap<String, FileCollectionSnapshot> getInputFilesSnapshot() {
            if (this.inputFilesSnapshot == null) {
                ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
                for (Map.Entry entry : this.inputFilesSnapshotIds.entrySet()) {
                    builder.put(entry.getKey(), (Object)this.snapshotRepository.get((Long)entry.getValue()));
                }
                this.inputFilesSnapshot = builder.build();
            }
            return this.inputFilesSnapshot;
        }

        @Override
        public void setInputFilesSnapshot(ImmutableSortedMap<String, FileCollectionSnapshot> inputFilesSnapshot) {
            this.inputFilesSnapshot = inputFilesSnapshot;
            this.inputFilesSnapshotIds = null;
        }

        @Override
        public FileCollectionSnapshot getDiscoveredInputFilesSnapshot() {
            if (this.discoveredFilesSnapshot == null) {
                this.discoveredFilesSnapshot = this.snapshotRepository.get(this.discoveredFilesSnapshotId);
            }
            return this.discoveredFilesSnapshot;
        }

        @Override
        public void setDiscoveredInputFilesSnapshot(FileCollectionSnapshot discoveredFilesSnapshot) {
            this.discoveredFilesSnapshot = discoveredFilesSnapshot;
            this.discoveredFilesSnapshotId = null;
        }

        @Override
        public ImmutableSortedMap<String, FileCollectionSnapshot> getOutputFilesSnapshot() {
            if (this.outputFilesSnapshot == null) {
                ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
                for (Map.Entry entry : this.outputFilesSnapshotIds.entrySet()) {
                    String propertyName = (String)entry.getKey();
                    builder.put((Object)propertyName, (Object)this.snapshotRepository.get((Long)entry.getValue()));
                }
                this.outputFilesSnapshot = builder.build();
            }
            return this.outputFilesSnapshot;
        }

        @Override
        public void setOutputFilesSnapshot(ImmutableSortedMap<String, FileCollectionSnapshot> outputFilesSnapshot) {
            this.outputFilesSnapshot = outputFilesSnapshot;
            this.outputFilesSnapshotIds = null;
        }

        public TaskExecutionSnapshot snapshot() {
            return new TaskExecutionSnapshot(this.isSuccessful(), this.getBuildInvocationId(), this.getTaskImplementation(), this.getTaskActionImplementations(), this.getOutputPropertyNamesForCacheKey(), this.getDeclaredOutputFilePaths(), this.getInputProperties(), this.inputFilesSnapshotIds, this.discoveredFilesSnapshotId, this.outputFilesSnapshotIds);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class TaskExecutionSnapshotSerializer
        extends AbstractSerializer<TaskExecutionSnapshot> {
            private final InputPropertiesSerializer inputPropertiesSerializer = new InputPropertiesSerializer();
            private final StringInterner stringInterner;

            TaskExecutionSnapshotSerializer(StringInterner stringInterner) {
                this.stringInterner = stringInterner;
            }

            public TaskExecutionSnapshot read(Decoder decoder) throws Exception {
                boolean successful = decoder.readBoolean();
                UniqueId buildId = UniqueId.from((String)decoder.readString());
                ImmutableSortedMap<String, Long> inputFilesSnapshotIds = TaskExecutionSnapshotSerializer.readSnapshotIds(decoder);
                ImmutableSortedMap<String, Long> outputFilesSnapshotIds = TaskExecutionSnapshotSerializer.readSnapshotIds(decoder);
                Long discoveredFilesSnapshotId = decoder.readLong();
                ImplementationSnapshot taskImplementation = TaskExecutionSnapshotSerializer.readImplementation(decoder);
                int taskActionsCount = decoder.readSmallInt();
                ImmutableList.Builder taskActionImplementationsBuilder = ImmutableList.builder();
                for (int j = 0; j < taskActionsCount; ++j) {
                    ImplementationSnapshot actionImpl = TaskExecutionSnapshotSerializer.readImplementation(decoder);
                    taskActionImplementationsBuilder.add((Object)actionImpl);
                }
                ImmutableList taskActionImplementations = taskActionImplementationsBuilder.build();
                int cacheableOutputPropertiesCount = decoder.readSmallInt();
                ImmutableSortedSet.Builder cacheableOutputPropertiesBuilder = ImmutableSortedSet.naturalOrder();
                for (int j = 0; j < cacheableOutputPropertiesCount; ++j) {
                    cacheableOutputPropertiesBuilder.add((Object)decoder.readString());
                }
                ImmutableSortedSet cacheableOutputProperties = cacheableOutputPropertiesBuilder.build();
                int outputFilesCount = decoder.readSmallInt();
                ImmutableSet.Builder declaredOutputFilePathsBuilder = ImmutableSet.builder();
                for (int j = 0; j < outputFilesCount; ++j) {
                    declaredOutputFilePathsBuilder.add((Object)this.stringInterner.intern(decoder.readString()));
                }
                ImmutableSet declaredOutputFilePaths = declaredOutputFilePathsBuilder.build();
                ImmutableSortedMap<String, ValueSnapshot> inputProperties = this.inputPropertiesSerializer.read(decoder);
                return new TaskExecutionSnapshot(successful, buildId, taskImplementation, (ImmutableList<ImplementationSnapshot>)taskActionImplementations, (ImmutableSortedSet<String>)cacheableOutputProperties, (ImmutableSet<String>)declaredOutputFilePaths, inputProperties, inputFilesSnapshotIds, discoveredFilesSnapshotId, outputFilesSnapshotIds);
            }

            public void write(Encoder encoder, TaskExecutionSnapshot execution) throws Exception {
                encoder.writeBoolean(execution.isSuccessful());
                encoder.writeString((CharSequence)execution.getBuildInvocationId().asString());
                TaskExecutionSnapshotSerializer.writeSnapshotIds(encoder, execution.getInputFilesSnapshotIds());
                TaskExecutionSnapshotSerializer.writeSnapshotIds(encoder, execution.getOutputFilesSnapshotIds());
                encoder.writeLong(execution.getDiscoveredFilesSnapshotId().longValue());
                TaskExecutionSnapshotSerializer.writeImplementation(encoder, execution.getTaskImplementation());
                encoder.writeSmallInt(execution.getTaskActionsImplementations().size());
                for (ImplementationSnapshot actionImpl : execution.getTaskActionsImplementations()) {
                    TaskExecutionSnapshotSerializer.writeImplementation(encoder, actionImpl);
                }
                encoder.writeSmallInt(execution.getCacheableOutputProperties().size());
                for (String outputFile : execution.getCacheableOutputProperties()) {
                    encoder.writeString((CharSequence)outputFile);
                }
                encoder.writeSmallInt(execution.getDeclaredOutputFilePaths().size());
                for (String outputFile : execution.getDeclaredOutputFilePaths()) {
                    encoder.writeString((CharSequence)outputFile);
                }
                this.inputPropertiesSerializer.write(encoder, (ImmutableMap<String, ValueSnapshot>)execution.getInputProperties());
            }

            private static ImplementationSnapshot readImplementation(Decoder decoder) throws IOException {
                String typeName = decoder.readString();
                HashCode classLoaderHash = decoder.readBoolean() ? HashCode.fromBytes((byte[])decoder.readBinary()) : null;
                return new ImplementationSnapshot(typeName, classLoaderHash);
            }

            private static void writeImplementation(Encoder encoder, ImplementationSnapshot implementation) throws IOException {
                encoder.writeString((CharSequence)implementation.getTypeName());
                if (implementation.hasUnknownClassLoader()) {
                    encoder.writeBoolean(false);
                } else {
                    encoder.writeBoolean(true);
                    encoder.writeBinary(implementation.getClassLoaderHash().asBytes());
                }
            }

            private static ImmutableSortedMap<String, Long> readSnapshotIds(Decoder decoder) throws IOException {
                int count = decoder.readSmallInt();
                ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
                for (int snapshotIdx = 0; snapshotIdx < count; ++snapshotIdx) {
                    String property = decoder.readString();
                    long id = decoder.readLong();
                    builder.put((Object)property, (Object)id);
                }
                return builder.build();
            }

            private static void writeSnapshotIds(Encoder encoder, Map<String, Long> ids) throws IOException {
                encoder.writeSmallInt(ids.size());
                for (Map.Entry<String, Long> entry : ids.entrySet()) {
                    encoder.writeString((CharSequence)entry.getKey());
                    encoder.writeLong(entry.getValue().longValue());
                }
            }
        }
    }
}

