/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.hash.HashCode;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.internal.changedetection.state.DefaultGenericFileCollectionSnapshotter;
import org.gradle.api.internal.changedetection.state.DirectoryFileSnapshot;
import org.gradle.api.internal.changedetection.state.DirectoryTreeDetails;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshot;
import org.gradle.api.internal.changedetection.state.FileHashSnapshot;
import org.gradle.api.internal.changedetection.state.FileSnapshot;
import org.gradle.api.internal.changedetection.state.FileSystemMirror;
import org.gradle.api.internal.changedetection.state.FileSystemSnapshotter;
import org.gradle.api.internal.changedetection.state.FileTreeSnapshot;
import org.gradle.api.internal.changedetection.state.MissingFileSnapshot;
import org.gradle.api.internal.changedetection.state.RegularFileSnapshot;
import org.gradle.api.internal.changedetection.state.Snapshot;
import org.gradle.api.internal.changedetection.state.TaskFilePropertySnapshotNormalizationStrategy;
import org.gradle.api.internal.file.FileTreeInternal;
import org.gradle.api.internal.file.collections.DirectoryFileTree;
import org.gradle.api.internal.file.collections.DirectoryFileTreeFactory;
import org.gradle.api.internal.file.collections.SimpleFileCollection;
import org.gradle.api.internal.hash.FileHasher;
import org.gradle.cache.internal.ProducerGuard;
import org.gradle.caching.internal.BuildCacheHasher;
import org.gradle.caching.internal.DefaultBuildCacheHasher;
import org.gradle.internal.Factory;
import org.gradle.internal.nativeintegration.filesystem.FileMetadataSnapshot;
import org.gradle.internal.nativeintegration.filesystem.FileSystem;
import org.gradle.normalization.internal.InputNormalizationStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultFileSystemSnapshotter
implements FileSystemSnapshotter {
    private final FileHasher hasher;
    private final StringInterner stringInterner;
    private final FileSystem fileSystem;
    private final DirectoryFileTreeFactory directoryFileTreeFactory;
    private final FileSystemMirror fileSystemMirror;
    private final ProducerGuard<String> producingSelfSnapshots = ProducerGuard.striped();
    private final ProducerGuard<String> producingTrees = ProducerGuard.striped();
    private final ProducerGuard<String> producingAllSnapshots = ProducerGuard.striped();
    private final DefaultGenericFileCollectionSnapshotter snapshotter;

    public DefaultFileSystemSnapshotter(FileHasher hasher, StringInterner stringInterner, FileSystem fileSystem, DirectoryFileTreeFactory directoryFileTreeFactory, FileSystemMirror fileSystemMirror) {
        this.hasher = hasher;
        this.stringInterner = stringInterner;
        this.fileSystem = fileSystem;
        this.directoryFileTreeFactory = directoryFileTreeFactory;
        this.fileSystemMirror = fileSystemMirror;
        this.snapshotter = new DefaultGenericFileCollectionSnapshotter(stringInterner, directoryFileTreeFactory, this);
    }

    @Override
    public FileSnapshot snapshotSelf(final File file) {
        final String path = file.getAbsolutePath();
        return this.producingSelfSnapshots.guardByKey(path, new Factory<FileSnapshot>(){

            public FileSnapshot create() {
                FileSnapshot snapshot = DefaultFileSystemSnapshotter.this.fileSystemMirror.getFile(path);
                if (snapshot == null) {
                    snapshot = DefaultFileSystemSnapshotter.this.calculateDetails(file);
                    DefaultFileSystemSnapshotter.this.fileSystemMirror.putFile(snapshot);
                }
                return snapshot;
            }
        });
    }

    @Override
    public Snapshot snapshotAll(final File file) {
        final String path = file.getAbsolutePath();
        return this.producingAllSnapshots.guardByKey(path, new Factory<Snapshot>(){

            public Snapshot create() {
                Snapshot snapshot = DefaultFileSystemSnapshotter.this.fileSystemMirror.getContent(path);
                if (snapshot == null) {
                    FileCollectionSnapshot fileCollectionSnapshot = DefaultFileSystemSnapshotter.this.snapshotter.snapshot(new SimpleFileCollection(file), TaskFilePropertySnapshotNormalizationStrategy.ABSOLUTE, InputNormalizationStrategy.NOT_CONFIGURED);
                    DefaultBuildCacheHasher hasher = new DefaultBuildCacheHasher();
                    fileCollectionSnapshot.appendToHasher(hasher);
                    HashCode hashCode = hasher.hash();
                    snapshot = new HashBackedSnapshot(hashCode);
                    String internedPath = DefaultFileSystemSnapshotter.this.getPath(file);
                    DefaultFileSystemSnapshotter.this.fileSystemMirror.putContent(internedPath, snapshot);
                }
                return snapshot;
            }
        });
    }

    @Override
    public FileTreeSnapshot snapshotDirectoryTree(final File dir) {
        final String path = dir.getAbsolutePath();
        return this.producingTrees.guardByKey(path, new Factory<FileTreeSnapshot>(){

            public FileTreeSnapshot create() {
                FileTreeSnapshot snapshot = DefaultFileSystemSnapshotter.this.fileSystemMirror.getDirectoryTree(path);
                if (snapshot == null) {
                    snapshot = DefaultFileSystemSnapshotter.this.doSnapshot(DefaultFileSystemSnapshotter.this.directoryFileTreeFactory.create(dir));
                    DefaultFileSystemSnapshotter.this.fileSystemMirror.putDirectory(snapshot);
                }
                return snapshot;
            }
        });
    }

    @Override
    public FileTreeSnapshot snapshotDirectoryTree(final DirectoryFileTree dirTree) {
        if (!dirTree.getPatterns().isEmpty()) {
            ArrayList elements = Lists.newArrayList();
            dirTree.visit(new FileVisitorImpl(elements));
            return new DirectoryTreeDetails(dirTree.getDir().getAbsolutePath(), elements);
        }
        final String path = dirTree.getDir().getAbsolutePath();
        return this.producingTrees.guardByKey(path, new Factory<FileTreeSnapshot>(){

            public FileTreeSnapshot create() {
                FileTreeSnapshot snapshot = DefaultFileSystemSnapshotter.this.fileSystemMirror.getDirectoryTree(path);
                if (snapshot == null) {
                    snapshot = DefaultFileSystemSnapshotter.this.doSnapshot(dirTree);
                    DefaultFileSystemSnapshotter.this.fileSystemMirror.putDirectory(snapshot);
                }
                return snapshot;
            }
        });
    }

    @Override
    public List<FileSnapshot> snapshotTree(FileTreeInternal tree) {
        ArrayList elements = Lists.newArrayList();
        tree.visitTreeOrBackingFile(new FileVisitorImpl(elements));
        return elements;
    }

    private FileTreeSnapshot doSnapshot(DirectoryFileTree directoryTree) {
        String path = this.getPath(directoryTree.getDir());
        ArrayList elements = Lists.newArrayList();
        directoryTree.visit(new FileVisitorImpl(elements));
        return new DirectoryTreeDetails(path, (List<FileSnapshot>)ImmutableList.copyOf((Collection)elements));
    }

    private String getPath(File file) {
        return this.stringInterner.intern(file.getAbsolutePath());
    }

    private FileSnapshot calculateDetails(File file) {
        String path = this.getPath(file);
        FileMetadataSnapshot stat = this.fileSystem.stat(file);
        switch (stat.getType()) {
            case Missing: {
                return new MissingFileSnapshot(path, new RelativePath(true, file.getName()));
            }
            case Directory: {
                return new DirectoryFileSnapshot(path, new RelativePath(false, file.getName()), true);
            }
            case RegularFile: {
                return new RegularFileSnapshot(path, new RelativePath(true, file.getName()), true, this.fileSnapshot(file, stat));
            }
        }
        throw new IllegalArgumentException("Unrecognized file type: " + stat.getType());
    }

    private FileHashSnapshot fileSnapshot(FileTreeElement fileDetails) {
        return new FileHashSnapshot(this.hasher.hash(fileDetails), fileDetails.getLastModified());
    }

    private FileHashSnapshot fileSnapshot(File file, FileMetadataSnapshot fileDetails) {
        return new FileHashSnapshot(this.hasher.hash(file, fileDetails), fileDetails.getLastModified());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FileVisitorImpl
    implements FileVisitor {
        private final List<FileSnapshot> fileTreeElements;

        FileVisitorImpl(List<FileSnapshot> fileTreeElements) {
            this.fileTreeElements = fileTreeElements;
        }

        @Override
        public void visitDir(FileVisitDetails dirDetails) {
            this.fileTreeElements.add(new DirectoryFileSnapshot(DefaultFileSystemSnapshotter.this.getPath(dirDetails.getFile()), dirDetails.getRelativePath(), false));
        }

        @Override
        public void visitFile(FileVisitDetails fileDetails) {
            this.fileTreeElements.add(new RegularFileSnapshot(DefaultFileSystemSnapshotter.this.getPath(fileDetails.getFile()), fileDetails.getRelativePath(), false, DefaultFileSystemSnapshotter.this.fileSnapshot(fileDetails)));
        }
    }

    private static class HashBackedSnapshot
    implements Snapshot {
        private final HashCode hashCode;

        HashBackedSnapshot(HashCode hashCode) {
            this.hashCode = hashCode;
        }

        public void appendToHasher(BuildCacheHasher hasher) {
            hasher.putHash(this.hashCode);
        }
    }
}

