/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.execution;

import java.util.ArrayList;
import java.util.List;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.tasks.TaskExecuter;
import org.gradle.api.internal.tasks.TaskExecutionContext;
import org.gradle.api.internal.tasks.TaskStateInternal;
import org.gradle.api.internal.tasks.execution.TaskValidator;
import org.gradle.api.tasks.TaskValidationException;

public class ValidatingTaskExecuter
implements TaskExecuter {
    private final TaskExecuter executer;

    public ValidatingTaskExecuter(TaskExecuter executer) {
        this.executer = executer;
    }

    public void execute(TaskInternal task, TaskStateInternal state, TaskExecutionContext context) {
        List<String> messages = new ArrayList<String>();
        for (TaskValidator validator : task.getValidators()) {
            validator.validate(task, messages);
        }
        if (!messages.isEmpty()) {
            ArrayList<InvalidUserDataException> causes = new ArrayList<InvalidUserDataException>();
            messages = messages.subList(0, Math.min(5, messages.size()));
            for (String message : messages) {
                causes.add(new InvalidUserDataException(message));
            }
            String errorMessage = messages.size() == 1 ? String.format("A problem was found with the configuration of %s.", task) : String.format("Some problems were found with the configuration of %s.", task);
            state.setOutcome((Throwable)((Object)new TaskValidationException(errorMessage, causes)));
            return;
        }
        this.executer.execute(task, state, context);
    }
}

