/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.tasks;

import java.io.File;
import org.gradle.BuildResult;
import org.gradle.api.Action;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.InstantiatorFactory;
import org.gradle.caching.configuration.internal.BuildCacheConfigurationInternal;
import org.gradle.caching.internal.controller.BuildCacheController;
import org.gradle.caching.internal.controller.BuildCacheControllerFactory;
import org.gradle.caching.internal.tasks.GZipTaskOutputPacker;
import org.gradle.caching.internal.tasks.TarTaskOutputPacker;
import org.gradle.caching.internal.tasks.TaskCacheKeyCalculator;
import org.gradle.caching.internal.tasks.TaskOutputCacheCommandFactory;
import org.gradle.caching.internal.tasks.TaskOutputPacker;
import org.gradle.caching.internal.tasks.origin.TaskOutputOriginFactory;
import org.gradle.internal.SystemProperties;
import org.gradle.internal.nativeplatform.filesystem.FileSystem;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.internal.remote.internal.inet.InetAddressFactory;
import org.gradle.internal.scopeids.id.BuildInvocationScopeId;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.time.TimeProvider;
import org.gradle.util.GradleVersion;

public class BuildCacheTaskServices {
    TaskCacheKeyCalculator createTaskCacheKeyCalculator() {
        return new TaskCacheKeyCalculator();
    }

    TaskOutputPacker createTaskResultPacker(FileSystem fileSystem) {
        return new GZipTaskOutputPacker(new TarTaskOutputPacker(fileSystem));
    }

    TaskOutputOriginFactory createTaskOutputOriginFactory(TimeProvider timeProvider, InetAddressFactory inetAddressFactory, GradleInternal gradleInternal, BuildInvocationScopeId buildInvocationScopeId) {
        File rootDir = gradleInternal.getRootProject().getRootDir();
        return new TaskOutputOriginFactory(timeProvider, inetAddressFactory, rootDir, SystemProperties.getInstance().getUserName(), OperatingSystem.current().getName(), GradleVersion.current(), buildInvocationScopeId);
    }

    TaskOutputCacheCommandFactory createTaskOutputCacheCommandFactory(TaskOutputPacker taskOutputPacker, TaskOutputOriginFactory taskOutputOriginFactory) {
        return new TaskOutputCacheCommandFactory(taskOutputPacker, taskOutputOriginFactory);
    }

    BuildCacheController createBuildCacheController(ServiceRegistry serviceRegistry, BuildCacheConfigurationInternal buildCacheConfiguration, BuildOperationExecutor buildOperationExecutor, InstantiatorFactory instantiatorFactory, GradleInternal gradle) {
        final BuildCacheController controller = BuildCacheControllerFactory.create(buildOperationExecutor, gradle, buildCacheConfiguration, instantiatorFactory.inject(serviceRegistry));
        gradle.buildFinished((Action<? super BuildResult>)new Action<BuildResult>(){

            public void execute(BuildResult result) {
                controller.close();
            }
        });
        return controller;
    }
}

