/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.tasks;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.SortedSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarInputStream;
import org.apache.tools.tar.TarOutputStream;
import org.gradle.api.GradleException;
import org.gradle.api.JavaVersion;
import org.gradle.api.Transformer;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.file.collections.DefaultDirectoryWalkerFactory;
import org.gradle.api.internal.tasks.CacheableTaskOutputFilePropertySpec;
import org.gradle.api.internal.tasks.ResolvedTaskOutputFilePropertySpec;
import org.gradle.api.internal.tasks.TaskFilePropertySpec;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.caching.internal.tasks.TaskOutputPacker;
import org.gradle.caching.internal.tasks.origin.TaskOutputOriginMetadata;
import org.gradle.caching.internal.tasks.origin.TaskOutputOriginReader;
import org.gradle.caching.internal.tasks.origin.TaskOutputOriginWriter;
import org.gradle.internal.IoActions;
import org.gradle.internal.nativeplatform.filesystem.FileSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TarTaskOutputPacker
implements TaskOutputPacker {
    private static final String METADATA_PATH = "METADATA";
    private static final Pattern PROPERTY_PATH = Pattern.compile("(missing-)?property-([^/]+)(?:/(.*))?");
    private static final long NANOS_PER_SECOND = TimeUnit.SECONDS.toNanos(1L);
    private final DefaultDirectoryWalkerFactory directoryWalkerFactory;
    private final FileSystem fileSystem;

    public TarTaskOutputPacker(FileSystem fileSystem) {
        this.directoryWalkerFactory = new DefaultDirectoryWalkerFactory(JavaVersion.current(), fileSystem);
        this.fileSystem = fileSystem;
    }

    @Override
    public TaskOutputPacker.PackResult pack(final SortedSet<ResolvedTaskOutputFilePropertySpec> propertySpecs, OutputStream output, final TaskOutputOriginWriter writeOrigin) {
        return (TaskOutputPacker.PackResult)IoActions.withResource((Closeable)new TarOutputStream(output, "utf-8"), (Transformer)new Transformer<TaskOutputPacker.PackResult, TarOutputStream>(){

            public TaskOutputPacker.PackResult transform(TarOutputStream outputStream) {
                outputStream.setLongFileMode(3);
                outputStream.setBigNumberMode(2);
                outputStream.setAddPaxHeadersForNonAsciiNames(true);
                try {
                    TarTaskOutputPacker.this.packMetadata(writeOrigin, outputStream);
                    return new TaskOutputPacker.PackResult(TarTaskOutputPacker.this.pack(propertySpecs, outputStream) + 1L);
                }
                catch (IOException e) {
                    throw new UncheckedIOException((Throwable)e);
                }
            }
        });
    }

    private void packMetadata(TaskOutputOriginWriter writeMetadata, TarOutputStream outputStream) throws IOException {
        TarEntry entry = new TarEntry(METADATA_PATH);
        entry.setMode(33188);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        writeMetadata.execute(baos);
        entry.setSize((long)baos.size());
        outputStream.putNextEntry(entry);
        outputStream.write(baos.toByteArray());
        outputStream.closeEntry();
    }

    private long pack(Collection<ResolvedTaskOutputFilePropertySpec> propertySpecs, TarOutputStream outputStream) {
        long entries = 0L;
        for (ResolvedTaskOutputFilePropertySpec spec : propertySpecs) {
            try {
                entries += this.packProperty(spec, outputStream);
            }
            catch (Exception ex) {
                throw new GradleException(String.format("Could not pack property '%s': %s", spec.getPropertyName(), ex.getMessage()), (Throwable)ex);
            }
        }
        return entries;
    }

    private long packProperty(CacheableTaskOutputFilePropertySpec propertySpec, TarOutputStream outputStream) throws IOException {
        String propertyName = propertySpec.getPropertyName();
        File outputFile = propertySpec.getOutputFile();
        if (outputFile == null) {
            return 0L;
        }
        String propertyPath = "property-" + propertyName;
        if (!outputFile.exists()) {
            this.storeMissingProperty(propertyPath, outputStream);
            return 1L;
        }
        switch (propertySpec.getOutputType()) {
            case DIRECTORY: {
                return 1L + this.storeDirectoryProperty(propertyPath, outputFile, outputStream);
            }
            case FILE: {
                this.storeFileProperty(propertyPath, outputFile, outputStream);
                return 1L;
            }
        }
        throw new AssertionError();
    }

    private long storeDirectoryProperty(String propertyPath, File directory, final TarOutputStream outputStream) throws IOException {
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException(String.format("Expected '%s' to be a directory", directory));
        }
        final String propertyRoot = propertyPath + "/";
        outputStream.putNextEntry(new TarEntry(propertyRoot));
        outputStream.closeEntry();
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class CountingFileVisitor
        implements FileVisitor {
            private long entries;

            CountingFileVisitor() {
            }

            @Override
            public void visitDir(FileVisitDetails dirDetails) {
                try {
                    ++this.entries;
                    TarTaskOutputPacker.this.storeDirectoryEntry(dirDetails, propertyRoot, outputStream);
                }
                catch (IOException e) {
                    throw new UncheckedIOException((Throwable)e);
                }
            }

            @Override
            public void visitFile(FileVisitDetails fileDetails) {
                try {
                    ++this.entries;
                    String path = propertyRoot + fileDetails.getRelativePath().getPathString();
                    TarTaskOutputPacker.this.storeFileEntry(fileDetails.getFile(), path, fileDetails.getLastModified(), fileDetails.getSize(), fileDetails.getMode(), outputStream);
                }
                catch (IOException e) {
                    throw new UncheckedIOException((Throwable)e);
                }
            }
        }
        CountingFileVisitor visitor = new CountingFileVisitor();
        this.directoryWalkerFactory.create().walkDir(directory, RelativePath.EMPTY_ROOT, visitor, (Spec<? super FileTreeElement>)Specs.satisfyAll(), new AtomicBoolean(), false);
        return visitor.entries;
    }

    private void storeFileProperty(String propertyPath, File file, TarOutputStream outputStream) throws IOException {
        if (!file.isFile()) {
            throw new IllegalArgumentException(String.format("Expected '%s' to be a file", file));
        }
        this.storeFileEntry(file, propertyPath, file.lastModified(), file.length(), this.fileSystem.getUnixMode(file), outputStream);
    }

    private void storeMissingProperty(String propertyPath, TarOutputStream outputStream) throws IOException {
        TarEntry entry = new TarEntry("missing-" + propertyPath);
        outputStream.putNextEntry(entry);
        outputStream.closeEntry();
    }

    private void storeDirectoryEntry(FileVisitDetails dirDetails, String propertyRoot, TarOutputStream outputStream) throws IOException {
        String path = dirDetails.getRelativePath().getPathString();
        TarTaskOutputPacker.createTarEntry(propertyRoot + path + "/", dirDetails.getLastModified(), 0L, 0x4000 | dirDetails.getMode(), outputStream);
        outputStream.closeEntry();
    }

    private void storeFileEntry(File file, String path, long lastModified, long size, int mode, TarOutputStream outputStream) throws IOException {
        TarTaskOutputPacker.createTarEntry(path, lastModified, size, 0x8000 | mode, outputStream);
        Files.copy((File)file, (OutputStream)outputStream);
        outputStream.closeEntry();
    }

    private static void createTarEntry(String path, long lastModified, long size, int mode, TarOutputStream outputStream) throws IOException {
        TarEntry entry = new TarEntry(path);
        TarTaskOutputPacker.storeModificationTime(entry, lastModified);
        entry.setSize(size);
        entry.setMode(mode);
        outputStream.putNextEntry(entry);
    }

    @Override
    public TaskOutputPacker.UnpackResult unpack(final SortedSet<ResolvedTaskOutputFilePropertySpec> propertySpecs, InputStream input, final TaskOutputOriginReader readOrigin) {
        return (TaskOutputPacker.UnpackResult)IoActions.withResource((Closeable)new TarInputStream(input), (Transformer)new Transformer<TaskOutputPacker.UnpackResult, TarInputStream>(){

            public TaskOutputPacker.UnpackResult transform(TarInputStream tarInput) {
                try {
                    return TarTaskOutputPacker.this.unpack((SortedSet<ResolvedTaskOutputFilePropertySpec>)propertySpecs, tarInput, readOrigin);
                }
                catch (IOException e) {
                    throw new UncheckedIOException((Throwable)e);
                }
            }
        });
    }

    private TaskOutputPacker.UnpackResult unpack(SortedSet<ResolvedTaskOutputFilePropertySpec> propertySpecs, TarInputStream tarInput, TaskOutputOriginReader readOriginAction) throws IOException {
        TarEntry entry;
        ImmutableMap propertySpecsMap = Maps.uniqueIndex(propertySpecs, (Function)new Function<TaskFilePropertySpec, String>(){

            public String apply(TaskFilePropertySpec propertySpec) {
                return propertySpec.getPropertyName();
            }
        });
        TaskOutputOriginMetadata originMetadata = null;
        long entries = 0L;
        while ((entry = tarInput.getNextEntry()) != null) {
            ++entries;
            String name = entry.getName();
            if (name.equals(METADATA_PATH)) {
                originMetadata = readOriginAction.execute((InputStream)new CloseShieldInputStream((InputStream)tarInput));
                continue;
            }
            Matcher matcher = PROPERTY_PATH.matcher(name);
            if (!matcher.matches()) {
                throw new IllegalStateException("Cached result format error, invalid contents: " + name);
            }
            String propertyName = matcher.group(2);
            ResolvedTaskOutputFilePropertySpec propertySpec = (ResolvedTaskOutputFilePropertySpec)propertySpecsMap.get(propertyName);
            if (propertySpec == null) {
                throw new IllegalStateException(String.format("No output property '%s' registered", propertyName));
            }
            boolean outputMissing = matcher.group(1) != null;
            String childPath = matcher.group(3);
            this.unpackPropertyEntry(propertySpec, (InputStream)tarInput, entry, childPath, outputMissing);
        }
        if (originMetadata == null) {
            throw new IllegalStateException("Cached result format error, no origin metadata was found.");
        }
        return new TaskOutputPacker.UnpackResult(originMetadata, entries);
    }

    private void unpackPropertyEntry(ResolvedTaskOutputFilePropertySpec propertySpec, InputStream input, TarEntry entry, String childPath, boolean missing) throws IOException {
        File outputFile;
        File propertyRoot = propertySpec.getOutputFile();
        if (propertyRoot == null) {
            throw new IllegalStateException("Optional property should have a value: " + propertySpec.getPropertyName());
        }
        boolean isDirEntry = entry.isDirectory();
        if (Strings.isNullOrEmpty((String)childPath)) {
            if (missing) {
                if (!TarTaskOutputPacker.makeDirectory(propertyRoot.getParentFile()) && propertyRoot.exists()) {
                    FileUtils.forceDelete((File)propertyRoot);
                }
                return;
            }
            CacheableTaskOutputFilePropertySpec.OutputType outputType = propertySpec.getOutputType();
            if (isDirEntry) {
                if (outputType != CacheableTaskOutputFilePropertySpec.OutputType.DIRECTORY) {
                    throw new IllegalStateException("Property should be an output directory property: " + propertySpec.getPropertyName());
                }
            } else if (outputType == CacheableTaskOutputFilePropertySpec.OutputType.DIRECTORY) {
                throw new IllegalStateException("Property should be an output file property: " + propertySpec.getPropertyName());
            }
            TarTaskOutputPacker.ensureDirectoryForProperty(outputType, propertyRoot);
            outputFile = propertyRoot;
        } else {
            outputFile = new File(propertyRoot, childPath);
        }
        if (isDirEntry) {
            FileUtils.forceMkdir((File)outputFile);
        } else {
            Files.asByteSink((File)outputFile, (FileWriteMode[])new FileWriteMode[0]).writeFrom(input);
        }
        this.fileSystem.chmod(outputFile, entry.getMode() & 0x1FF);
        long lastModified = TarTaskOutputPacker.getModificationTime(entry);
        if (!outputFile.setLastModified(lastModified)) {
            throw new UnsupportedOperationException(String.format("Could not set modification time for '%s'", outputFile));
        }
    }

    @VisibleForTesting
    static void ensureDirectoryForProperty(CacheableTaskOutputFilePropertySpec.OutputType outputType, File specRoot) throws IOException {
        switch (outputType) {
            case DIRECTORY: {
                if (TarTaskOutputPacker.makeDirectory(specRoot)) break;
                FileUtils.cleanDirectory((File)specRoot);
                break;
            }
            case FILE: {
                if (TarTaskOutputPacker.makeDirectory(specRoot.getParentFile()) || !specRoot.exists()) break;
                FileUtils.forceDelete((File)specRoot);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    private static boolean makeDirectory(File output) throws IOException {
        if (output.isDirectory()) {
            return false;
        }
        if (output.isFile()) {
            FileUtils.forceDelete((File)output);
        }
        FileUtils.forceMkdir((File)output);
        return true;
    }

    private static void storeModificationTime(TarEntry entry, long lastModified) {
        entry.setModTime(lastModified);
        long excessNanos = TimeUnit.MILLISECONDS.toNanos(lastModified % 1000L);
        entry.setGroupId(-excessNanos);
    }

    private static long getModificationTime(TarEntry entry) {
        long lastModified = entry.getModTime().getTime();
        long excessNanos = -entry.getLongGroupId();
        if (excessNanos < 0L || excessNanos >= NANOS_PER_SECOND) {
            throw new IllegalStateException("Invalid excess nanos: " + excessNanos);
        }
        return lastModified += TimeUnit.NANOSECONDS.toMillis(excessNanos);
    }
}

