/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.tasks;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.SortedSet;
import org.apache.commons.io.FileUtils;
import org.gradle.api.GradleException;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.changedetection.TaskArtifactState;
import org.gradle.api.internal.tasks.ResolvedTaskOutputFilePropertySpec;
import org.gradle.api.internal.tasks.execution.TaskOutputsGenerationListener;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.caching.BuildCacheKey;
import org.gradle.caching.internal.controller.BuildCacheLoadCommand;
import org.gradle.caching.internal.controller.BuildCacheStoreCommand;
import org.gradle.caching.internal.tasks.TaskOutputCachingBuildCacheKey;
import org.gradle.caching.internal.tasks.TaskOutputPacker;
import org.gradle.caching.internal.tasks.UnrecoverableTaskOutputUnpackingException;
import org.gradle.caching.internal.tasks.origin.TaskOutputOriginFactory;
import org.gradle.caching.internal.tasks.origin.TaskOutputOriginMetadata;
import org.gradle.internal.time.Timer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskOutputCacheCommandFactory {
    private static final Logger LOGGER = Logging.getLogger(TaskOutputCacheCommandFactory.class);
    private final TaskOutputPacker packer;
    private final TaskOutputOriginFactory taskOutputOriginFactory;

    public TaskOutputCacheCommandFactory(TaskOutputPacker packer, TaskOutputOriginFactory taskOutputOriginFactory) {
        this.packer = packer;
        this.taskOutputOriginFactory = taskOutputOriginFactory;
    }

    public BuildCacheLoadCommand<TaskOutputOriginMetadata> createLoad(TaskOutputCachingBuildCacheKey cacheKey, SortedSet<ResolvedTaskOutputFilePropertySpec> outputProperties, TaskInternal task, TaskOutputsGenerationListener taskOutputsGenerationListener, TaskArtifactState taskArtifactState, Timer clock) {
        return new LoadCommand(cacheKey, outputProperties, task, taskOutputsGenerationListener, taskArtifactState, clock);
    }

    public BuildCacheStoreCommand createStore(TaskOutputCachingBuildCacheKey cacheKey, SortedSet<ResolvedTaskOutputFilePropertySpec> outputProperties, TaskInternal task, Timer clock) {
        return new StoreCommand(cacheKey, outputProperties, task, clock);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StoreCommand
    implements BuildCacheStoreCommand {
        private final TaskOutputCachingBuildCacheKey cacheKey;
        private final TaskInternal task;
        private final SortedSet<ResolvedTaskOutputFilePropertySpec> outputProperties;
        private final Timer clock;

        private StoreCommand(TaskOutputCachingBuildCacheKey cacheKey, SortedSet<ResolvedTaskOutputFilePropertySpec> outputProperties, TaskInternal task, Timer clock) {
            this.cacheKey = cacheKey;
            this.task = task;
            this.outputProperties = outputProperties;
            this.clock = clock;
        }

        @Override
        public BuildCacheKey getKey() {
            return this.cacheKey;
        }

        @Override
        public BuildCacheStoreCommand.Result store(OutputStream output) throws IOException {
            LOGGER.info("Packing {}", (Object)this.task);
            final TaskOutputPacker.PackResult packResult = TaskOutputCacheCommandFactory.this.packer.pack(this.outputProperties, output, TaskOutputCacheCommandFactory.this.taskOutputOriginFactory.createWriter(this.task, this.clock.getElapsedMillis()));
            return new BuildCacheStoreCommand.Result(){

                public long getArtifactEntryCount() {
                    return packResult.entries;
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LoadCommand
    implements BuildCacheLoadCommand<TaskOutputOriginMetadata> {
        private final TaskOutputCachingBuildCacheKey cacheKey;
        private final SortedSet<ResolvedTaskOutputFilePropertySpec> outputProperties;
        private final TaskInternal task;
        private final TaskOutputsGenerationListener taskOutputsGenerationListener;
        private final TaskArtifactState taskArtifactState;
        private final Timer clock;

        private LoadCommand(TaskOutputCachingBuildCacheKey cacheKey, SortedSet<ResolvedTaskOutputFilePropertySpec> outputProperties, TaskInternal task, TaskOutputsGenerationListener taskOutputsGenerationListener, TaskArtifactState taskArtifactState, Timer clock) {
            this.cacheKey = cacheKey;
            this.outputProperties = outputProperties;
            this.task = task;
            this.taskOutputsGenerationListener = taskOutputsGenerationListener;
            this.taskArtifactState = taskArtifactState;
            this.clock = clock;
        }

        @Override
        public BuildCacheKey getKey() {
            return this.cacheKey;
        }

        @Override
        public BuildCacheLoadCommand.Result<TaskOutputOriginMetadata> load(InputStream input) {
            TaskOutputPacker.UnpackResult unpackResult;
            this.taskOutputsGenerationListener.beforeTaskOutputsGenerated();
            try {
                unpackResult = TaskOutputCacheCommandFactory.this.packer.unpack(this.outputProperties, input, TaskOutputCacheCommandFactory.this.taskOutputOriginFactory.createReader(this.task));
            }
            catch (RuntimeException e) {
                LOGGER.warn("Cleaning outputs for {} after failed load from cache.", (Object)this.task);
                try {
                    this.cleanupOutputsAfterUnpackFailure();
                    this.taskArtifactState.afterOutputsRemovedBeforeTask();
                }
                catch (RuntimeException e2) {
                    LOGGER.warn("Unrecoverable error during cleaning up after task output unpack failure", (Throwable)e2);
                    throw new UnrecoverableTaskOutputUnpackingException(String.format("Failed to unpack outputs for %s, and then failed to clean up; see log above for details", this.task), e);
                }
                throw new GradleException(String.format("Failed to unpack outputs for %s", this.task), (Throwable)e);
            }
            LOGGER.info("Unpacked output for {} from cache (took {}).", (Object)this.task, (Object)this.clock.getElapsed());
            return new BuildCacheLoadCommand.Result<TaskOutputOriginMetadata>(){

                @Override
                public long getArtifactEntryCount() {
                    return unpackResult.entries;
                }

                @Override
                public TaskOutputOriginMetadata getMetadata() {
                    return unpackResult.originMetadata;
                }
            };
        }

        private void cleanupOutputsAfterUnpackFailure() {
            for (ResolvedTaskOutputFilePropertySpec outputProperty : this.outputProperties) {
                File outputFile = outputProperty.getOutputFile();
                if (outputFile == null || !outputFile.exists()) continue;
                try {
                    if (outputFile.isDirectory()) {
                        FileUtils.cleanDirectory((File)outputFile);
                        continue;
                    }
                    FileUtils.forceDelete((File)outputFile);
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(String.format("Failed to clean up files for output property '%s' of %s: %s", outputProperty.getPropertyName(), this.task, outputFile), (Throwable)ex);
                }
            }
        }
    }
}

