/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.local.internal;

import java.io.File;
import java.io.IOException;
import org.gradle.api.Action;
import org.gradle.api.UncheckedIOException;
import org.gradle.caching.BuildCacheKey;
import org.gradle.caching.local.internal.BuildCacheTempFileStore;
import org.gradle.util.GFileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultBuildCacheTempFileStore
implements BuildCacheTempFileStore {
    private final File dir;

    public DefaultBuildCacheTempFileStore(File dir) {
        this.dir = dir;
        GFileUtils.mkdirs(this.dir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void allocateTempFile(BuildCacheKey key, Action<? super File> action) {
        File tempFile;
        String hashCode = key.getHashCode();
        try {
            tempFile = File.createTempFile(hashCode, ".part", this.dir);
        }
        catch (IOException ex) {
            throw new UncheckedIOException((Throwable)ex);
        }
        try {
            action.execute((Object)tempFile);
        }
        finally {
            if (tempFile.exists()) {
                GFileUtils.deleteQuietly(tempFile);
            }
        }
    }
}

