/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.gradle.BuildListener;
import org.gradle.BuildResult;
import org.gradle.api.Task;
import org.gradle.api.internal.ExceptionAnalyser;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.composite.internal.IncludedBuildControllers;
import org.gradle.configuration.BuildConfigurer;
import org.gradle.execution.BuildConfigurationActionExecuter;
import org.gradle.execution.BuildExecuter;
import org.gradle.execution.TaskGraphExecuter;
import org.gradle.initialization.BuildCompletionListener;
import org.gradle.initialization.GradleLauncher;
import org.gradle.initialization.InitScriptHandler;
import org.gradle.initialization.ModelConfigurationListener;
import org.gradle.initialization.ReportedException;
import org.gradle.initialization.SettingsLoader;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.RunnableBuildOperation;
import org.gradle.internal.progress.BuildOperationDescriptor;
import org.gradle.internal.service.scopes.BuildScopeServices;
import org.gradle.internal.taskgraph.CalculateTaskGraphBuildOperationType;
import org.gradle.util.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultGradleLauncher
implements GradleLauncher {
    private final InitScriptHandler initScriptHandler;
    private final SettingsLoader settingsLoader;
    private final BuildConfigurer buildConfigurer;
    private final ExceptionAnalyser exceptionAnalyser;
    private final BuildListener buildListener;
    private final ModelConfigurationListener modelConfigurationListener;
    private final BuildCompletionListener buildCompletionListener;
    private final BuildOperationExecutor buildOperationExecutor;
    private final BuildConfigurationActionExecuter buildConfigurationActionExecuter;
    private final BuildExecuter buildExecuter;
    private final BuildScopeServices buildServices;
    private final List<?> servicesToStop;
    private GradleInternal gradle;
    private SettingsInternal settings;
    private Stage stage;

    public DefaultGradleLauncher(GradleInternal gradle, InitScriptHandler initScriptHandler, SettingsLoader settingsLoader, BuildConfigurer buildConfigurer, ExceptionAnalyser exceptionAnalyser, BuildListener buildListener, ModelConfigurationListener modelConfigurationListener, BuildCompletionListener buildCompletionListener, BuildOperationExecutor operationExecutor, BuildConfigurationActionExecuter buildConfigurationActionExecuter, BuildExecuter buildExecuter, BuildScopeServices buildServices, List<?> servicesToStop) {
        this.gradle = gradle;
        this.initScriptHandler = initScriptHandler;
        this.settingsLoader = settingsLoader;
        this.buildConfigurer = buildConfigurer;
        this.exceptionAnalyser = exceptionAnalyser;
        this.buildListener = buildListener;
        this.modelConfigurationListener = modelConfigurationListener;
        this.buildOperationExecutor = operationExecutor;
        this.buildConfigurationActionExecuter = buildConfigurationActionExecuter;
        this.buildExecuter = buildExecuter;
        this.buildCompletionListener = buildCompletionListener;
        this.buildServices = buildServices;
        this.servicesToStop = servicesToStop;
    }

    @Override
    public GradleInternal getGradle() {
        return this.gradle;
    }

    @Override
    public SettingsInternal getLoadedSettings() {
        this.doBuildStages(Stage.Load);
        return this.settings;
    }

    @Override
    public GradleInternal getConfiguredBuild() {
        this.doBuildStages(Stage.Configure);
        return this.gradle;
    }

    @Override
    public GradleInternal executeTasks() {
        this.doBuildStages(Stage.Build);
        return this.gradle;
    }

    @Override
    public void finishBuild() {
        if (this.stage != null) {
            this.finishBuild(new BuildResult(this.stage.name(), this.gradle, null));
        }
    }

    private void doBuildStages(Stage upTo) {
        try {
            this.loadSettings();
            if (upTo == Stage.Load) {
                return;
            }
            this.configureBuild();
            if (upTo == Stage.Configure) {
                return;
            }
            this.constructTaskGraph();
            if (upTo == Stage.TaskGraph) {
                return;
            }
            this.runTasks();
            this.finishBuild();
        }
        catch (Throwable t) {
            Throwable failure = this.exceptionAnalyser.transform(t);
            this.finishBuild(new BuildResult(upTo.name(), this.gradle, failure));
            throw new ReportedException(failure);
        }
    }

    private void finishBuild(BuildResult result) {
        if (this.stage == Stage.Finished) {
            return;
        }
        this.buildListener.buildFinished(result);
        if (!this.isNestedBuild()) {
            ((IncludedBuildControllers)this.gradle.getServices().get(IncludedBuildControllers.class)).stopTaskExecution();
        }
        this.stage = Stage.Finished;
    }

    private void loadSettings() {
        if (this.stage == null) {
            this.buildListener.buildStarted(this.gradle);
            this.buildOperationExecutor.run((RunnableBuildOperation)new LoadBuild());
            this.stage = Stage.Load;
        }
    }

    private void configureBuild() {
        if (this.stage == Stage.Load) {
            this.buildOperationExecutor.run((RunnableBuildOperation)new ConfigureBuild());
            this.stage = Stage.Configure;
        }
    }

    private void constructTaskGraph() {
        if (this.stage == Stage.Configure) {
            this.buildOperationExecutor.run((RunnableBuildOperation)new CalculateTaskGraph());
            this.stage = Stage.TaskGraph;
        }
    }

    @Override
    public void scheduleTasks(Iterable<String> taskPaths) {
        GradleInternal gradle = this.getConfiguredBuild();
        LinkedHashSet allTasks = Sets.newLinkedHashSet(gradle.getStartParameter().getTaskNames());
        boolean added = allTasks.addAll(Lists.newArrayList(taskPaths));
        if (!added) {
            return;
        }
        gradle.getStartParameter().setTaskNames(allTasks);
        this.stage = Stage.Configure;
        this.doBuildStages(Stage.TaskGraph);
    }

    private void runTasks() {
        if (this.stage != Stage.TaskGraph) {
            throw new IllegalStateException("Cannot execute tasks: current stage = " + (Object)((Object)this.stage));
        }
        this.buildOperationExecutor.run((RunnableBuildOperation)new ExecuteTasks());
        this.stage = Stage.Build;
    }

    @Override
    public void addListener(Object listener) {
        this.gradle.addListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        try {
            CompositeStoppable.stoppable((Object[])new Object[]{this.buildServices}).add(this.servicesToStop).stop();
        }
        finally {
            this.buildCompletionListener.completed();
        }
    }

    private boolean isConfigureOnDemand() {
        return this.gradle.getStartParameter().isConfigureOnDemand();
    }

    private void projectsEvaluated() {
        this.buildListener.projectsEvaluated(this.gradle);
    }

    private String contextualize(String descriptor) {
        if (this.isNestedBuild()) {
            Path contextPath = this.gradle.findIdentityPath();
            String context = contextPath == null ? this.gradle.getStartParameter().getCurrentDir().getName() : contextPath.getPath();
            return descriptor + " (" + context + ")";
        }
        return descriptor;
    }

    private boolean isNestedBuild() {
        return this.gradle.getParent() != null;
    }

    private class ExecuteTasks
    implements RunnableBuildOperation {
        private ExecuteTasks() {
        }

        public void run(BuildOperationContext context) {
            if (!DefaultGradleLauncher.this.isNestedBuild()) {
                IncludedBuildControllers buildControllers = (IncludedBuildControllers)DefaultGradleLauncher.this.gradle.getServices().get(IncludedBuildControllers.class);
                buildControllers.startTaskExecution(true);
            }
            DefaultGradleLauncher.this.buildExecuter.execute(DefaultGradleLauncher.this.gradle);
        }

        public BuildOperationDescriptor.Builder description() {
            return BuildOperationDescriptor.displayName((String)DefaultGradleLauncher.this.contextualize("Run tasks")).parent(DefaultGradleLauncher.this.getGradle().getBuildOperation());
        }
    }

    private class CalculateTaskGraph
    implements RunnableBuildOperation {
        private CalculateTaskGraph() {
        }

        public void run(BuildOperationContext buildOperationContext) {
            DefaultGradleLauncher.this.buildConfigurationActionExecuter.select(DefaultGradleLauncher.this.gradle);
            if (DefaultGradleLauncher.this.isConfigureOnDemand()) {
                DefaultGradleLauncher.this.projectsEvaluated();
            }
            final TaskGraphExecuter taskGraph = DefaultGradleLauncher.this.gradle.getTaskGraph();
            taskGraph.populate();
            buildOperationContext.setResult((Object)new CalculateTaskGraphBuildOperationType.Result(){

                @Override
                public List<String> getRequestedTaskPaths() {
                    return this.toTaskPaths(taskGraph.getRequestedTasks());
                }

                @Override
                public List<String> getExcludedTaskPaths() {
                    return this.toTaskPaths(taskGraph.getFilteredTasks());
                }

                private List<String> toTaskPaths(Set<Task> tasks) {
                    return ImmutableSortedSet.copyOf((Collection)Collections2.transform(tasks, (Function)new Function<Task, String>(){

                        public String apply(Task task) {
                            return task.getPath();
                        }
                    })).asList();
                }
            });
        }

        public BuildOperationDescriptor.Builder description() {
            return BuildOperationDescriptor.displayName((String)DefaultGradleLauncher.this.contextualize("Calculate task graph")).details((Object)new CalculateTaskGraphBuildOperationType.Details(){}).parent(DefaultGradleLauncher.this.getGradle().getBuildOperation());
        }
    }

    private class ConfigureBuild
    implements RunnableBuildOperation {
        private ConfigureBuild() {
        }

        public void run(BuildOperationContext context) {
            DefaultGradleLauncher.this.buildConfigurer.configure(DefaultGradleLauncher.this.gradle);
            if (!DefaultGradleLauncher.this.isConfigureOnDemand()) {
                DefaultGradleLauncher.this.projectsEvaluated();
            }
            DefaultGradleLauncher.this.modelConfigurationListener.onConfigure(DefaultGradleLauncher.this.gradle);
        }

        public BuildOperationDescriptor.Builder description() {
            return BuildOperationDescriptor.displayName((String)DefaultGradleLauncher.this.contextualize("Configure build")).parent(DefaultGradleLauncher.this.getGradle().getBuildOperation());
        }
    }

    private class LoadBuild
    implements RunnableBuildOperation {
        private LoadBuild() {
        }

        public void run(BuildOperationContext context) {
            DefaultGradleLauncher.this.initScriptHandler.executeScripts(DefaultGradleLauncher.this.gradle);
            DefaultGradleLauncher.this.settings = DefaultGradleLauncher.this.settingsLoader.findAndLoadSettings(DefaultGradleLauncher.this.gradle);
        }

        public BuildOperationDescriptor.Builder description() {
            return BuildOperationDescriptor.displayName((String)DefaultGradleLauncher.this.contextualize("Load build")).parent(DefaultGradleLauncher.this.getGradle().getBuildOperation());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Stage {
        Load,
        Configure,
        TaskGraph,
        Build,
        Finished;

    }
}

