/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.scan.config;

import com.google.common.annotations.VisibleForTesting;
import org.gradle.internal.scan.config.UnsupportedBuildScanPluginVersionException;
import org.gradle.util.VersionNumber;

class BuildScanPluginCompatibilityEnforcer {
    private static final VersionNumber MAX_UNSUPPORTED_VERSION = VersionNumber.parse("1.7.4");
    private static final VersionNumber MIN_SUPPORTED_VERSION = VersionNumber.parse("1.8");
    private static final String HELP_LINK = "https://gradle.com/scans/help/gradle-incompatible-plugin-version";
    private final VersionNumber maxUnsupportedVersion;
    private final VersionNumber minSupportedVersion;

    public static BuildScanPluginCompatibilityEnforcer create() {
        return new BuildScanPluginCompatibilityEnforcer(MAX_UNSUPPORTED_VERSION, MIN_SUPPORTED_VERSION);
    }

    @VisibleForTesting
    BuildScanPluginCompatibilityEnforcer(VersionNumber maxUnsupportedVersion, VersionNumber minSupportedVersion) {
        this.maxUnsupportedVersion = maxUnsupportedVersion;
        this.minSupportedVersion = minSupportedVersion;
    }

    void assertSupported(String pluginVersion) {
        VersionNumber pluginVersionNumber = VersionNumber.parse(pluginVersion);
        if (pluginVersionNumber.equals(VersionNumber.UNKNOWN)) {
            return;
        }
        if (pluginVersionNumber.compareTo(this.maxUnsupportedVersion) <= 0) {
            throw this.unsupported();
        }
    }

    UnsupportedBuildScanPluginVersionException unsupported() {
        return new UnsupportedBuildScanPluginVersionException("This version of Gradle requires version " + this.minSupportedVersion + " of the build scan plugin or later.\nPlease see " + HELP_LINK + " for more information.");
    }
}

