/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testfixtures.internal;

import com.google.common.collect.Maps;
import java.io.File;
import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.cache.CacheBuilder;
import org.gradle.cache.CacheOpenException;
import org.gradle.cache.CacheValidator;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.cache.PersistentIndexedCacheParameters;
import org.gradle.cache.internal.CacheFactory;
import org.gradle.cache.internal.filelock.LockOptions;
import org.gradle.internal.Actions;
import org.gradle.internal.Cast;
import org.gradle.internal.Factory;
import org.gradle.internal.Pair;
import org.gradle.internal.serialize.Serializer;
import org.gradle.testfixtures.internal.InMemoryIndexedCache;
import org.gradle.util.GFileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InMemoryCacheFactory
implements CacheFactory {
    final Map<Pair<File, String>, PersistentIndexedCache<?, ?>> caches = Maps.newLinkedHashMap();

    @Override
    public PersistentCache open(File cacheDir, String displayName, @Nullable CacheValidator cacheValidator, Map<String, ?> properties, CacheBuilder.LockTarget lockTarget, LockOptions lockOptions, Action<? super PersistentCache> initializer, Action<? super PersistentCache> cleanup) throws CacheOpenException {
        GFileUtils.mkdirs(cacheDir);
        InMemoryCache cache = new InMemoryCache(cacheDir, displayName, cleanup);
        if (initializer != null) {
            initializer.execute((Object)cache);
        }
        return cache;
    }

    public PersistentCache open(File cacheDir, String displayName) {
        return new InMemoryCache(cacheDir, displayName, (Action<? super PersistentCache>)Actions.doNothing());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InMemoryCache
    implements PersistentCache {
        private final File cacheDir;
        private final String displayName;
        private boolean closed;
        private final Action<? super PersistentCache> cleanup;

        public InMemoryCache(File cacheDir, String displayName, Action<? super PersistentCache> cleanup) {
            this.cacheDir = cacheDir;
            this.displayName = displayName;
            this.cleanup = cleanup;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            if (this.cleanup != null) {
                InMemoryCache inMemoryCache = this;
                synchronized (inMemoryCache) {
                    this.cleanup.execute((Object)this);
                }
            }
            this.closed = true;
        }

        public boolean isClosed() {
            return this.closed;
        }

        @Override
        public File getBaseDir() {
            return this.cacheDir;
        }

        private void assertNotClosed() {
            if (this.closed) {
                throw new IllegalStateException("cache is closed");
            }
        }

        @Override
        public <K, V> PersistentIndexedCache<K, V> createCache(String name, Class<K> keyType, Serializer<V> valueSerializer) {
            this.assertNotClosed();
            return this.createCache(name, valueSerializer);
        }

        @Override
        public <K, V> PersistentIndexedCache<K, V> createCache(PersistentIndexedCacheParameters<K, V> parameters) {
            this.assertNotClosed();
            return this.createCache(parameters.getCacheName(), parameters.getValueSerializer());
        }

        private <K, V> PersistentIndexedCache<K, V> createCache(String name, Serializer<V> valueSerializer) {
            this.assertNotClosed();
            PersistentIndexedCache<?, ?> indexedCache = InMemoryCacheFactory.this.caches.get(Pair.of((Object)this.cacheDir, (Object)name));
            if (indexedCache == null) {
                indexedCache = new InMemoryIndexedCache(valueSerializer);
                InMemoryCacheFactory.this.caches.put((Pair<File, String>)Pair.of((Object)this.cacheDir, (Object)name), indexedCache);
            }
            return (PersistentIndexedCache)Cast.uncheckedCast(indexedCache);
        }

        @Override
        public <T> T withFileLock(Factory<? extends T> action) {
            return (T)action.create();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T useCache(Factory<? extends T> action) {
            this.assertNotClosed();
            InMemoryCache inMemoryCache = this;
            synchronized (inMemoryCache) {
                return (T)action.create();
            }
        }

        @Override
        public void useCache(Runnable action) {
            this.assertNotClosed();
            action.run();
        }

        public String toString() {
            return "InMemoryCache '" + this.displayName + "' " + this.cacheDir;
        }
    }
}

