/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.bridges;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.bridges.Bridge;
import org.jetbrains.kotlin.backend.common.bridges.BridgesKt;
import org.jetbrains.kotlin.backend.common.bridges.FunctionHandle;
import org.jetbrains.kotlin.utils.DFS;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=2, d1={"\u0000$\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a#\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\b\b\u0000\u0010\u0002*\u00020\u00032\u0006\u0010\u0004\u001a\u0002H\u0002\u00a2\u0006\u0002\u0010\u0005\u001a\u001d\u0010\u0006\u001a\u0002H\u0002\"\b\b\u0000\u0010\u0002*\u00020\u00032\u0006\u0010\u0004\u001a\u0002H\u0002\u00a2\u0006\u0002\u0010\u0007\u001aC\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u000b0\n0\t\"\b\b\u0000\u0010\u0002*\u00020\u0003\"\u0004\b\u0001\u0010\u000b2\u0006\u0010\u0004\u001a\u0002H\u00022\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u000b0\r\u00a2\u0006\u0002\u0010\u000e\u00a8\u0006\u000f"}, d2={"findAllReachableDeclarations", "", "Function", "Lorg/jetbrains/kotlin/backend/common/bridges/FunctionHandle;", "function", "(Lorg/jetbrains/kotlin/backend/common/bridges/FunctionHandle;)Ljava/util/Set;", "findConcreteSuperDeclaration", "(Lorg/jetbrains/kotlin/backend/common/bridges/FunctionHandle;)Lorg/jetbrains/kotlin/backend/common/bridges/FunctionHandle;", "generateBridges", "", "Lorg/jetbrains/kotlin/backend/common/bridges/Bridge;", "Signature", "signature", "Lkotlin/Function1;", "(Lorg/jetbrains/kotlin/backend/common/bridges/FunctionHandle;Lkotlin/jvm/functions/Function1;)Ljava/util/Set;", "kotlin-compiler"})
public final class BridgesKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <Function extends FunctionHandle, Signature> Set<Bridge<Signature>> generateBridges(@NotNull Function function2, @NotNull Function1<? super Function, ? extends Signature> signature2) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Object object;
        Iterable $receiver$iv2;
        Collection<Object> collection;
        boolean fake;
        Intrinsics.checkParameterIsNotNull(function2, "function");
        Intrinsics.checkParameterIsNotNull(signature2, "signature");
        if (function2.isAbstract()) {
            return SetsKt.emptySet();
        }
        boolean bl = fake = !function2.isDeclaration();
        if (fake) {
            boolean bl2;
            block10: {
                Iterable<FunctionHandle> $receiver$iv4 = function2.getOverridden();
                for (FunctionHandle functionHandle : $receiver$iv4) {
                    FunctionHandle it = functionHandle;
                    if (!it.isAbstract()) continue;
                    bl2 = false;
                    break block10;
                }
                bl2 = true;
            }
            if (bl2) {
                return SetsKt.emptySet();
            }
        }
        Function implementation = BridgesKt.findConcreteSuperDeclaration(function2);
        Iterable iterable = BridgesKt.findAllReachableDeclarations(function2);
        Collection destination$iv = new HashSet();
        for (Object item$iv : iterable) {
            destination$iv.add(signature2.invoke(item$iv));
        }
        HashSet bridgesToGenerate2 = (HashSet)destination$iv;
        if (fake) {
            Iterable<FunctionHandle> iterable2 = function2.getOverridden();
            if (iterable2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Iterable<Function>");
            }
            for (FunctionHandle functionHandle : iterable2) {
                void $receiver$iv$iv2;
                Object item$iv;
                if (functionHandle.isAbstract()) continue;
                Iterable $i$a$1$none = BridgesKt.findAllReachableDeclarations(functionHandle);
                collection = bridgesToGenerate2;
                item$iv = $receiver$iv2;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv2, 10));
                for (Object item$iv$iv2 : $receiver$iv$iv2) {
                    destination$iv$iv.add(signature2.invoke(item$iv$iv2));
                }
                object = (List)destination$iv$iv;
                ((AbstractSet)collection).removeAll((Collection)object);
            }
        }
        Signature Signature = signature2.invoke(implementation);
        bridgesToGenerate2.remove(Signature);
        $receiver$iv2 = $receiver$iv = (Iterable)bridgesToGenerate2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        Iterator iterator2 = $receiver$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            Object item$iv$iv;
            Object item$iv$iv2;
            item$iv$iv2 = item$iv$iv = iterator2.next();
            collection = destination$iv$iv;
            object = new Bridge<void>(it, (void)Signature);
            collection.add(object);
        }
        return CollectionsKt.toSet((List)destination$iv$iv);
    }

    @NotNull
    public static final <Function extends FunctionHandle> Set<Function> findAllReachableDeclarations(@NotNull Function function2) {
        Intrinsics.checkParameterIsNotNull(function2, "function");
        DFS.NodeHandlerWithListResult collector2 = new DFS.NodeHandlerWithListResult<Function, Function>(){

            public void afterChildren(@NotNull Function current) {
                Intrinsics.checkParameterIsNotNull(current, "current");
                if (current.isDeclaration()) {
                    ((LinkedList)this.result).add(current);
                }
            }
        };
        DFS.dfs((Collection)CollectionsKt.listOf(function2), findAllReachableDeclarations.1.INSTANCE, collector2);
        return new HashSet((Collection)collector2.result());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <Function extends FunctionHandle> Function findConcreteSuperDeclaration(@NotNull Function function2) {
        void $receiver$iv$iv;
        Iterable<Object> reachable;
        boolean bl;
        Intrinsics.checkParameterIsNotNull(function2, "function");
        boolean bl2 = bl = !function2.isAbstract();
        if (!bl) {
            String string = "Only concrete functions have implementations: " + function2;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        if (function2.isDeclaration()) {
            return function2;
        }
        Set<Function> result2 = BridgesKt.findAllReachableDeclarations(function2);
        HashSet toRemove = new HashSet();
        for (Function declaration : result2) {
            reachable = BridgesKt.findAllReachableDeclarations(declaration);
            reachable.remove(declaration);
            toRemove.addAll(reachable);
        }
        result2.removeAll(toRemove);
        Iterable $receiver$iv = result2;
        reachable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            FunctionHandle it = (FunctionHandle)element$iv$iv;
            if (!(!it.isAbstract() && !it.isInterfaceDeclaration())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List concreteRelevantDeclarations = (List)destination$iv$iv;
        if (concreteRelevantDeclarations.size() != 1) {
            String string = "Concrete fake override " + function2 + " should have exactly one concrete super-declaration: " + concreteRelevantDeclarations;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return (Function)((FunctionHandle)concreteRelevantDeclarations.get(0));
    }
}

