/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common;

import java.io.PrintStream;
import java.lang.reflect.Field;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.CLICompiler;
import org.jetbrains.kotlin.cli.common.arguments.Argument;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.ParseCommandLineArgumentsKt;

class Usage {
    Usage() {
    }

    public static <A extends CommonCompilerArguments> void print(@NotNull PrintStream target, @NotNull CLICompiler<A> compiler2, @NotNull A arguments2) {
        if (target == null) {
            Usage.$$$reportNull$$$0(0);
        }
        if (compiler2 == null) {
            Usage.$$$reportNull$$$0(1);
        }
        if (arguments2 == null) {
            Usage.$$$reportNull$$$0(2);
        }
        target.println("Usage: " + compiler2.executableScriptFileName() + " <options> <source files>");
        target.println("where " + (arguments2.extraHelp ? "advanced" : "possible") + " options include:");
        for (Class<?> clazz = arguments2.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            for (Field field : clazz.getDeclaredFields()) {
                String usage = Usage.fieldUsage(field, arguments2.extraHelp);
                if (usage == null) continue;
                target.println(usage);
            }
        }
        if (arguments2.extraHelp) {
            target.println();
            target.println("Advanced options are non-standard and may be changed or removed without any notice.");
        }
    }

    @Nullable
    private static String fieldUsage(@NotNull Field field, boolean extraHelp) {
        Argument argument;
        if (field == null) {
            Usage.$$$reportNull$$$0(3);
        }
        if ((argument = field.getAnnotation(Argument.class)) == null) {
            return null;
        }
        if (extraHelp != ParseCommandLineArgumentsKt.isAdvanced(argument)) {
            return null;
        }
        StringBuilder sb = new StringBuilder("  ");
        sb.append(argument.value());
        if (!argument.shortName().isEmpty()) {
            sb.append(" (");
            sb.append(argument.shortName());
            sb.append(")");
        }
        if (!argument.valueDescription().isEmpty()) {
            sb.append(ParseCommandLineArgumentsKt.isAdvanced(argument) ? "=" : " ");
            sb.append(argument.valueDescription());
        }
        int width = 28;
        if (sb.length() >= width + 5) {
            sb.append("\n");
            width += sb.length();
        }
        while (sb.length() < width) {
            sb.append(" ");
        }
        sb.append(" ");
        sb.append(argument.description());
        return sb.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compiler";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/cli/common/Usage";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "print";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "fieldUsage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

