/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.stubs;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.lang.FileASTNode;
import org.jetbrains.kotlin.com.intellij.lang.LighterAST;
import org.jetbrains.kotlin.com.intellij.lang.LighterASTNode;
import org.jetbrains.kotlin.com.intellij.lang.TreeBackedLighterAST;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.LogUtil;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.FileType;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.LanguageFileType;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.StubBuilder;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.PsiFileImpl;
import org.jetbrains.kotlin.com.intellij.psi.stubs.ILightStubElementType;
import org.jetbrains.kotlin.com.intellij.psi.stubs.IStubElementType;
import org.jetbrains.kotlin.com.intellij.psi.stubs.ObjectStubBase;
import org.jetbrains.kotlin.com.intellij.psi.stubs.PsiFileStubImpl;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.ILightStubFileElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.IStubFileElementType;
import org.jetbrains.kotlin.com.intellij.util.containers.BooleanStack;
import org.jetbrains.kotlin.com.intellij.util.containers.Stack;
import org.jetbrains.kotlin.gnu.trove.TIntStack;

public class LightStubBuilder
implements StubBuilder {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.stubs.LightStubBuilder");
    public static final ThreadLocal<LighterAST> FORCED_AST = new ThreadLocal();

    @Override
    public StubElement buildStubTree(@NotNull PsiFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/stubs/LightStubBuilder", "buildStubTree"));
        }
        LighterAST tree = FORCED_AST.get();
        if (tree == null) {
            FileType fileType = file2.getFileType();
            if (!(fileType instanceof LanguageFileType)) {
                LOG.error("File is not of LanguageFileType: " + fileType + ", " + file2);
                return null;
            }
            assert (file2 instanceof PsiFileImpl);
            IStubFileElementType contentType = ((PsiFileImpl)file2).getElementTypeForStubBuilder();
            if (contentType == null) {
                LOG.error("File is not of IStubFileElementType: " + file2);
                return null;
            }
            FileASTNode node = file2.getNode();
            tree = node.getElementType() instanceof ILightStubFileElementType ? node.getLighterAST() : new TreeBackedLighterAST(node);
        } else {
            FORCED_AST.set(null);
        }
        if (tree == null) {
            return null;
        }
        StubElement rootStub = this.createStubForFile(file2, tree);
        this.buildStubTree(tree, tree.getRoot(), rootStub);
        return rootStub;
    }

    @NotNull
    protected StubElement createStubForFile(@NotNull PsiFile file2, @NotNull LighterAST tree) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/stubs/LightStubBuilder", "createStubForFile"));
        }
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "org/jetbrains/kotlin/com/intellij/psi/stubs/LightStubBuilder", "createStubForFile"));
        }
        PsiFileStubImpl<PsiFile> psiFileStubImpl = new PsiFileStubImpl<PsiFile>(file2);
        if (psiFileStubImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/stubs/LightStubBuilder", "createStubForFile"));
        }
        return psiFileStubImpl;
    }

    protected void buildStubTree(@NotNull LighterAST tree, @NotNull LighterASTNode root, @NotNull StubElement rootStub) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "org/jetbrains/kotlin/com/intellij/psi/stubs/LightStubBuilder", "buildStubTree"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/kotlin/com/intellij/psi/stubs/LightStubBuilder", "buildStubTree"));
        }
        if (rootStub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootStub", "org/jetbrains/kotlin/com/intellij/psi/stubs/LightStubBuilder", "buildStubTree"));
        }
        Stack<LighterASTNode> parents2 = new Stack<LighterASTNode>();
        TIntStack childNumbers = new TIntStack();
        BooleanStack parentsStubbed = new BooleanStack();
        Stack<List> kinderGarden = new Stack<List>();
        Stack<StubElement> parentStubs = new Stack<StubElement>();
        LighterASTNode parent2 = null;
        LighterASTNode element = root;
        List children = null;
        int childNumber = 0;
        StubElement parentStub = rootStub;
        boolean immediateParentStubbed = true;
        block0: while (element != null) {
            List kids;
            boolean hasStub;
            StubElement stub = LightStubBuilder.createStub(tree, element, parentStub);
            boolean bl = hasStub = stub != parentStub || parent2 == null;
            if (hasStub && !immediateParentStubbed) {
                ((ObjectStubBase)((Object)stub)).markDangling();
            }
            if (!(parent2 != null && this.skipNode(tree, parent2, element) || (kids = tree.getChildren(element)).isEmpty())) {
                if (parent2 != null) {
                    parents2.push(parent2);
                    childNumbers.push(childNumber);
                    kinderGarden.push(children);
                    parentStubs.push(parentStub);
                    parentsStubbed.push(immediateParentStubbed);
                }
                parent2 = element;
                immediateParentStubbed = hasStub;
                children = kids;
                childNumber = 0;
                element = children.get(0);
                parentStub = stub;
                if (!this.skipNode(tree, parent2, element)) continue;
            }
            while (children != null && ++childNumber < children.size()) {
                element = (LighterASTNode)children.get(childNumber);
                if (this.skipNode(tree, parent2, element)) continue;
                continue block0;
            }
            element = null;
            while (!parents2.isEmpty()) {
                parent2 = (LighterASTNode)parents2.pop();
                childNumber = childNumbers.pop();
                children = (List)kinderGarden.pop();
                parentStub = (StubElement)parentStubs.pop();
                immediateParentStubbed = parentsStubbed.pop();
                while (++childNumber < children.size()) {
                    element = (LighterASTNode)children.get(childNumber);
                    if (this.skipNode(tree, parent2, element)) continue;
                    continue block0;
                }
                element = null;
            }
        }
    }

    @NotNull
    private static StubElement createStub(LighterAST tree, LighterASTNode element, StubElement parentStub) {
        IElementType elementType = element.getTokenType();
        if (elementType instanceof IStubElementType) {
            if (elementType instanceof ILightStubElementType) {
                ILightStubElementType lightElementType = (ILightStubElementType)elementType;
                if (lightElementType.shouldCreateStub(tree, element, parentStub)) {
                    Object StubT = lightElementType.createStub(tree, element, parentStub);
                    if (StubT == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/stubs/LightStubBuilder", "createStub"));
                    }
                    return StubT;
                }
            } else {
                LOG.error("Element is not of ILightStubElementType: " + LogUtil.objectAndClass(elementType) + ", " + element);
            }
        }
        StubElement stubElement = parentStub;
        if (stubElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/stubs/LightStubBuilder", "createStub"));
        }
        return stubElement;
    }

    private boolean skipNode(@NotNull LighterAST tree, @NotNull LighterASTNode parent2, @NotNull LighterASTNode node) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "org/jetbrains/kotlin/com/intellij/psi/stubs/LightStubBuilder", "skipNode"));
        }
        if (parent2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "org/jetbrains/kotlin/com/intellij/psi/stubs/LightStubBuilder", "skipNode"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/com/intellij/psi/stubs/LightStubBuilder", "skipNode"));
        }
        if (tree instanceof TreeBackedLighterAST) {
            return this.skipChildProcessingWhenBuildingStubs(((TreeBackedLighterAST)tree).unwrap(parent2), ((TreeBackedLighterAST)tree).unwrap(node));
        }
        return this.skipChildProcessingWhenBuildingStubs(tree, parent2, node);
    }

    @Override
    public boolean skipChildProcessingWhenBuildingStubs(@NotNull ASTNode parent2, @NotNull ASTNode node) {
        if (parent2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "org/jetbrains/kotlin/com/intellij/psi/stubs/LightStubBuilder", "skipChildProcessingWhenBuildingStubs"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/com/intellij/psi/stubs/LightStubBuilder", "skipChildProcessingWhenBuildingStubs"));
        }
        return false;
    }

    protected boolean skipChildProcessingWhenBuildingStubs(@NotNull LighterAST tree, @NotNull LighterASTNode parent2, @NotNull LighterASTNode node) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "org/jetbrains/kotlin/com/intellij/psi/stubs/LightStubBuilder", "skipChildProcessingWhenBuildingStubs"));
        }
        if (parent2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "org/jetbrains/kotlin/com/intellij/psi/stubs/LightStubBuilder", "skipChildProcessingWhenBuildingStubs"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/com/intellij/psi/stubs/LightStubBuilder", "skipChildProcessingWhenBuildingStubs"));
        }
        return false;
    }
}

