/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization.js.ast;

import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsArrayAccess;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsBreak;
import org.jetbrains.kotlin.js.backend.ast.JsCase;
import org.jetbrains.kotlin.js.backend.ast.JsCatch;
import org.jetbrains.kotlin.js.backend.ast.JsClassModel;
import org.jetbrains.kotlin.js.backend.ast.JsConditional;
import org.jetbrains.kotlin.js.backend.ast.JsContinue;
import org.jetbrains.kotlin.js.backend.ast.JsDebugger;
import org.jetbrains.kotlin.js.backend.ast.JsDefault;
import org.jetbrains.kotlin.js.backend.ast.JsDoWhile;
import org.jetbrains.kotlin.js.backend.ast.JsDynamicScope;
import org.jetbrains.kotlin.js.backend.ast.JsEmpty;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsFor;
import org.jetbrains.kotlin.js.backend.ast.JsForIn;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsGlobalBlock;
import org.jetbrains.kotlin.js.backend.ast.JsIf;
import org.jetbrains.kotlin.js.backend.ast.JsImportedModule;
import org.jetbrains.kotlin.js.backend.ast.JsLabel;
import org.jetbrains.kotlin.js.backend.ast.JsLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsLocation;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameBinding;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsNullLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsPostfixOperation;
import org.jetbrains.kotlin.js.backend.ast.JsPrefixOperation;
import org.jetbrains.kotlin.js.backend.ast.JsProgram;
import org.jetbrains.kotlin.js.backend.ast.JsProgramFragment;
import org.jetbrains.kotlin.js.backend.ast.JsPropertyInitializer;
import org.jetbrains.kotlin.js.backend.ast.JsRegExp;
import org.jetbrains.kotlin.js.backend.ast.JsReturn;
import org.jetbrains.kotlin.js.backend.ast.JsRootScope;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsSwitchMember;
import org.jetbrains.kotlin.js.backend.ast.JsThrow;
import org.jetbrains.kotlin.js.backend.ast.JsTry;
import org.jetbrains.kotlin.js.backend.ast.JsUnaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsUnaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.JsWhile;
import org.jetbrains.kotlin.js.backend.ast.metadata.HasMetadata;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.backend.ast.metadata.SideEffectKind;
import org.jetbrains.kotlin.protobuf.CodedInputStream;
import org.jetbrains.kotlin.protobuf.ProtocolStringList;
import org.jetbrains.kotlin.resolve.inline.InlineStrategy;
import org.jetbrains.kotlin.serialization.js.ast.JsAstDeserializer$WhenMappings;
import org.jetbrains.kotlin.serialization.js.ast.JsAstProtoBuf;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u00cc\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0010\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\u0017H\u0002J\u0010\u0010\u0010\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u0019H\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u001aH\u0002J\u0010\u0010\u0010\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0014\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020\n2\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u0010#\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u0019H\u0002J\u0010\u0010#\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u001cH\u0002J\u0010\u0010$\u001a\u00020%2\u0006\u0010\u0014\u001a\u00020&H\u0002J\u0010\u0010'\u001a\u00020\u00072\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u0010(\u001a\u00020)2\u0006\u0010\u0014\u001a\u00020*H\u0002J\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0002J\u0010\u0010+\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0002J\u0010\u0010+\u001a\u0002022\u0006\u00103\u001a\u000204H\u0002J\u0010\u0010+\u001a\u0002052\u0006\u0010-\u001a\u000206H\u0002J9\u00107\u001a\u0002H8\"\b\b\u0000\u00108*\u0002092\b\u0010:\u001a\u0004\u0018\u00010\"2\b\u0010;\u001a\u0004\u0018\u00010<2\f\u0010=\u001a\b\u0012\u0004\u0012\u0002H80>H\u0002\u00a2\u0006\u0002\u0010?R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lorg/jetbrains/kotlin/serialization/js/ast/JsAstDeserializer;", "", "program", "Lorg/jetbrains/kotlin/js/backend/ast/JsProgram;", "(Lorg/jetbrains/kotlin/js/backend/ast/JsProgram;)V", "fileStack", "Ljava/util/Deque;", "", "nameCache", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "nameTable", "Lorg/jetbrains/kotlin/serialization/js/ast/JsAstProtoBuf$Name;", "scope", "Lorg/jetbrains/kotlin/js/backend/ast/JsRootScope;", "stringTable", "deserialize", "Lorg/jetbrains/kotlin/js/backend/ast/JsProgramFragment;", "input", "Ljava/io/InputStream;", "proto", "Lorg/jetbrains/kotlin/serialization/js/ast/JsAstProtoBuf$Chunk;", "Lorg/jetbrains/kotlin/js/backend/ast/JsClassModel;", "Lorg/jetbrains/kotlin/serialization/js/ast/JsAstProtoBuf$ClassModel;", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "Lorg/jetbrains/kotlin/serialization/js/ast/JsAstProtoBuf$Expression;", "Lorg/jetbrains/kotlin/serialization/js/ast/JsAstProtoBuf$Fragment;", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "Lorg/jetbrains/kotlin/serialization/js/ast/JsAstProtoBuf$Statement;", "deserializeGlobalBlock", "Lorg/jetbrains/kotlin/js/backend/ast/JsGlobalBlock;", "Lorg/jetbrains/kotlin/serialization/js/ast/JsAstProtoBuf$GlobalBlock;", "deserializeName", "id", "", "deserializeNoMetadata", "deserializeParameter", "Lorg/jetbrains/kotlin/js/backend/ast/JsParameter;", "Lorg/jetbrains/kotlin/serialization/js/ast/JsAstProtoBuf$Parameter;", "deserializeString", "deserializeVars", "Lorg/jetbrains/kotlin/js/backend/ast/JsVars;", "Lorg/jetbrains/kotlin/serialization/js/ast/JsAstProtoBuf$Vars;", "map", "Lorg/jetbrains/kotlin/js/backend/ast/JsBinaryOperator;", "op", "Lorg/jetbrains/kotlin/serialization/js/ast/JsAstProtoBuf$BinaryOperation$Type;", "Lorg/jetbrains/kotlin/resolve/inline/InlineStrategy;", "inlineStrategy", "Lorg/jetbrains/kotlin/serialization/js/ast/JsAstProtoBuf$InlineStrategy;", "Lorg/jetbrains/kotlin/js/backend/ast/metadata/SideEffectKind;", "sideEffects", "Lorg/jetbrains/kotlin/serialization/js/ast/JsAstProtoBuf$SideEffects;", "Lorg/jetbrains/kotlin/js/backend/ast/JsUnaryOperator;", "Lorg/jetbrains/kotlin/serialization/js/ast/JsAstProtoBuf$UnaryOperation$Type;", "withLocation", "T", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "fileId", "location", "Lorg/jetbrains/kotlin/serialization/js/ast/JsAstProtoBuf$Location;", "action", "Lkotlin/Function0;", "(Ljava/lang/Integer;Lorg/jetbrains/kotlin/serialization/js/ast/JsAstProtoBuf$Location;Lkotlin/jvm/functions/Function0;)Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "kotlin-compiler"})
public final class JsAstDeserializer {
    private final JsRootScope scope;
    private final List<String> stringTable;
    private final List<JsAstProtoBuf.Name> nameTable;
    private final List<JsName> nameCache;
    private final Deque<String> fileStack;
    private final JsProgram program;

    @NotNull
    public final JsProgramFragment deserialize(@NotNull InputStream input) {
        Intrinsics.checkParameterIsNotNull(input, "input");
        CodedInputStream codedInputStream = CodedInputStream.newInstance(input);
        JsAstDeserializer jsAstDeserializer = this;
        CodedInputStream $receiver = codedInputStream;
        $receiver.setRecursionLimit(4096);
        CodedInputStream codedInputStream2 = codedInputStream;
        JsAstProtoBuf.Chunk chunk = JsAstProtoBuf.Chunk.parseFrom(codedInputStream2);
        Intrinsics.checkExpressionValueIsNotNull(chunk, "Chunk.parseFrom(CodedInp\u2026etRecursionLimit(4096) })");
        return jsAstDeserializer.deserialize(chunk);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final JsProgramFragment deserialize(@NotNull JsAstProtoBuf.Chunk proto) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(proto, "proto");
        Object object = this.stringTable;
        ProtocolStringList protocolStringList = proto.getStringTable().getEntryList();
        Intrinsics.checkExpressionValueIsNotNull(protocolStringList, "proto.stringTable.entryList");
        Iterable iterable = protocolStringList;
        CollectionsKt.addAll(object, iterable);
        object = this.nameTable;
        List<JsAstProtoBuf.Name> list2 = proto.getNameTable().getEntryList();
        Intrinsics.checkExpressionValueIsNotNull(list2, "proto.nameTable.entryList");
        iterable = list2;
        CollectionsKt.addAll(object, iterable);
        object = this.nameCache;
        Iterable iterable2 = $receiver$iv = (Iterable)this.nameTable;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            JsAstProtoBuf.Name name = (JsAstProtoBuf.Name)item$iv$iv;
            Collection collection = destination$iv$iv;
            Object e = null;
            collection.add(e);
        }
        iterable = (List)destination$iv$iv;
        CollectionsKt.addAll(object, iterable);
        try {
            JsAstProtoBuf.Fragment fragment = proto.getFragment();
            Intrinsics.checkExpressionValueIsNotNull(fragment, "proto.fragment");
            object = this.deserialize(fragment);
            return object;
        }
        finally {
            this.stringTable.clear();
            this.nameTable.clear();
            this.nameCache.clear();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final JsProgramFragment deserialize(JsAstProtoBuf.Fragment proto) {
        void $receiver$iv$iv;
        void $receiver$iv$iv2;
        void $receiver$iv$iv3;
        Object element$iv$iv2;
        void $receiver$iv$iv4;
        Object object;
        Object object2;
        void $receiver$iv$iv5;
        JsProgramFragment fragment = new JsProgramFragment(this.scope);
        Map<JsName, JsClassModel> map2 = fragment.getImportedModules();
        Map<String, JsExpression> $receiver$iv = proto.getImportedModuleList();
        Iterable iterable = $receiver$iv;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv5) {
            JsExpression jsExpression;
            void importedModuleProto;
            JsAstProtoBuf.ImportedModule importedModule = (JsAstProtoBuf.ImportedModule)item$iv$iv;
            object2 = destination$iv$iv;
            String string = this.deserializeString(importedModuleProto.getExternalNameId());
            JsName jsName = this.deserializeName(importedModuleProto.getInternalNameId());
            if (importedModuleProto.hasPlainReference()) {
                JsAstProtoBuf.Expression expression2 = importedModuleProto.getPlainReference();
                Intrinsics.checkExpressionValueIsNotNull(expression2, "importedModuleProto.plainReference");
                jsExpression = this.deserialize(expression2);
            } else {
                jsExpression = null;
            }
            object = new JsImportedModule(string, jsName, jsExpression);
            object2.add(object);
        }
        $receiver$iv = (List)destination$iv$iv;
        CollectionsKt.addAll(map2, $receiver$iv);
        map2 = fragment.getImports();
        $receiver$iv = proto.getImportEntryList();
        int capacity$iv22 = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10)), 16);
        destination$iv$iv = $receiver$iv;
        Object destination$iv$iv2 = new LinkedHashMap(capacity$iv22);
        for (Object element$iv$iv2 : $receiver$iv$iv4) {
            Map $i$a$3$map = destination$iv$iv2;
            JsAstProtoBuf.Import importProto = (JsAstProtoBuf.Import)element$iv$iv2;
            String string = this.deserializeString(importProto.getSignatureId());
            JsAstProtoBuf.Expression expression3 = importProto.getExpression();
            Intrinsics.checkExpressionValueIsNotNull(expression3, "importProto.expression");
            Pair<String, JsExpression> pair = TuplesKt.to(string, this.deserialize(expression3));
            $i$a$3$map.put(pair.getFirst(), pair.getSecond());
        }
        $receiver$iv = destination$iv$iv2;
        map2.putAll($receiver$iv);
        if (proto.hasDeclarationBlock()) {
            map2 = fragment.getDeclarationBlock().getStatements();
            JsAstProtoBuf.GlobalBlock globalBlock = proto.getDeclarationBlock();
            Intrinsics.checkExpressionValueIsNotNull(globalBlock, "proto.declarationBlock");
            List<JsStatement> list2 = this.deserializeGlobalBlock(globalBlock).getStatements();
            Intrinsics.checkExpressionValueIsNotNull(list2, "deserializeGlobalBlock(p\u2026larationBlock).statements");
            $receiver$iv = list2;
            CollectionsKt.addAll(map2, $receiver$iv);
        }
        if (proto.hasInitializerBlock()) {
            map2 = fragment.getInitializerBlock().getStatements();
            JsAstProtoBuf.GlobalBlock globalBlock = proto.getInitializerBlock();
            Intrinsics.checkExpressionValueIsNotNull(globalBlock, "proto.initializerBlock");
            List<JsStatement> list3 = this.deserializeGlobalBlock(globalBlock).getStatements();
            Intrinsics.checkExpressionValueIsNotNull(list3, "deserializeGlobalBlock(p\u2026tializerBlock).statements");
            $receiver$iv = list3;
            CollectionsKt.addAll(map2, $receiver$iv);
        }
        if (proto.hasExportBlock()) {
            map2 = fragment.getExportBlock().getStatements();
            JsAstProtoBuf.GlobalBlock globalBlock = proto.getExportBlock();
            Intrinsics.checkExpressionValueIsNotNull(globalBlock, "proto.exportBlock");
            List<JsStatement> list4 = this.deserializeGlobalBlock(globalBlock).getStatements();
            Intrinsics.checkExpressionValueIsNotNull(list4, "deserializeGlobalBlock(p\u2026o.exportBlock).statements");
            $receiver$iv = list4;
            CollectionsKt.addAll(map2, $receiver$iv);
        }
        map2 = fragment.getNameBindings();
        Map<String, JsExpression> capacity$iv22 = $receiver$iv = (Iterable)proto.getNameBindingList();
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv3) {
            void nameBindingProto;
            element$iv$iv2 = (JsAstProtoBuf.NameBinding)item$iv$iv;
            object2 = destination$iv$iv;
            object = new JsNameBinding(this.deserializeString(nameBindingProto.getSignatureId()), this.deserializeName(nameBindingProto.getNameId()));
            object2.add(object);
        }
        $receiver$iv = (List)destination$iv$iv;
        CollectionsKt.addAll(map2, $receiver$iv);
        map2 = fragment.getClasses();
        $receiver$iv = proto.getClassModelList();
        int capacity$iv32 = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10)), 16);
        destination$iv$iv = $receiver$iv;
        destination$iv$iv2 = new LinkedHashMap(capacity$iv32);
        for (Object element$iv$iv2 : $receiver$iv$iv4) {
            JsClassModel $i$f$map;
            JsAstProtoBuf.ClassModel clsProto;
            Iterator $i$a$5$map = destination$iv$iv2;
            JsAstProtoBuf.ClassModel classModel = clsProto = (JsAstProtoBuf.ClassModel)element$iv$iv2;
            Intrinsics.checkExpressionValueIsNotNull(classModel, "clsProto");
            JsClassModel it = $i$f$map = this.deserialize(classModel);
            Pair<JsName, JsClassModel> pair = TuplesKt.to(it.getName(), it);
            $i$a$5$map.put(pair.getFirst(), pair.getSecond());
        }
        $receiver$iv = destination$iv$iv2;
        map2.putAll((Map<JsName, JsClassModel>)$receiver$iv);
        Map<String, JsExpression> capacity$iv32 = $receiver$iv = (Iterable)proto.getModuleExpressionList();
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv2) {
            void it;
            element$iv$iv2 = (JsAstProtoBuf.Expression)item$iv$iv;
            object2 = destination$iv$iv;
            void v13 = it;
            Intrinsics.checkExpressionValueIsNotNull(v13, "it");
            object = this.deserialize((JsAstProtoBuf.Expression)v13);
            object2.add(object);
        }
        List moduleExpressions = (List)destination$iv$iv;
        $receiver$iv = fragment.getInlineModuleMap();
        Iterable $receiver$iv2 = proto.getInlineModuleList();
        int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($receiver$iv2, 10)), 16);
        destination$iv$iv2 = $receiver$iv2;
        Map destination$iv$iv3 = new LinkedHashMap(capacity$iv);
        for (Object element$iv$iv3 : $receiver$iv$iv) {
            Map map3 = destination$iv$iv3;
            JsAstProtoBuf.InlineModule inlineModuleProto = (JsAstProtoBuf.InlineModule)element$iv$iv3;
            Pair pair = TuplesKt.to(this.deserializeString(inlineModuleProto.getSignatureId()), moduleExpressions.get(inlineModuleProto.getExpressionId()));
            map3.put(pair.getFirst(), pair.getSecond());
        }
        Map map4 = destination$iv$iv3;
        $receiver$iv.putAll(map4);
        for (JsNameBinding nameBinding : fragment.getNameBindings()) {
            Map<String, JsExpression> map5;
            Map<String, JsExpression> map6 = fragment.getImports();
            String string = nameBinding.getKey();
            object2 = nameBinding.getName();
            Map<String, JsExpression> map7 = map5 = map6;
            if (map7 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<K, *>");
            }
            boolean bl = map7.containsKey(string);
            MetadataProperties.setImported((JsName)object2, bl);
        }
        return fragment;
    }

    private final JsClassModel deserialize(JsAstProtoBuf.ClassModel proto) {
        JsClassModel jsClassModel;
        JsName superName = proto.hasSuperNameId() ? this.deserializeName(proto.getSuperNameId()) : null;
        JsClassModel $receiver = jsClassModel = new JsClassModel(this.deserializeName(proto.getNameId()), superName);
        if (proto.hasPostDeclarationBlock()) {
            Collection collection = $receiver.getPostDeclarationBlock().getStatements();
            JsAstProtoBuf.GlobalBlock globalBlock = proto.getPostDeclarationBlock();
            Intrinsics.checkExpressionValueIsNotNull(globalBlock, "proto.postDeclarationBlock");
            List<JsStatement> list2 = this.deserializeGlobalBlock(globalBlock).getStatements();
            Intrinsics.checkExpressionValueIsNotNull(list2, "deserializeGlobalBlock(p\u2026larationBlock).statements");
            Iterable iterable = list2;
            CollectionsKt.addAll(collection, iterable);
        }
        return jsClassModel;
    }

    private final JsStatement deserialize(JsAstProtoBuf.Statement proto) {
        JsStatement statement2 = (JsStatement)this.withLocation(proto.hasFileId() ? Integer.valueOf(proto.getFileId()) : null, proto.hasLocation() ? proto.getLocation() : null, (Function0)new Function0<JsStatement>(this, proto){
            final /* synthetic */ JsAstDeserializer this$0;
            final /* synthetic */ JsAstProtoBuf.Statement $proto;

            @NotNull
            public final JsStatement invoke() {
                return JsAstDeserializer.access$deserializeNoMetadata(this.this$0, this.$proto);
            }
            {
                this.this$0 = jsAstDeserializer;
                this.$proto = statement2;
                super(0);
            }
        });
        if (statement2 instanceof HasMetadata) {
            MetadataProperties.setSynthetic((HasMetadata)((Object)statement2), proto.getSynthetic());
        }
        return statement2;
    }

    /*
     * Unable to fully structure code
     */
    private final JsStatement deserializeNoMetadata(JsAstProtoBuf.Statement proto) {
        v0 = proto.getStatementCase();
        if (v0 == null) ** GOTO lbl-1000
        switch (JsAstDeserializer$WhenMappings.$EnumSwitchMapping$0[v0.ordinal()]) {
            case 1: {
                returnProto = proto.getReturnStatement();
                if (returnProto.hasValue()) {
                    v1 = returnProto.getValue();
                    Intrinsics.checkExpressionValueIsNotNull(v1, "returnProto.value");
                    v2 = this.deserialize(v1);
                } else {
                    v2 = null;
                }
                v3 = new JsReturn(v2);
                break;
            }
            case 2: {
                throwProto = proto.getThrowStatement();
                v4 = throwProto.getException();
                Intrinsics.checkExpressionValueIsNotNull(v4, "throwProto.exception");
                v3 = new JsThrow(this.deserialize(v4));
                break;
            }
            case 3: {
                breakProto = proto.getBreakStatement();
                v3 = new JsBreak(breakProto.hasLabelId() != false ? new JsNameRef(this.deserializeName(breakProto.getLabelId())) : null);
                break;
            }
            case 4: {
                continueProto = proto.getContinueStatement();
                v3 = new JsContinue(continueProto.hasLabelId() != false ? new JsNameRef(this.deserializeName(continueProto.getLabelId())) : null);
                break;
            }
            case 5: {
                v3 = new JsDebugger();
                break;
            }
            case 6: {
                expressionProto = proto.getExpression();
                v5 = expressionProto.getExpression();
                Intrinsics.checkExpressionValueIsNotNull(v5, "expressionProto.expression");
                it = var3_17 = new JsExpressionStatement(this.deserialize(v5));
                if (expressionProto.hasExportedTagId()) {
                    MetadataProperties.setExportedTag(it, this.deserializeString(expressionProto.getExportedTagId()));
                }
                v3 = var3_17;
                break;
            }
            case 7: {
                v6 = proto.getVars();
                Intrinsics.checkExpressionValueIsNotNull(v6, "proto.vars");
                v3 = this.deserializeVars(v6);
                break;
            }
            case 8: {
                blockProto = proto.getBlock();
                block = new JsBlock();
                it = block.getStatements();
                var6_34 = $receiver$iv = (Iterable)blockProto.getStatementList();
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
                for (T item$iv$iv : $receiver$iv$iv) {
                    var10_47 = (JsAstProtoBuf.Statement)item$iv$iv;
                    var11_49 = destination$iv$iv;
                    v7 = it;
                    Intrinsics.checkExpressionValueIsNotNull(v7, "it");
                    var12_51 = this.deserialize((JsAstProtoBuf.Statement)v7);
                    var11_49.add(var12_51);
                }
                $receiver$iv = (List)destination$iv$iv;
                CollectionsKt.addAll(it, $receiver$iv);
                v3 = block;
                break;
            }
            case 9: {
                v8 = proto.getGlobalBlock();
                Intrinsics.checkExpressionValueIsNotNull(v8, "proto.globalBlock");
                v3 = this.deserializeGlobalBlock(v8);
                break;
            }
            case 10: {
                labelProto = proto.getLabel();
                v9 = this.deserializeName(labelProto.getNameId());
                v10 = labelProto.getInnerStatement();
                Intrinsics.checkExpressionValueIsNotNull(v10, "labelProto.innerStatement");
                v3 = new JsLabel(v9, this.deserialize(v10));
                break;
            }
            case 11: {
                ifProto = proto.getIfStatement();
                v11 = ifProto.getCondition();
                Intrinsics.checkExpressionValueIsNotNull(v11, "ifProto.condition");
                v12 = this.deserialize(v11);
                v13 = ifProto.getThenStatement();
                Intrinsics.checkExpressionValueIsNotNull(v13, "ifProto.thenStatement");
                v14 = this.deserialize(v13);
                if (ifProto.hasElseStatement()) {
                    v15 = ifProto.getElseStatement();
                    Intrinsics.checkExpressionValueIsNotNull(v15, "ifProto.elseStatement");
                    v16 = this.deserialize(v15);
                } else {
                    v16 = null;
                }
                v3 = new JsIf(v12, v14, v16);
                break;
            }
            case 12: {
                switchProto = proto.getSwitchStatement();
                v17 = switchProto.getExpression();
                Intrinsics.checkExpressionValueIsNotNull(v17, "switchProto.expression");
                block = switchProto.getEntryList();
                var13_53 = this.deserialize(v17);
                var12_52 = v18;
                var11_50 = v18;
                it = $receiver$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
                for (T item$iv$iv : $receiver$iv$iv) {
                    var8_44 = (JsAstProtoBuf.SwitchEntry)item$iv$iv;
                    var14_54 = destination$iv$iv;
                    if (entryProto.hasLabel()) {
                        var9_46 = new JsCase();
                        $receiver = var9_46;
                        v19 = entryProto.getLabel();
                        Intrinsics.checkExpressionValueIsNotNull(v19, "entryProto.label");
                        $receiver.setCaseExpression(this.deserialize(v19));
                        v20 = (JsSwitchMember)var9_46;
                    } else {
                        v20 = new JsDefault();
                    }
                    member = v20;
                    var9_46 = member.getStatements();
                    $i$a$1$apply = $receiver$iv = (Iterable)entryProto.getStatementList();
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
                    for (T item$iv$iv : $receiver$iv$iv) {
                        var20_60 = (JsAstProtoBuf.Statement)item$iv$iv;
                        var21_61 = destination$iv$iv;
                        v21 = it;
                        Intrinsics.checkExpressionValueIsNotNull(v21, "it");
                        var22_62 = this.deserialize((JsAstProtoBuf.Statement)v21);
                        var21_61.add(var22_62);
                    }
                    var10_48 = (List)destination$iv$iv;
                    CollectionsKt.addAll(var9_46, var10_48);
                    var23_63 = member;
                    var14_54.add(var23_63);
                }
                var14_54 = (List)destination$iv$iv;
                var12_52(var13_53, (List<JsSwitchMember>)var14_54);
                v3 = var11_50;
                break;
            }
            case 13: {
                whileProto = proto.getWhileStatement();
                v22 = whileProto.getCondition();
                Intrinsics.checkExpressionValueIsNotNull(v22, "whileProto.condition");
                v23 = this.deserialize(v22);
                v24 = whileProto.getBody();
                Intrinsics.checkExpressionValueIsNotNull(v24, "whileProto.body");
                v3 = new JsWhile(v23, this.deserialize(v24));
                break;
            }
            case 14: {
                doWhileProto = proto.getDoWhileStatement();
                v25 = doWhileProto.getCondition();
                Intrinsics.checkExpressionValueIsNotNull(v25, "doWhileProto.condition");
                v26 = this.deserialize(v25);
                v27 = doWhileProto.getBody();
                Intrinsics.checkExpressionValueIsNotNull(v27, "doWhileProto.body");
                v3 = new JsDoWhile(v26, this.deserialize(v27));
                break;
            }
            case 15: {
                forProto = proto.getForStatement();
                if (forProto.hasVariables()) {
                    v28 = forProto.getVariables();
                    Intrinsics.checkExpressionValueIsNotNull(v28, "forProto.variables");
                    v29 = this.deserializeVars(v28);
                } else {
                    v29 = initVars = null;
                }
                if (forProto.hasExpression()) {
                    v30 = forProto.getExpression();
                    Intrinsics.checkExpressionValueIsNotNull(v30, "forProto.expression");
                    v31 = this.deserialize(v30);
                } else {
                    v31 = initExpr = null;
                }
                if (forProto.hasCondition()) {
                    v32 = forProto.getCondition();
                    Intrinsics.checkExpressionValueIsNotNull(v32, "forProto.condition");
                    v33 = this.deserialize(v32);
                } else {
                    v33 = condition = null;
                }
                if (forProto.hasIncrement()) {
                    v34 = forProto.getIncrement();
                    Intrinsics.checkExpressionValueIsNotNull(v34, "forProto.increment");
                    v35 = this.deserialize(v34);
                } else {
                    v35 = null;
                }
                increment = v35;
                v36 = forProto.getBody();
                Intrinsics.checkExpressionValueIsNotNull(v36, "forProto.body");
                body = this.deserialize(v36);
                if (initVars != null) {
                    v37 = new JsFor(initVars, condition, increment, body);
                } else {
                    v38 = initExpr;
                    if (v38 == null) {
                        Intrinsics.throwNpe();
                    }
                    v37 = new JsFor(v38, condition, increment, body);
                }
                v3 = v37;
                break;
            }
            case 16: {
                forInProto = proto.getForInStatement();
                v39 = iterName = forInProto.hasNameId() != false ? this.deserializeName(forInProto.getNameId()) : null;
                if (forInProto.hasExpression()) {
                    v40 = forInProto.getExpression();
                    Intrinsics.checkExpressionValueIsNotNull(v40, "forInProto.expression");
                    v41 = this.deserialize(v40);
                } else {
                    v41 = null;
                }
                iterExpr = v41;
                v42 = forInProto.getIterable();
                Intrinsics.checkExpressionValueIsNotNull(v42, "forInProto.iterable");
                iterable = this.deserialize(v42);
                v43 = forInProto.getBody();
                Intrinsics.checkExpressionValueIsNotNull(v43, "forInProto.body");
                body = this.deserialize(v43);
                v3 = new JsForIn(iterName, iterExpr, iterable, body);
                break;
            }
            case 17: {
                tryProto = proto.getTryStatement();
                v44 = tryProto.getTryBlock();
                Intrinsics.checkExpressionValueIsNotNull(v44, "tryProto.tryBlock");
                v45 = this.deserialize(v44);
                if (v45 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.js.backend.ast.JsBlock");
                }
                tryBlock = (JsBlock)v45;
                if (tryProto.hasCatchBlock()) {
                    catchProto = tryProto.getCatchBlock();
                    $receiver = var6_38 = new JsCatch(this.deserializeName(catchProto.getParameter().getNameId()));
                    v46 = catchProto.getBody();
                    Intrinsics.checkExpressionValueIsNotNull(v46, "catchProto.body");
                    v47 = this.deserialize(v46);
                    if (v47 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.js.backend.ast.JsBlock");
                    }
                    $receiver.setBody((JsBlock)v47);
                    v48 = var6_38;
                } else {
                    v48 = catchBlock = null;
                }
                if (tryProto.hasFinallyBlock()) {
                    v49 = tryProto.getFinallyBlock();
                    Intrinsics.checkExpressionValueIsNotNull(v49, "tryProto.finallyBlock");
                    v50 = this.deserialize(v49);
                    if (v50 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.js.backend.ast.JsBlock");
                    }
                    v51 = (JsBlock)v50;
                } else {
                    v51 = null;
                }
                finallyBlock = v51;
                v3 = new JsTry(tryBlock, catchBlock, finallyBlock);
                break;
            }
            case 18: {
                v3 = JsEmpty.INSTANCE;
                break;
            }
            case 19: lbl-1000:
            // 2 sources

            {
                var2_16 = "Statement not set";
                throw (Throwable)new IllegalStateException(var2_16.toString());
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return v3;
    }

    private final JsExpression deserialize(JsAstProtoBuf.Expression proto) {
        JsExpression expression2 = (JsExpression)this.withLocation(proto.hasFileId() ? Integer.valueOf(proto.getFileId()) : null, proto.hasLocation() ? proto.getLocation() : null, (Function0)new Function0<JsExpression>(this, proto){
            final /* synthetic */ JsAstDeserializer this$0;
            final /* synthetic */ JsAstProtoBuf.Expression $proto;

            @NotNull
            public final JsExpression invoke() {
                return JsAstDeserializer.access$deserializeNoMetadata(this.this$0, this.$proto);
            }
            {
                this.this$0 = jsAstDeserializer;
                this.$proto = expression2;
                super(0);
            }
        });
        MetadataProperties.setSynthetic(expression2, proto.getSynthetic());
        HasMetadata hasMetadata = expression2;
        JsAstProtoBuf.SideEffects sideEffects = proto.getSideEffects();
        Intrinsics.checkExpressionValueIsNotNull(sideEffects, "proto.sideEffects");
        MetadataProperties.setSideEffects(hasMetadata, this.map(sideEffects));
        return expression2;
    }

    /*
     * Unable to fully structure code
     */
    private final JsExpression deserializeNoMetadata(JsAstProtoBuf.Expression proto) {
        v0 = proto.getExpressionCase();
        if (v0 == null) ** GOTO lbl-1000
        switch (JsAstDeserializer$WhenMappings.$EnumSwitchMapping$1[v0.ordinal()]) {
            case 1: {
                v1 = JsLiteral.THIS;
                Intrinsics.checkExpressionValueIsNotNull(v1, "JsLiteral.THIS");
                v2 = v1;
                break;
            }
            case 2: {
                v3 = JsLiteral.NULL;
                Intrinsics.checkExpressionValueIsNotNull(v3, "JsLiteral.NULL");
                v2 = v3;
                break;
            }
            case 3: {
                v4 = JsLiteral.TRUE;
                Intrinsics.checkExpressionValueIsNotNull(v4, "JsLiteral.TRUE");
                v2 = v4;
                break;
            }
            case 4: {
                v5 = JsLiteral.FALSE;
                Intrinsics.checkExpressionValueIsNotNull(v5, "JsLiteral.FALSE");
                v2 = v5;
                break;
            }
            case 5: {
                v6 = this.program.getStringLiteral(this.deserializeString(proto.getStringLiteral()));
                Intrinsics.checkExpressionValueIsNotNull(v6, "program.getStringLiteral\u2026ing(proto.stringLiteral))");
                v2 = v6;
                break;
            }
            case 6: {
                v7 = this.program.getNumberLiteral(proto.getIntLiteral());
                Intrinsics.checkExpressionValueIsNotNull(v7, "program.getNumberLiteral(proto.intLiteral)");
                v2 = v7;
                break;
            }
            case 7: {
                v8 = this.program.getNumberLiteral(proto.getDoubleLiteral());
                Intrinsics.checkExpressionValueIsNotNull(v8, "program.getNumberLiteral(proto.doubleLiteral)");
                v2 = v8;
                break;
            }
            case 8: {
                v2 = new JsNameRef(this.deserializeName(proto.getSimpleNameReference()));
                break;
            }
            case 9: {
                regExpProto = proto.getRegExpLiteral();
                $receiver = var3_16 = new JsRegExp();
                $receiver.setPattern(this.deserializeString(regExpProto.getPatternStringId()));
                if (regExpProto.hasFlagsStringId()) {
                    $receiver.setFlags(this.deserializeString(regExpProto.getFlagsStringId()));
                }
                v2 = var3_16;
                break;
            }
            case 10: {
                arrayProto = proto.getArrayLiteral();
                var3_17 = arrayProto.getElementList();
                var5_36 = v9;
                var6_41 = v9;
                $receiver = $receiver$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
                for (T item$iv$iv : $receiver$iv$iv) {
                    var10_66 = (JsAstProtoBuf.Expression)item$iv$iv;
                    var11_72 = destination$iv$iv;
                    v10 = it;
                    Intrinsics.checkExpressionValueIsNotNull(v10, "it");
                    var12_77 = this.deserialize((JsAstProtoBuf.Expression)v10);
                    var11_72.add(var12_77);
                }
                var11_72 = (List)destination$iv$iv;
                var5_36((List<JsExpression>)var11_72);
                v2 = var6_41;
                break;
            }
            case 11: {
                objectProto = proto.getObjectLiteral();
                $receiver$iv = objectProto.getEntryList();
                var5_37 = v11;
                var6_42 = v11;
                $receiver$iv$iv = $receiver$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
                for (T item$iv$iv : $receiver$iv$iv) {
                    it = (JsAstProtoBuf.ObjectLiteralEntry)item$iv$iv;
                    var11_73 = destination$iv$iv;
                    v12 = entryProto.getKey();
                    Intrinsics.checkExpressionValueIsNotNull(v12, "entryProto.key");
                    v13 = this.deserialize(v12);
                    v14 = entryProto.getValue();
                    Intrinsics.checkExpressionValueIsNotNull(v14, "entryProto.value");
                    var12_78 = new JsPropertyInitializer(v13, this.deserialize(v14));
                    var11_73.add(var12_78);
                }
                var11_73 = (List)destination$iv$iv;
                var5_37((List<JsPropertyInitializer>)var11_73, objectProto.getMultiline());
                v2 = var6_42;
                break;
            }
            case 12: {
                functionProto = proto.getFunction();
                v15 = this.scope;
                v16 = functionProto.getBody();
                Intrinsics.checkExpressionValueIsNotNull(v16, "functionProto.body");
                v17 = this.deserialize(v16);
                if (v17 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.js.backend.ast.JsBlock");
                }
                $receiver = $receiver$iv = new JsFunction(v15, (JsBlock)v17, "");
                destination$iv$iv = $receiver.getParameters();
                item$iv$iv = $receiver$iv = (Iterable)functionProto.getParameterList();
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
                for (T item$iv$iv : $receiver$iv$iv) {
                    $i$f$map = (JsAstProtoBuf.Parameter)item$iv$iv;
                    var16_87 = destination$iv$iv;
                    v18 = it;
                    Intrinsics.checkExpressionValueIsNotNull(v18, "it");
                    var17_89 = this.deserializeParameter((JsAstProtoBuf.Parameter)v18);
                    var16_87.add(var17_89);
                }
                $receiver$iv = (List)destination$iv$iv;
                CollectionsKt.addAll(destination$iv$iv, $receiver$iv);
                if (functionProto.hasNameId()) {
                    $receiver.setName(this.deserializeName(functionProto.getNameId()));
                }
                MetadataProperties.setLocal($receiver, functionProto.getLocal());
                v2 = $receiver$iv;
                break;
            }
            case 13: {
                docCommentProto = proto.getDocComment();
                $receiver$iv = docCommentProto.getTagList();
                var5_38 = v19;
                var6_43 = v19;
                capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10)), 16);
                destination$iv$iv = $receiver$iv;
                destination$iv$iv = new LinkedHashMap<K, V>(capacity$iv);
                for (T element$iv$iv : $receiver$iv$iv) {
                    $i$a$6$map = destination$iv$iv;
                    tagProto = (JsAstProtoBuf.DocCommentTag)element$iv$iv;
                    name = this.deserializeString(tagProto.getNameId());
                    if (tagProto.hasExpression()) {
                        v20 = tagProto.getExpression();
                        Intrinsics.checkExpressionValueIsNotNull(v20, "tagProto.expression");
                        v21 = this.deserialize(v20);
                    } else {
                        v21 = this.deserializeString(tagProto.getValueStringId());
                    }
                    value = v21;
                    var18_90 = TuplesKt.to(name, value);
                    $i$a$6$map.put(var18_90.getFirst(), var18_90.getSecond());
                }
                var11_74 = destination$iv$iv;
                var5_38(var11_74);
                v2 = var6_43;
                break;
            }
            case 14: {
                binaryProto = proto.getBinary();
                v22 = binaryProto.getType();
                Intrinsics.checkExpressionValueIsNotNull(v22, "binaryProto.type");
                v23 = this.map(v22);
                v24 = binaryProto.getLeft();
                Intrinsics.checkExpressionValueIsNotNull(v24, "binaryProto.left");
                v25 = this.deserialize(v24);
                v26 = binaryProto.getRight();
                Intrinsics.checkExpressionValueIsNotNull(v26, "binaryProto.right");
                v2 = new JsBinaryOperation(v23, v25, this.deserialize(v26));
                break;
            }
            case 15: {
                unaryProto = proto.getUnary();
                v27 = unaryProto.getType();
                Intrinsics.checkExpressionValueIsNotNull(v27, "unaryProto.type");
                type = this.map(v27);
                v28 = unaryProto.getOperand();
                Intrinsics.checkExpressionValueIsNotNull(v28, "unaryProto.operand");
                operand = this.deserialize(v28);
                v2 = unaryProto.getPostfix() != false ? (JsUnaryOperation)new JsPostfixOperation(type, operand) : (JsUnaryOperation)new JsPrefixOperation(type, operand);
                break;
            }
            case 16: {
                conditionalProto = proto.getConditional();
                v29 = conditionalProto.getTestExpression();
                Intrinsics.checkExpressionValueIsNotNull(v29, "conditionalProto.testExpression");
                v30 = this.deserialize(v29);
                v31 = conditionalProto.getThenExpression();
                Intrinsics.checkExpressionValueIsNotNull(v31, "conditionalProto.thenExpression");
                v32 = this.deserialize(v31);
                v33 = conditionalProto.getElseExpression();
                Intrinsics.checkExpressionValueIsNotNull(v33, "conditionalProto.elseExpression");
                v2 = new JsConditional(v30, v32, this.deserialize(v33));
                break;
            }
            case 17: {
                arrayAccessProto = proto.getArrayAccess();
                v34 = arrayAccessProto.getArray();
                Intrinsics.checkExpressionValueIsNotNull(v34, "arrayAccessProto.array");
                v35 = this.deserialize(v34);
                v36 = arrayAccessProto.getIndex();
                Intrinsics.checkExpressionValueIsNotNull(v36, "arrayAccessProto.index");
                v2 = new JsArrayAccess(v35, this.deserialize(v36));
                break;
            }
            case 18: {
                nameRefProto = proto.getNameReference();
                if (nameRefProto.hasQualifier()) {
                    v37 = nameRefProto.getQualifier();
                    Intrinsics.checkExpressionValueIsNotNull(v37, "nameRefProto.qualifier");
                    v38 = this.deserialize(v37);
                } else {
                    v38 = null;
                }
                qualifier = v38;
                $receiver = operand = new JsNameRef(this.deserializeName(nameRefProto.getNameId()), qualifier);
                if (nameRefProto.hasInlineStrategy()) {
                    v39 = nameRefProto.getInlineStrategy();
                    Intrinsics.checkExpressionValueIsNotNull(v39, "nameRefProto.inlineStrategy");
                    MetadataProperties.setInlineStrategy($receiver, this.map(v39));
                }
                v2 = operand;
                break;
            }
            case 19: {
                propertyRefProto = proto.getPropertyReference();
                if (propertyRefProto.hasQualifier()) {
                    v40 = propertyRefProto.getQualifier();
                    Intrinsics.checkExpressionValueIsNotNull(v40, "propertyRefProto.qualifier");
                    v41 = this.deserialize(v40);
                } else {
                    v41 = null;
                }
                qualifier = v41;
                $receiver = operand = new JsNameRef(this.deserializeString(propertyRefProto.getStringId()), qualifier);
                if (propertyRefProto.hasInlineStrategy()) {
                    v42 = propertyRefProto.getInlineStrategy();
                    Intrinsics.checkExpressionValueIsNotNull(v42, "propertyRefProto.inlineStrategy");
                    MetadataProperties.setInlineStrategy($receiver, this.map(v42));
                }
                v2 = operand;
                break;
            }
            case 20: {
                invocationProto = proto.getInvocation();
                v43 = invocationProto.getQualifier();
                Intrinsics.checkExpressionValueIsNotNull(v43, "invocationProto.qualifier");
                qualifier = invocationProto.getArgumentList();
                var11_75 = this.deserialize(v43);
                var5_39 = v44;
                var6_44 = v44;
                operand = $receiver$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
                for (T item$iv$iv : $receiver$iv$iv) {
                    element$iv$iv = (JsAstProtoBuf.Expression)item$iv$iv;
                    var12_79 = destination$iv$iv;
                    v45 = it;
                    Intrinsics.checkExpressionValueIsNotNull(v45, "it");
                    var19_91 = this.deserialize((JsAstProtoBuf.Expression)v45);
                    var12_79.add(var19_91);
                }
                var12_79 = (List)destination$iv$iv;
                var5_39(var11_75, (List<? extends JsExpression>)var12_79);
                $receiver = $receiver$iv = var6_44;
                if (invocationProto.hasInlineStrategy()) {
                    v46 = invocationProto.getInlineStrategy();
                    Intrinsics.checkExpressionValueIsNotNull(v46, "invocationProto.inlineStrategy");
                    MetadataProperties.setInlineStrategy($receiver, this.map(v46));
                }
                v2 = $receiver$iv;
                break;
            }
            case 21: {
                instantiationProto = proto.getInstantiation();
                v47 = instantiationProto.getQualifier();
                Intrinsics.checkExpressionValueIsNotNull(v47, "instantiationProto.qualifier");
                $receiver$iv = instantiationProto.getArgumentList();
                var11_76 = this.deserialize(v47);
                var5_40 = v48;
                var6_45 = v48;
                $receiver = $receiver$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
                for (T item$iv$iv : $receiver$iv$iv) {
                    it = (JsAstProtoBuf.Expression)item$iv$iv;
                    var12_80 = destination$iv$iv;
                    v49 = it;
                    Intrinsics.checkExpressionValueIsNotNull(v49, "it");
                    var19_92 = this.deserialize(v49);
                    var12_80.add(var19_92);
                }
                var12_80 = (List)destination$iv$iv;
                var5_40(var11_76, (List<? extends JsExpression>)var12_80);
                v2 = var6_45;
                break;
            }
            case 22: lbl-1000:
            // 2 sources

            {
                var2_15 = "Unknown expression";
                throw (Throwable)new IllegalStateException(var2_15.toString());
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return v2;
    }

    private final JsVars deserializeVars(JsAstProtoBuf.Vars proto) {
        JsVars vars = new JsVars(proto.getMultiline());
        for (JsAstProtoBuf.VarDeclaration declProto : proto.getDeclarationList()) {
            JsExpression jsExpression;
            if (declProto.hasInitialValue()) {
                JsAstProtoBuf.Expression expression2 = declProto.getInitialValue();
                Intrinsics.checkExpressionValueIsNotNull(expression2, "declProto.initialValue");
                jsExpression = this.deserialize(expression2);
            } else {
                jsExpression = null;
            }
            JsExpression initialValue = jsExpression;
            Collection collection = vars.getVars();
            JsVars.JsVar jsVar = new JsVars.JsVar(this.deserializeName(declProto.getNameId()), initialValue);
            collection.add(jsVar);
        }
        if (proto.hasExportedPackageId()) {
            MetadataProperties.setExportedPackage(vars, this.deserializeString(proto.getExportedPackageId()));
        }
        return vars;
    }

    /*
     * WARNING - void declaration
     */
    private final JsGlobalBlock deserializeGlobalBlock(JsAstProtoBuf.GlobalBlock proto) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        JsGlobalBlock jsGlobalBlock;
        JsGlobalBlock $receiver = jsGlobalBlock = new JsGlobalBlock();
        Collection collection = $receiver.getStatements();
        Iterable iterable = $receiver$iv = (Iterable)proto.getStatementList();
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            JsAstProtoBuf.Statement statement2 = (JsAstProtoBuf.Statement)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            void v0 = it;
            Intrinsics.checkExpressionValueIsNotNull(v0, "it");
            JsStatement jsStatement = this.deserialize((JsAstProtoBuf.Statement)v0);
            collection2.add(jsStatement);
        }
        Iterable iterable2 = (List)destination$iv$iv;
        CollectionsKt.addAll(collection, iterable2);
        return jsGlobalBlock;
    }

    private final JsParameter deserializeParameter(JsAstProtoBuf.Parameter proto) {
        JsParameter jsParameter;
        JsParameter $receiver = jsParameter = new JsParameter(this.deserializeName(proto.getNameId()));
        MetadataProperties.setHasDefaultValue($receiver, proto.getHasDefaultValue());
        return jsParameter;
    }

    private final JsName deserializeName(int id) {
        JsName jsName = this.nameCache.get(id);
        if (jsName == null) {
            JsAstDeserializer jsAstDeserializer;
            JsAstDeserializer it = jsAstDeserializer = this;
            JsAstProtoBuf.Name nameProto = this.nameTable.get(id);
            String identifier = this.deserializeString(nameProto.getIdentifier());
            JsName name = nameProto.getTemporary() ? JsScope.declareTemporaryName(identifier) : JsDynamicScope.INSTANCE.declareName(identifier);
            this.nameCache.set(id, name);
            JsName jsName2 = name;
            jsName = jsName2;
            Intrinsics.checkExpressionValueIsNotNull(jsName2, "let {\n            val na\u2026           name\n        }");
        }
        return jsName;
    }

    private final String deserializeString(int id) {
        return this.stringTable.get(id);
    }

    private final JsBinaryOperator map(JsAstProtoBuf.BinaryOperation.Type op) {
        JsBinaryOperator jsBinaryOperator;
        switch (JsAstDeserializer$WhenMappings.$EnumSwitchMapping$2[op.ordinal()]) {
            case 1: {
                jsBinaryOperator = JsBinaryOperator.MUL;
                break;
            }
            case 2: {
                jsBinaryOperator = JsBinaryOperator.DIV;
                break;
            }
            case 3: {
                jsBinaryOperator = JsBinaryOperator.MOD;
                break;
            }
            case 4: {
                jsBinaryOperator = JsBinaryOperator.ADD;
                break;
            }
            case 5: {
                jsBinaryOperator = JsBinaryOperator.SUB;
                break;
            }
            case 6: {
                jsBinaryOperator = JsBinaryOperator.SHL;
                break;
            }
            case 7: {
                jsBinaryOperator = JsBinaryOperator.SHR;
                break;
            }
            case 8: {
                jsBinaryOperator = JsBinaryOperator.SHRU;
                break;
            }
            case 9: {
                jsBinaryOperator = JsBinaryOperator.LT;
                break;
            }
            case 10: {
                jsBinaryOperator = JsBinaryOperator.LTE;
                break;
            }
            case 11: {
                jsBinaryOperator = JsBinaryOperator.GT;
                break;
            }
            case 12: {
                jsBinaryOperator = JsBinaryOperator.GTE;
                break;
            }
            case 13: {
                jsBinaryOperator = JsBinaryOperator.INSTANCEOF;
                break;
            }
            case 14: {
                jsBinaryOperator = JsBinaryOperator.INOP;
                break;
            }
            case 15: {
                jsBinaryOperator = JsBinaryOperator.EQ;
                break;
            }
            case 16: {
                jsBinaryOperator = JsBinaryOperator.NEQ;
                break;
            }
            case 17: {
                jsBinaryOperator = JsBinaryOperator.REF_EQ;
                break;
            }
            case 18: {
                jsBinaryOperator = JsBinaryOperator.REF_NEQ;
                break;
            }
            case 19: {
                jsBinaryOperator = JsBinaryOperator.BIT_AND;
                break;
            }
            case 20: {
                jsBinaryOperator = JsBinaryOperator.BIT_XOR;
                break;
            }
            case 21: {
                jsBinaryOperator = JsBinaryOperator.BIT_OR;
                break;
            }
            case 22: {
                jsBinaryOperator = JsBinaryOperator.AND;
                break;
            }
            case 23: {
                jsBinaryOperator = JsBinaryOperator.OR;
                break;
            }
            case 24: {
                jsBinaryOperator = JsBinaryOperator.ASG;
                break;
            }
            case 25: {
                jsBinaryOperator = JsBinaryOperator.ASG_ADD;
                break;
            }
            case 26: {
                jsBinaryOperator = JsBinaryOperator.ASG_SUB;
                break;
            }
            case 27: {
                jsBinaryOperator = JsBinaryOperator.ASG_MUL;
                break;
            }
            case 28: {
                jsBinaryOperator = JsBinaryOperator.ASG_DIV;
                break;
            }
            case 29: {
                jsBinaryOperator = JsBinaryOperator.ASG_MOD;
                break;
            }
            case 30: {
                jsBinaryOperator = JsBinaryOperator.ASG_SHL;
                break;
            }
            case 31: {
                jsBinaryOperator = JsBinaryOperator.ASG_SHR;
                break;
            }
            case 32: {
                jsBinaryOperator = JsBinaryOperator.ASG_SHRU;
                break;
            }
            case 33: {
                jsBinaryOperator = JsBinaryOperator.ASG_BIT_AND;
                break;
            }
            case 34: {
                jsBinaryOperator = JsBinaryOperator.ASG_BIT_OR;
                break;
            }
            case 35: {
                jsBinaryOperator = JsBinaryOperator.ASG_BIT_XOR;
                break;
            }
            case 36: {
                jsBinaryOperator = JsBinaryOperator.COMMA;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return jsBinaryOperator;
    }

    private final JsUnaryOperator map(JsAstProtoBuf.UnaryOperation.Type op) {
        JsUnaryOperator jsUnaryOperator;
        switch (JsAstDeserializer$WhenMappings.$EnumSwitchMapping$3[op.ordinal()]) {
            case 1: {
                jsUnaryOperator = JsUnaryOperator.BIT_NOT;
                break;
            }
            case 2: {
                jsUnaryOperator = JsUnaryOperator.DEC;
                break;
            }
            case 3: {
                jsUnaryOperator = JsUnaryOperator.DELETE;
                break;
            }
            case 4: {
                jsUnaryOperator = JsUnaryOperator.INC;
                break;
            }
            case 5: {
                jsUnaryOperator = JsUnaryOperator.NEG;
                break;
            }
            case 6: {
                jsUnaryOperator = JsUnaryOperator.POS;
                break;
            }
            case 7: {
                jsUnaryOperator = JsUnaryOperator.NOT;
                break;
            }
            case 8: {
                jsUnaryOperator = JsUnaryOperator.TYPEOF;
                break;
            }
            case 9: {
                jsUnaryOperator = JsUnaryOperator.VOID;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return jsUnaryOperator;
    }

    private final SideEffectKind map(JsAstProtoBuf.SideEffects sideEffects) {
        SideEffectKind sideEffectKind;
        switch (JsAstDeserializer$WhenMappings.$EnumSwitchMapping$4[sideEffects.ordinal()]) {
            case 1: {
                sideEffectKind = SideEffectKind.AFFECTS_STATE;
                break;
            }
            case 2: {
                sideEffectKind = SideEffectKind.DEPENDS_ON_STATE;
                break;
            }
            case 3: {
                sideEffectKind = SideEffectKind.PURE;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return sideEffectKind;
    }

    private final InlineStrategy map(JsAstProtoBuf.InlineStrategy inlineStrategy) {
        InlineStrategy inlineStrategy2;
        switch (JsAstDeserializer$WhenMappings.$EnumSwitchMapping$5[inlineStrategy.ordinal()]) {
            case 1: {
                inlineStrategy2 = InlineStrategy.AS_FUNCTION;
                break;
            }
            case 2: {
                inlineStrategy2 = InlineStrategy.IN_PLACE;
                break;
            }
            case 3: {
                inlineStrategy2 = InlineStrategy.NOT_INLINE;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return inlineStrategy2;
    }

    private final <T extends JsNode> T withLocation(Integer fileId, JsAstProtoBuf.Location location2, Function0<? extends T> action) {
        boolean shouldUpdateFile;
        String deserializedFile;
        String string;
        String string2;
        Integer n = fileId;
        if (n != null) {
            Integer n2 = n;
            int it = ((Number)n2).intValue();
            string2 = this.deserializeString(it);
        } else {
            string2 = null;
        }
        if ((string = (deserializedFile = string2)) == null) {
            string = this.fileStack.peek();
        }
        String file2 = string;
        JsLocation deserializedLocation = file2 != null && location2 != null ? new JsLocation(file2, location2.getStartLine(), location2.getStartChar()) : null;
        boolean bl = shouldUpdateFile = location2 != null && deserializedFile != null && Intrinsics.areEqual(deserializedFile, this.fileStack.peek()) ^ true;
        if (shouldUpdateFile) {
            this.fileStack.push(deserializedFile);
        }
        JsNode node = (JsNode)action.invoke();
        if (!(deserializedLocation == null || node instanceof JsLiteral.JsBooleanLiteral || node instanceof JsLiteral.JsThisRef || node instanceof JsNullLiteral)) {
            node.setSource(deserializedLocation);
        }
        if (shouldUpdateFile) {
            this.fileStack.pop();
        }
        return (T)node;
    }

    public JsAstDeserializer(@NotNull JsProgram program) {
        List list2;
        Intrinsics.checkParameterIsNotNull(program, "program");
        this.program = program;
        this.scope = new JsRootScope(this.program);
        JsAstDeserializer jsAstDeserializer = this;
        jsAstDeserializer.stringTable = list2 = (List)new ArrayList();
        jsAstDeserializer = this;
        jsAstDeserializer.nameTable = list2 = (List)new ArrayList();
        jsAstDeserializer = this;
        jsAstDeserializer.nameCache = list2 = (List)new ArrayList();
        this.fileStack = new ArrayDeque();
    }

    @NotNull
    public static final /* synthetic */ JsStatement access$deserializeNoMetadata(JsAstDeserializer $this, @NotNull JsAstProtoBuf.Statement proto) {
        return $this.deserializeNoMetadata(proto);
    }

    @NotNull
    public static final /* synthetic */ JsExpression access$deserializeNoMetadata(JsAstDeserializer $this, @NotNull JsAstProtoBuf.Expression proto) {
        return $this.deserializeNoMetadata(proto);
    }
}

