/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization.jvm;

import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.platform.JavaToKotlinClassMap;
import org.jetbrains.kotlin.resolve.jvm.JvmPrimitiveType;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/serialization/jvm/ClassMapperLite;", "", "()V", "mapClass", "", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "kotlin-compiler"})
public final class ClassMapperLite {
    public static final ClassMapperLite INSTANCE;

    @JvmStatic
    @NotNull
    public static final String mapClass(@NotNull ClassId classId) {
        Intrinsics.checkParameterIsNotNull(classId, "classId");
        String internalName = StringsKt.replace$default(classId.asString(), '.', '$', false, 4, null);
        String simpleName2 = StringsKt.removePrefix(internalName, (CharSequence)"kotlin/");
        if (Intrinsics.areEqual(simpleName2, internalName) ^ true) {
            JvmPrimitiveType[] jvmPrimitiveTypeArray = JvmPrimitiveType.values();
            for (int i = 0; i < jvmPrimitiveTypeArray.length; ++i) {
                JvmPrimitiveType jvmPrimitive = jvmPrimitiveTypeArray[i];
                PrimitiveType primitiveType = jvmPrimitive.getPrimitiveType();
                if (Intrinsics.areEqual(simpleName2, primitiveType.getTypeName().asString())) {
                    String string = jvmPrimitive.getDesc();
                    Intrinsics.checkExpressionValueIsNotNull(string, "jvmPrimitive.desc");
                    return string;
                }
                if (!Intrinsics.areEqual(simpleName2, primitiveType.getArrayTypeName().asString())) continue;
                return "[" + jvmPrimitive.getDesc();
            }
            if (Intrinsics.areEqual(simpleName2, KotlinBuiltIns.FQ_NAMES.unit.shortName().asString())) {
                return "V";
            }
        }
        FqNameUnsafe fqNameUnsafe = classId.asSingleFqName().toUnsafe();
        Intrinsics.checkExpressionValueIsNotNull(fqNameUnsafe, "classId.asSingleFqName().toUnsafe()");
        ClassId javaClassId = JavaToKotlinClassMap.INSTANCE.mapKotlinToJava(fqNameUnsafe);
        if (javaClassId != null) {
            return "L" + StringsKt.replace$default(javaClassId.asString(), '.', '$', false, 4, null) + ";";
        }
        return "L" + internalName + ";";
    }

    private ClassMapperLite() {
        INSTANCE = this;
    }

    static {
        new ClassMapperLite();
    }
}

