/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.play.internal.run;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.jar.JarFile;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.Cast;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.internal.reflect.DirectInstantiator;
import org.gradle.play.internal.run.VersionedPlayRunAdapter;
import org.gradle.scala.internal.reflect.ScalaMethod;
import org.gradle.scala.internal.reflect.ScalaReflectionUtil;

public abstract class DefaultVersionedPlayRunAdapter
implements VersionedPlayRunAdapter,
Serializable {
    public static final String PLAY_EXCEPTION_CLASSNAME = "play.api.PlayException";
    private static final Logger LOGGER = Logging.getLogger(DefaultVersionedPlayRunAdapter.class);
    private final AtomicBoolean reload = new AtomicBoolean();
    private final AtomicBoolean ready = new AtomicBoolean(true);
    private final AtomicReference<ClassLoader> currentClassloader = new AtomicReference();
    private final Queue<SoftReference<Closeable>> loadersToClose = new ConcurrentLinkedQueue<SoftReference<Closeable>>();
    private volatile Throwable buildFailure;

    protected abstract Class<?> getBuildLinkClass(ClassLoader var1) throws ClassNotFoundException;

    protected abstract Class<?> getDocHandlerFactoryClass(ClassLoader var1) throws ClassNotFoundException;

    protected abstract Class<?> getBuildDocHandlerClass(ClassLoader var1) throws ClassNotFoundException;

    @Override
    public Object getBuildLink(ClassLoader classLoader, final File projectPath, final File applicationJar, final Iterable<File> changingClasspath, File assetsJar, Iterable<File> assetsDirs) throws ClassNotFoundException {
        final ClassLoader assetsClassLoader = this.createAssetsClassLoader(assetsJar, assetsDirs, classLoader);
        final Class playExceptionClass = (Class)Cast.uncheckedCast(classLoader.loadClass(PLAY_EXCEPTION_CLASSNAME));
        this.buildSuccess();
        return Proxy.newProxyInstance(classLoader, new Class[]{this.getBuildLinkClass(classLoader)}, new InvocationHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.getName().equals("projectPath")) {
                    return projectPath;
                }
                if (method.getName().equals("reload")) {
                    AtomicBoolean atomicBoolean = DefaultVersionedPlayRunAdapter.this.ready;
                    synchronized (atomicBoolean) {
                        while (!DefaultVersionedPlayRunAdapter.this.ready.get()) {
                            DefaultVersionedPlayRunAdapter.this.ready.wait();
                        }
                    }
                    DefaultVersionedPlayRunAdapter.this.closeOldLoaders();
                    if (DefaultVersionedPlayRunAdapter.this.reload.getAndSet(false)) {
                        ClassPath classpath = new DefaultClassPath(new File[]{applicationJar}).plus((ClassPath)new DefaultClassPath(changingClasspath));
                        URLClassLoader currentClassLoader = new URLClassLoader(classpath.getAsURLArray(), assetsClassLoader);
                        DefaultVersionedPlayRunAdapter.this.storeClassLoader(currentClassLoader);
                        return currentClassLoader;
                    }
                    Throwable failure = DefaultVersionedPlayRunAdapter.this.buildFailure;
                    if (failure == null) {
                        return null;
                    }
                    try {
                        return DirectInstantiator.instantiate((Class)playExceptionClass, (Object[])new Object[]{"Gradle Build Failure", failure.getMessage(), failure});
                    }
                    catch (Exception e) {
                        LOGGER.warn("Could not translate " + failure + " to " + DefaultVersionedPlayRunAdapter.PLAY_EXCEPTION_CLASSNAME, (Throwable)e);
                        return failure;
                    }
                }
                if (method.getName().equals("settings")) {
                    return new HashMap();
                }
                return null;
            }
        });
    }

    protected ClassLoader createAssetsClassLoader(File assetsJar, Iterable<File> assetsDirs, ClassLoader classLoader) {
        try {
            return new URLClassLoader(new URL[]{assetsJar.toURI().toURL()}, classLoader);
        }
        catch (MalformedURLException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    private ClassLoader storeClassLoader(ClassLoader classLoader) {
        ClassLoader previous = this.currentClassloader.getAndSet(classLoader);
        if (previous != null && previous instanceof Closeable) {
            this.loadersToClose.add(new SoftReference<Object>(Cast.cast(Closeable.class, (Object)previous)));
        }
        return classLoader;
    }

    private void closeOldLoaders() throws IOException {
        SoftReference<Closeable> ref = this.loadersToClose.poll();
        while (ref != null) {
            Closeable closeable = ref.get();
            if (closeable != null) {
                closeable.close();
            }
            ref.clear();
            ref = this.loadersToClose.poll();
        }
    }

    @Override
    public void buildSuccess() {
        this.reload.set(true);
        this.buildFailure = null;
        this.makeReady(true);
    }

    @Override
    public void buildError(Throwable throwable) {
        this.buildFailure = throwable;
        this.makeReady(true);
    }

    @Override
    public void rebuildInProgress() {
        this.makeReady(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeReady(boolean isReady) {
        AtomicBoolean atomicBoolean = this.ready;
        synchronized (atomicBoolean) {
            this.ready.set(isReady);
            this.ready.notifyAll();
        }
    }

    @Override
    public Iterable<Dependency> getRunsupportClasspathDependencies(String playVersion, String scalaCompatibilityVersion) {
        return null;
    }

    @Override
    public Object getBuildDocHandler(ClassLoader docsClassLoader, Iterable<File> classpath) throws NoSuchMethodException, ClassNotFoundException, IOException, IllegalAccessException {
        Class<?> docHandlerFactoryClass = this.getDocHandlerFactoryClass(docsClassLoader);
        Method docHandlerFactoryMethod = docHandlerFactoryClass.getMethod("fromJar", JarFile.class, String.class);
        JarFile documentationJar = this.findDocumentationJar(classpath);
        try {
            return docHandlerFactoryMethod.invoke(null, documentationJar, "play/docs/content");
        }
        catch (InvocationTargetException e) {
            throw UncheckedException.unwrapAndRethrow((InvocationTargetException)e);
        }
    }

    private JarFile findDocumentationJar(Iterable<File> classpath) throws IOException {
        File docJarFile = null;
        for (File file : classpath) {
            if (!file.getName().startsWith("play-docs")) continue;
            docJarFile = file;
            break;
        }
        return new JarFile(docJarFile);
    }

    @Override
    public void runDevHttpServer(ClassLoader classLoader, ClassLoader docsClassLoader, Object buildLink, Object buildDocHandler, int httpPort) throws ClassNotFoundException {
        ScalaMethod runMethod = ScalaReflectionUtil.scalaMethod(classLoader, "play.core.server.NettyServer", "mainDevHttpMode", this.getBuildLinkClass(classLoader), this.getBuildDocHandlerClass(docsClassLoader), Integer.TYPE);
        runMethod.invoke(buildLink, buildDocHandler, httpPort);
    }
}

