/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.tasks;

import java.io.File;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Incubating;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryVar;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileVar;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.nativeintegration.filesystem.FileSystem;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.nativeplatform.platform.NativePlatform;
import org.gradle.nativeplatform.toolchain.Gcc;
import org.gradle.platform.base.ToolChain;
import org.gradle.util.GFileUtils;

@Incubating
public class InstallExecutable
extends DefaultTask {
    private ToolChain toolChain;
    private NativePlatform platform;
    private final DirectoryVar destinationDir;
    private final RegularFileVar executable;
    private final ConfigurableFileCollection libs = this.getProject().files(new Object[0]);

    public InstallExecutable() {
        this.destinationDir = this.newOutputDirectory();
        this.executable = this.newInputFile();
    }

    @Internal
    public ToolChain getToolChain() {
        return this.toolChain;
    }

    public void setToolChain(ToolChain toolChain) {
        this.toolChain = toolChain;
    }

    @Nested
    public NativePlatform getPlatform() {
        return this.platform;
    }

    public void setPlatform(NativePlatform platform) {
        this.platform = platform;
    }

    @OutputDirectory
    public DirectoryVar getInstallDirectory() {
        return this.destinationDir;
    }

    @Internal
    public File getDestinationDir() {
        return (File)this.destinationDir.getAsFile().getOrNull();
    }

    public void setDestinationDir(File destinationDir) {
        this.destinationDir.set(destinationDir);
    }

    public void setDestinationDir(Provider<? extends Directory> destinationDir) {
        this.destinationDir.set(destinationDir);
    }

    @InputFile
    public RegularFileVar getSourceFile() {
        return this.executable;
    }

    @Internal
    public File getExecutable() {
        return (File)this.executable.getAsFile().getOrNull();
    }

    public void setExecutable(File executable) {
        this.executable.set(executable);
    }

    public void setExecutable(Provider<? extends RegularFile> executable) {
        this.executable.set(executable);
    }

    @InputFiles
    public FileCollection getLibs() {
        return this.libs;
    }

    public void setLibs(FileCollection libs) {
        this.libs.setFrom((Iterable)libs);
    }

    public void lib(Object libs) {
        this.libs.from(new Object[]{libs});
    }

    @Internal
    public File getRunScript() {
        OperatingSystem operatingSystem = OperatingSystem.forName((String)this.platform.getOperatingSystem().getName());
        return new File(this.getDestinationDir(), operatingSystem.getScriptName(this.getExecutable().getName()));
    }

    @Inject
    protected FileSystem getFileSystem() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected FileOperations getFileOperations() {
        throw new UnsupportedOperationException();
    }

    @TaskAction
    public void install() {
        if (this.platform.getOperatingSystem().isWindows()) {
            this.installWindows();
        } else {
            this.installUnix();
        }
    }

    private void installWindows() {
        File destination = this.getDestinationDir();
        File executable = this.getExecutable();
        this.installToDir(new File(destination, "lib"));
        StringBuilder toolChainPath = new StringBuilder();
        if (this.toolChain instanceof Gcc) {
            toolChainPath.append("SET PATH=");
            for (File pathEntry : ((Gcc)this.toolChain).getPath()) {
                toolChainPath.append(pathEntry.getAbsolutePath()).append(";");
            }
            toolChainPath.append("%PATH%");
        }
        String runScriptText = "\n@echo off\nSETLOCAL\n" + toolChainPath + "\nCALL \"%~dp0lib\\" + executable.getName() + "\" %*" + "\nEXIT /B %ERRORLEVEL%" + "\nENDLOCAL" + "\n";
        GFileUtils.writeFile((String)runScriptText, (File)this.getRunScript());
    }

    private void installUnix() {
        File destination = this.getDestinationDir();
        File executable = this.getExecutable();
        this.installToDir(new File(destination, "lib"));
        String runScriptText = "#!/bin/sh\nAPP_BASE_NAME=`dirname \"$0\"`\nDYLD_LIBRARY_PATH=\"$APP_BASE_NAME/lib\"\nexport DYLD_LIBRARY_PATH\nLD_LIBRARY_PATH=\"$APP_BASE_NAME/lib\"\nexport LD_LIBRARY_PATH\nexec \"$APP_BASE_NAME/lib/" + executable.getName() + "\" \"$@\"" + "\n";
        GFileUtils.writeFile((String)runScriptText, (File)this.getRunScript());
        this.getFileSystem().chmod(this.getRunScript(), 493);
    }

    private void installToDir(final File binaryDir) {
        this.getFileOperations().sync((Action)new Action<CopySpec>(){

            public void execute(CopySpec copySpec) {
                copySpec.into((Object)binaryDir);
                copySpec.from(new Object[]{InstallExecutable.this.getExecutable()});
                copySpec.from(new Object[]{InstallExecutable.this.getLibs()});
            }
        });
    }
}

