/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.toolchain.internal;

import java.io.File;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.internal.tasks.SimpleWorkResult;
import org.gradle.api.tasks.WorkResult;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.BuildOperationQueue;
import org.gradle.internal.operations.BuildOperationWorker;
import org.gradle.internal.operations.logging.BuildOperationLogger;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.nativeplatform.internal.BinaryToolSpec;
import org.gradle.nativeplatform.toolchain.internal.ArgsTransformer;
import org.gradle.nativeplatform.toolchain.internal.CommandLineToolContext;
import org.gradle.nativeplatform.toolchain.internal.CommandLineToolInvocation;
import org.gradle.nativeplatform.toolchain.internal.CommandLineToolInvocationWorker;

public abstract class AbstractCompiler<T extends BinaryToolSpec>
implements Compiler<T> {
    private final CommandLineToolInvocationWorker commandLineToolInvocationWorker;
    private final ArgsTransformer<T> argsTransformer;
    private final CommandLineToolContext invocationContext;
    private final boolean useCommandFile;
    private final BuildOperationExecutor buildOperationExecutor;

    protected AbstractCompiler(BuildOperationExecutor buildOperationExecutor, CommandLineToolInvocationWorker commandLineToolInvocationWorker, CommandLineToolContext invocationContext, ArgsTransformer<T> argsTransformer, boolean useCommandFile) {
        this.buildOperationExecutor = buildOperationExecutor;
        this.argsTransformer = argsTransformer;
        this.invocationContext = invocationContext;
        this.useCommandFile = useCommandFile;
        this.commandLineToolInvocationWorker = commandLineToolInvocationWorker;
    }

    public WorkResult execute(T spec) {
        this.buildOperationExecutor.runAll((BuildOperationWorker)this.commandLineToolInvocationWorker, this.newInvocationAction(spec));
        return new SimpleWorkResult(true);
    }

    protected abstract Action<BuildOperationQueue<CommandLineToolInvocation>> newInvocationAction(T var1);

    protected List<String> getArguments(T spec) {
        List args = (List)this.argsTransformer.transform(spec);
        Action<List<String>> userArgTransformer = this.invocationContext.getArgAction();
        userArgTransformer.execute((Object)args);
        if (this.useCommandFile) {
            this.addOptionsFileArgs(args, spec.getTempDir());
        }
        return args;
    }

    protected abstract void addOptionsFileArgs(List<String> var1, File var2);

    protected CommandLineToolInvocation newInvocation(String name, File workingDirectory, Iterable<String> args, BuildOperationLogger operationLogger) {
        return this.invocationContext.createInvocation(name, workingDirectory, args, operationLogger);
    }
}

