/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.collections.IndexedValue;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CollectionsKt {
    @NotNull
    public static final <K, V> Map<K, V> keysToMapExceptNulls(@NotNull Iterable<? extends K> $receiver, @NotNull Function1<? super K, ? extends V> value) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(value, (String)"value");
        LinkedHashMap map2 = new LinkedHashMap();
        for (K k : $receiver) {
            Object v = value.invoke(k);
            if (v == null) continue;
            Map map3 = map2;
            Object object = v;
            map3.put(k, object);
        }
        return map2;
    }

    @NotNull
    public static final <K> Map<K, Integer> mapToIndex(@NotNull Iterable<? extends K> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        LinkedHashMap map2 = new LinkedHashMap();
        for (IndexedValue indexedValue : kotlin.collections.CollectionsKt.withIndex($receiver)) {
            int index = indexedValue.component1();
            Object k = indexedValue.component2();
            Map map3 = map2;
            Integer n = index;
            map3.put(k, n);
        }
        return map2;
    }

    public static final <T> void addIfNotNull(@NotNull Collection<T> $receiver, @Nullable T t) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        if (t != null) {
            $receiver.add(t);
        }
    }

    @NotNull
    public static final <K, V> HashMap<K, V> newHashMapWithExpectedSize(int expectedSize) {
        return new HashMap(CollectionsKt.capacity(expectedSize));
    }

    @NotNull
    public static final <E> HashSet<E> newHashSetWithExpectedSize(int expectedSize) {
        return new HashSet(CollectionsKt.capacity(expectedSize));
    }

    private static final int capacity(int expectedSize) {
        return expectedSize < 3 ? 3 : expectedSize + expectedSize / 3 + 1;
    }

    @NotNull
    public static final <T> List<T> compactIfPossible(@NotNull ArrayList<T> $receiver) {
        List list;
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        switch ($receiver.size()) {
            case 0: {
                list = kotlin.collections.CollectionsKt.emptyList();
                break;
            }
            case 1: {
                list = kotlin.collections.CollectionsKt.listOf((Object)kotlin.collections.CollectionsKt.first((List)$receiver));
                break;
            }
            default: {
                ArrayList<T> arrayList;
                ArrayList<T> $receiver2 = arrayList = $receiver;
                $receiver2.trimToSize();
                list = arrayList;
            }
        }
        return list;
    }
}

