/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.modulecache;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.DefaultModuleVersionSelector;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.ivyservice.NamespaceId;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.ModuleExclusions;
import org.gradle.internal.component.external.descriptor.Artifact;
import org.gradle.internal.component.external.descriptor.Configuration;
import org.gradle.internal.component.external.descriptor.DefaultExclude;
import org.gradle.internal.component.external.descriptor.MavenScope;
import org.gradle.internal.component.external.descriptor.ModuleDescriptorState;
import org.gradle.internal.component.external.descriptor.MutableModuleDescriptorState;
import org.gradle.internal.component.external.model.DefaultModuleComponentIdentifier;
import org.gradle.internal.component.external.model.DefaultMutableIvyModuleResolveMetadata;
import org.gradle.internal.component.external.model.DefaultMutableMavenModuleResolveMetadata;
import org.gradle.internal.component.external.model.IvyDependencyMetadata;
import org.gradle.internal.component.external.model.IvyModuleResolveMetadata;
import org.gradle.internal.component.external.model.MavenDependencyMetadata;
import org.gradle.internal.component.external.model.MavenModuleResolveMetadata;
import org.gradle.internal.component.external.model.ModuleComponentResolveMetadata;
import org.gradle.internal.component.external.model.MutableModuleComponentResolveMetadata;
import org.gradle.internal.component.model.DefaultIvyArtifactName;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.component.model.Exclude;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;

public class ModuleMetadataSerializer {
    private static final byte TYPE_IVY = 1;
    private static final byte TYPE_MAVEN = 2;

    public MutableModuleComponentResolveMetadata read(Decoder decoder, ImmutableModuleIdentifierFactory moduleIdentifierFactory, ModuleExclusions moduleExclusions) throws IOException {
        return new Reader(decoder, moduleIdentifierFactory).read();
    }

    public void write(Encoder encoder, ModuleComponentResolveMetadata metadata) throws IOException {
        new Writer(encoder).write(metadata);
    }

    private static class Reader {
        private final Decoder decoder;
        private final ImmutableModuleIdentifierFactory moduleIdentifierFactory;
        private MutableModuleDescriptorState md;
        private ModuleComponentIdentifier id;
        private ModuleVersionIdentifier mvi;

        private Reader(Decoder decoder, ImmutableModuleIdentifierFactory moduleIdentifierFactory) {
            this.decoder = decoder;
            this.moduleIdentifierFactory = moduleIdentifierFactory;
        }

        public MutableModuleComponentResolveMetadata read() throws IOException {
            byte type = this.decoder.readByte();
            switch (type) {
                case 1: {
                    return this.readIvy();
                }
                case 2: {
                    return this.readMaven();
                }
            }
            throw new IllegalArgumentException("Unexpected metadata type found.");
        }

        private void readSharedInfo() throws IOException {
            this.readArtifacts();
            this.readAllExcludes();
        }

        private MutableModuleComponentResolveMetadata readMaven() throws IOException {
            this.readInfoSection();
            List<DependencyMetadata> dependencies = this.readDependencies();
            this.readSharedInfo();
            String snapshotTimestamp = this.readNullableString();
            String packaging = this.readNullableString();
            boolean relocated = this.readBoolean();
            DefaultMutableMavenModuleResolveMetadata metadata = new DefaultMutableMavenModuleResolveMetadata(this.mvi, this.id, this.md, packaging, relocated, dependencies);
            metadata.setSnapshotTimestamp(snapshotTimestamp);
            return metadata;
        }

        private MutableModuleComponentResolveMetadata readIvy() throws IOException {
            this.readInfoSection();
            List<Configuration> configurations = this.readConfigurations();
            List<DependencyMetadata> dependencies = this.readDependencies();
            this.readSharedInfo();
            return new DefaultMutableIvyModuleResolveMetadata(this.mvi, this.id, (ModuleDescriptorState)this.md, configurations, dependencies);
        }

        private void readInfoSection() throws IOException {
            this.id = this.readId();
            ModuleComponentIdentifier componentIdentifier = this.readId();
            String status = this.readString();
            boolean generated = this.readBoolean();
            this.md = new MutableModuleDescriptorState(componentIdentifier, status, generated);
            this.md.setDescription(this.readNullableString());
            this.md.setPublicationDate(this.readNullableDate());
            this.md.setBranch(this.readNullableString());
            this.mvi = this.moduleIdentifierFactory.moduleWithVersion(componentIdentifier.getGroup(), componentIdentifier.getModule(), componentIdentifier.getVersion());
            this.readExtraInfo();
        }

        private ModuleComponentIdentifier readId() throws IOException {
            return DefaultModuleComponentIdentifier.newId(this.readString(), this.readString(), this.readString());
        }

        private void readExtraInfo() throws IOException {
            int len = this.readCount();
            for (int i = 0; i < len; ++i) {
                NamespaceId namespaceId = new NamespaceId(this.readString(), this.readString());
                String value = this.readString();
                this.md.getExtraInfo().put(namespaceId, value);
            }
        }

        private List<Configuration> readConfigurations() throws IOException {
            int len = this.readCount();
            ArrayList<Configuration> configurations = new ArrayList<Configuration>(len);
            for (int i = 0; i < len; ++i) {
                Configuration configuration = this.readConfiguration();
                configurations.add(configuration);
            }
            return configurations;
        }

        private Configuration readConfiguration() throws IOException {
            String name = this.readString();
            boolean transitive = this.readBoolean();
            boolean visible = this.readBoolean();
            List<String> extendsFrom = this.readStringList();
            return new Configuration(name, transitive, visible, extendsFrom);
        }

        private void readArtifacts() throws IOException {
            int size = this.readCount();
            for (int i = 0; i < size; ++i) {
                DefaultIvyArtifactName ivyArtifactName = new DefaultIvyArtifactName(this.readString(), this.readString(), this.readNullableString(), this.readNullableString());
                this.md.addArtifact(ivyArtifactName, this.readStringSet());
            }
        }

        private List<DependencyMetadata> readDependencies() throws IOException {
            int len = this.readCount();
            ArrayList result = Lists.newArrayListWithCapacity((int)len);
            for (int i = 0; i < len; ++i) {
                result.add(this.readDependency());
            }
            return result;
        }

        private DependencyMetadata readDependency() throws IOException {
            ModuleVersionSelector requested = DefaultModuleVersionSelector.newSelector(this.readString(), this.readString(), this.readString());
            byte type = this.decoder.readByte();
            switch (type) {
                case 1: {
                    SetMultimap<String, String> configMappings = this.readDependencyConfigurationMapping();
                    List<Artifact> artifacts = this.readDependencyArtifactDescriptors();
                    List<Exclude> excludes = this.readExcludeRules();
                    String dynamicConstraintVersion = this.readString();
                    boolean force = this.readBoolean();
                    boolean changing = this.readBoolean();
                    boolean transitive = this.readBoolean();
                    return new IvyDependencyMetadata(requested, dynamicConstraintVersion, force, changing, transitive, (Multimap<String, String>)configMappings, artifacts, excludes);
                }
                case 2: {
                    List<Artifact> artifacts = this.readDependencyArtifactDescriptors();
                    List<Exclude> excludes = this.readExcludeRules();
                    MavenScope scope = MavenScope.values()[this.decoder.readSmallInt()];
                    boolean optional = this.decoder.readBoolean();
                    return new MavenDependencyMetadata(scope, optional, requested, artifacts, excludes);
                }
            }
            throw new IllegalArgumentException("Unexpected dependency type found.");
        }

        private SetMultimap<String, String> readDependencyConfigurationMapping() throws IOException {
            int size = this.readCount();
            LinkedHashMultimap result = LinkedHashMultimap.create();
            for (int i = 0; i < size; ++i) {
                String from = this.readString();
                Set<String> to = this.readStringSet();
                result.putAll((Object)from, to);
            }
            return result;
        }

        private List<Artifact> readDependencyArtifactDescriptors() throws IOException {
            int size = this.readCount();
            ArrayList result = Lists.newArrayListWithCapacity((int)size);
            for (int i = 0; i < size; ++i) {
                DefaultIvyArtifactName ivyArtifactName = new DefaultIvyArtifactName(this.readString(), this.readString(), this.readNullableString(), this.readNullableString());
                result.add(new Artifact(ivyArtifactName, this.readStringSet()));
            }
            return result;
        }

        private List<Exclude> readExcludeRules() throws IOException {
            int len = this.readCount();
            ArrayList result = Lists.newArrayListWithCapacity((int)len);
            for (int i = 0; i < len; ++i) {
                DefaultExclude rule = this.readExcludeRule();
                result.add(rule);
            }
            return result;
        }

        private DefaultExclude readExcludeRule() throws IOException {
            String moduleOrg = this.readString();
            String moduleName = this.readString();
            String artifact = this.readString();
            String type = this.readString();
            String ext = this.readString();
            String[] confs = this.readStringArray();
            String matcher = this.readString();
            return new DefaultExclude(this.moduleIdentifierFactory.module(moduleOrg, moduleName), artifact, type, ext, confs, matcher);
        }

        private void readAllExcludes() throws IOException {
            int len = this.readCount();
            for (int i = 0; i < len; ++i) {
                this.md.addExclude(this.readExcludeRule());
            }
        }

        private int readCount() throws IOException {
            return this.decoder.readSmallInt();
        }

        private String readString() throws IOException {
            return this.decoder.readString();
        }

        private String readNullableString() throws IOException {
            return this.decoder.readNullableString();
        }

        private boolean readBoolean() throws IOException {
            return this.decoder.readBoolean();
        }

        private Date readNullableDate() throws IOException {
            long value = this.readLong();
            if (value == -1L) {
                return null;
            }
            return new Date(value);
        }

        private long readLong() throws IOException {
            return this.decoder.readLong();
        }

        private String[] readStringArray() throws IOException {
            int size = this.readCount();
            String[] array = new String[size];
            for (int i = 0; i < size; ++i) {
                array[i] = this.readNullableString();
            }
            return array;
        }

        private List<String> readStringList() throws IOException {
            int size = this.readCount();
            ArrayList<String> list = new ArrayList<String>(size);
            for (int i = 0; i < size; ++i) {
                list.add(this.readString());
            }
            return list;
        }

        private Set<String> readStringSet() throws IOException {
            int size = this.readCount();
            LinkedHashSet<String> set = new LinkedHashSet<String>(size);
            for (int i = 0; i < size; ++i) {
                set.add(this.readString());
            }
            return set;
        }
    }

    private static class Writer {
        private final Encoder encoder;

        private Writer(Encoder encoder) {
            this.encoder = encoder;
        }

        public void write(ModuleComponentResolveMetadata metadata) throws IOException {
            if (metadata instanceof IvyModuleResolveMetadata) {
                this.write((IvyModuleResolveMetadata)metadata);
            } else if (metadata instanceof MavenModuleResolveMetadata) {
                this.write((MavenModuleResolveMetadata)metadata);
            } else {
                throw new IllegalArgumentException("Unexpected metadata type: " + metadata.getClass());
            }
        }

        private void write(MavenModuleResolveMetadata metadata) throws IOException {
            this.encoder.writeByte((byte)2);
            this.writeInfoSection(metadata);
            this.writeDependencies(metadata.getDependencies());
            this.writeSharedInfo(metadata);
            this.writeNullableString(metadata.getSnapshotTimestamp());
            this.writeNullableString(metadata.getPackaging());
            this.writeBoolean(metadata.isRelocated());
        }

        private void write(IvyModuleResolveMetadata metadata) throws IOException {
            this.encoder.writeByte((byte)1);
            this.writeInfoSection(metadata);
            this.writeConfigurations(metadata.getConfigurationDefinitions().values());
            this.writeDependencies(metadata.getDependencies());
            this.writeSharedInfo(metadata);
        }

        private void writeSharedInfo(ModuleComponentResolveMetadata metadata) throws IOException {
            ModuleDescriptorState md = metadata.getDescriptor();
            this.writeArtifacts(md.getArtifacts());
            this.writeExcludeRules(md.getExcludes());
        }

        private void writeId(ModuleComponentIdentifier componentIdentifier) throws IOException {
            this.writeString(componentIdentifier.getGroup());
            this.writeString(componentIdentifier.getModule());
            this.writeString(componentIdentifier.getVersion());
        }

        private void writeInfoSection(ModuleComponentResolveMetadata metadata) throws IOException {
            this.writeId(metadata.getComponentId());
            ModuleDescriptorState md = metadata.getDescriptor();
            ModuleComponentIdentifier componentIdentifier = md.getComponentIdentifier();
            this.writeId(componentIdentifier);
            this.writeString(md.getStatus());
            this.writeBoolean(md.isGenerated());
            this.writeNullableString(md.getDescription());
            this.writeNullableDate(md.getPublicationDate());
            this.writeNullableString(md.getBranch());
            this.writeExtraInfo(md.getExtraInfo());
        }

        private void writeExtraInfo(Map<NamespaceId, String> extraInfo) throws IOException {
            this.writeCount(extraInfo.size());
            for (Map.Entry<NamespaceId, String> entry : extraInfo.entrySet()) {
                NamespaceId namespaceId = entry.getKey();
                this.writeString(namespaceId.getNamespace());
                this.writeString(namespaceId.getName());
                this.writeString(entry.getValue());
            }
        }

        private void writeConfigurations(Collection<Configuration> configurations) throws IOException {
            this.writeCount(configurations.size());
            for (Configuration conf : configurations) {
                this.writeConfiguration(conf);
            }
        }

        private void writeConfiguration(Configuration conf) throws IOException {
            this.writeString(conf.getName());
            this.writeBoolean(conf.isTransitive());
            this.writeBoolean(conf.isVisible());
            this.writeStringList(conf.getExtendsFrom());
        }

        private void writeArtifacts(List<Artifact> artifacts) throws IOException {
            this.writeCount(artifacts.size());
            for (Artifact artifact : artifacts) {
                IvyArtifactName artifactName = artifact.getArtifactName();
                this.writeString(artifactName.getName());
                this.writeString(artifactName.getType());
                this.writeNullableString(artifactName.getExtension());
                this.writeNullableString(artifactName.getClassifier());
                this.writeStringSet(artifact.getConfigurations());
            }
        }

        private void writeDependencies(List<? extends DependencyMetadata> dependencies) throws IOException {
            this.writeCount(dependencies.size());
            for (DependencyMetadata dependencyMetadata : dependencies) {
                this.writeDependency(dependencyMetadata);
            }
        }

        private void writeDependency(DependencyMetadata dep) throws IOException {
            ModuleVersionSelector selector = dep.getRequested();
            this.writeString(selector.getGroup());
            this.writeString(selector.getName());
            this.writeString(selector.getVersion());
            if (dep instanceof IvyDependencyMetadata) {
                IvyDependencyMetadata ivyDependency = (IvyDependencyMetadata)dep;
                this.encoder.writeByte((byte)1);
                this.writeDependencyConfigurationMapping(ivyDependency);
                this.writeArtifacts(ivyDependency.getDependencyArtifacts());
                this.writeExcludeRules(ivyDependency.getExcludes());
                this.writeString(ivyDependency.getDynamicConstraintVersion());
                this.writeBoolean(ivyDependency.isForce());
                this.writeBoolean(ivyDependency.isChanging());
                this.writeBoolean(ivyDependency.isTransitive());
            } else if (dep instanceof MavenDependencyMetadata) {
                MavenDependencyMetadata mavenDependency = (MavenDependencyMetadata)dep;
                this.encoder.writeByte((byte)2);
                this.writeArtifacts(mavenDependency.getDependencyArtifacts());
                this.writeExcludeRules(mavenDependency.getExcludes());
                this.encoder.writeSmallInt(mavenDependency.getScope().ordinal());
                this.encoder.writeBoolean(mavenDependency.isOptional());
            } else {
                throw new IllegalStateException("Unexpected dependency type");
            }
        }

        private void writeDependencyConfigurationMapping(IvyDependencyMetadata dep) throws IOException {
            SetMultimap<String, String> confMappings = dep.getConfMappings();
            this.writeCount(confMappings.keySet().size());
            for (String conf : confMappings.keySet()) {
                this.writeString(conf);
                this.writeStringSet(confMappings.get((Object)conf));
            }
        }

        private void writeExcludeRules(List<Exclude> excludes) throws IOException {
            this.writeCount(excludes.size());
            for (Exclude exclude : excludes) {
                IvyArtifactName artifact = exclude.getArtifact();
                this.writeString(exclude.getModuleId().getGroup());
                this.writeString(exclude.getModuleId().getName());
                this.writeString(artifact.getName());
                this.writeString(artifact.getType());
                this.writeString(artifact.getExtension());
                this.writeStringArray(exclude.getConfigurations().toArray(new String[0]));
                this.writeString(exclude.getMatcher());
            }
        }

        private void writeCount(int i) throws IOException {
            this.encoder.writeSmallInt(i);
        }

        private void writeString(String str) throws IOException {
            this.encoder.writeString((CharSequence)str);
        }

        private void writeNullableString(String str) throws IOException {
            this.encoder.writeNullableString((CharSequence)str);
        }

        private void writeBoolean(boolean b) throws IOException {
            this.encoder.writeBoolean(b);
        }

        private void writeNullableDate(Date publicationDate) throws IOException {
            if (publicationDate == null) {
                this.writeLong(-1L);
            } else {
                this.writeLong(publicationDate.getTime());
            }
        }

        private void writeLong(long l) throws IOException {
            this.encoder.writeLong(l);
        }

        private void writeStringArray(String[] values) throws IOException {
            this.writeCount(values.length);
            for (String configuration : values) {
                this.writeNullableString(configuration);
            }
        }

        private void writeStringList(List<String> values) throws IOException {
            this.writeCount(values.size());
            for (String configuration : values) {
                this.writeString(configuration);
            }
        }

        private void writeStringSet(Set<String> values) throws IOException {
            this.writeCount(values.size());
            for (String configuration : values) {
                this.writeString(configuration);
            }
        }
    }
}

