/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import com.google.common.collect.Maps;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.gradle.api.Transformer;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.VariantTransformRegistry;
import org.gradle.api.internal.artifacts.transform.ConsumerVariantMatchResult;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.internal.component.model.AttributeMatcher;

public class VariantAttributeMatchingCache {
    private final VariantTransformRegistry variantTransforms;
    private final AttributesSchemaInternal schema;
    private final ImmutableAttributesFactory attributesFactory;
    private final Map<AttributeContainer, AttributeSpecificCache> attributeSpecificCache = Maps.newConcurrentMap();

    public VariantAttributeMatchingCache(VariantTransformRegistry variantTransforms, AttributesSchemaInternal schema, ImmutableAttributesFactory attributesFactory) {
        this.variantTransforms = variantTransforms;
        this.schema = schema;
        this.attributesFactory = attributesFactory;
    }

    public void collectConsumerVariants(AttributeContainerInternal actual, AttributeContainerInternal requested, ConsumerVariantMatchResult result) {
        AttributeSpecificCache toCache = this.getCache((AttributeContainer)requested);
        ConsumerVariantMatchResult cachedResult = (ConsumerVariantMatchResult)toCache.transforms.get(actual);
        if (cachedResult == null) {
            cachedResult = new ConsumerVariantMatchResult();
            this.findProducersFor(actual, requested, cachedResult);
            toCache.transforms.put(actual, cachedResult);
        }
        cachedResult.applyTo(result);
    }

    private void findProducersFor(AttributeContainerInternal actual, AttributeContainerInternal requested, ConsumerVariantMatchResult result) {
        ArrayList<VariantTransformRegistry.Registration> candidates = new ArrayList<VariantTransformRegistry.Registration>();
        for (VariantTransformRegistry.Registration transform : this.variantTransforms.getTransforms()) {
            if (!this.matchAttributes((AttributeContainer)transform.getTo(), (AttributeContainer)requested)) continue;
            if (this.matchAttributes((AttributeContainer)actual, (AttributeContainer)transform.getFrom())) {
                ImmutableAttributes variantAttributes = this.attributesFactory.concat(actual.asImmutable(), transform.getTo().asImmutable());
                result.matched(variantAttributes, transform.getArtifactTransform(), 1);
            }
            candidates.add(transform);
        }
        if (result.hasMatches()) {
            return;
        }
        for (final VariantTransformRegistry.Registration candidate : candidates) {
            ConsumerVariantMatchResult inputVariants = new ConsumerVariantMatchResult();
            this.collectConsumerVariants(actual, candidate.getFrom(), inputVariants);
            if (!inputVariants.hasMatches()) continue;
            for (final ConsumerVariantMatchResult.ConsumerVariant inputVariant : inputVariants.getMatches()) {
                ImmutableAttributes variantAttributes = this.attributesFactory.concat(inputVariant.attributes.asImmutable(), candidate.getTo().asImmutable());
                Transformer<List<File>, File> transformer = new Transformer<List<File>, File>(){

                    public List<File> transform(File file) {
                        ArrayList<File> result = new ArrayList<File>();
                        for (File intermediate : (List)inputVariant.transformer.transform((Object)file)) {
                            result.addAll((Collection)candidate.getArtifactTransform().transform((Object)intermediate));
                        }
                        return result;
                    }
                };
                result.matched(variantAttributes, transformer, inputVariant.depth + 1);
            }
        }
    }

    private AttributeSpecificCache getCache(AttributeContainer attributes) {
        AttributeSpecificCache cache = this.attributeSpecificCache.get(attributes);
        if (cache == null) {
            cache = new AttributeSpecificCache();
            this.attributeSpecificCache.put(attributes, cache);
        }
        return cache;
    }

    private boolean matchAttributes(AttributeContainer actual, AttributeContainer requested) {
        AttributeMatcher schemaToMatchOn = this.schema.matcher();
        Map cache = this.getCache(requested).ignoreExtraActual;
        Boolean match = (Boolean)cache.get(actual);
        if (match == null) {
            match = schemaToMatchOn.isMatching(actual, requested);
            cache.put(actual, match);
        }
        return match;
    }

    private static class AttributeSpecificCache {
        private final Map<AttributeContainer, Boolean> ignoreExtraActual = Maps.newConcurrentMap();
        private final Map<AttributeContainer, ConsumerVariantMatchResult> transforms = Maps.newConcurrentMap();

        private AttributeSpecificCache() {
        }
    }
}

