/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component;

import java.util.ArrayList;
import java.util.TreeSet;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.internal.component.AmbiguousConfigurationSelectionException;
import org.gradle.internal.component.model.AttributeMatcher;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.component.model.ConfigurationMetadata;
import org.gradle.internal.text.TreeFormatter;

public class NoMatchingConfigurationSelectionException
extends RuntimeException {
    public NoMatchingConfigurationSelectionException(AttributeContainer fromConfigurationAttributes, AttributeMatcher attributeMatcher, ComponentResolveMetadata targetComponent) {
        super(NoMatchingConfigurationSelectionException.generateMessage(fromConfigurationAttributes, attributeMatcher, targetComponent));
    }

    private static String generateMessage(AttributeContainer fromConfigurationAttributes, AttributeMatcher attributeMatcher, ComponentResolveMetadata targetComponent) {
        TreeSet<String> configurationNames = new TreeSet<String>(targetComponent.getConfigurationNames());
        ArrayList<ConfigurationMetadata> configurations = new ArrayList<ConfigurationMetadata>(configurationNames.size());
        for (String name : configurationNames) {
            ConfigurationMetadata targetComponentConfiguration = targetComponent.getConfiguration(name);
            if (!targetComponentConfiguration.isCanBeConsumed() || targetComponentConfiguration.getAttributes().isEmpty()) continue;
            configurations.add(targetComponentConfiguration);
        }
        TreeFormatter formatter = new TreeFormatter();
        formatter.node("Unable to find a matching configuration of " + targetComponent.getComponentId().getDisplayName());
        formatter.startChildren();
        if (configurations.isEmpty()) {
            formatter.node("None of the consumable configurations have attributes.");
        } else {
            for (String config : configurationNames) {
                AmbiguousConfigurationSelectionException.formatConfiguration(formatter, fromConfigurationAttributes, attributeMatcher, configurations, config);
            }
        }
        formatter.endChildren();
        return formatter.toString();
    }
}

