/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.cpp.plugins;

import java.util.Collections;
import java.util.concurrent.Callable;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.Task;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryVar;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.TaskContainerInternal;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.specs.Spec;
import org.gradle.language.cpp.plugins.CppBasePlugin;
import org.gradle.language.cpp.tasks.CppCompile;
import org.gradle.nativeplatform.platform.NativePlatform;
import org.gradle.nativeplatform.platform.internal.DefaultNativePlatform;
import org.gradle.nativeplatform.platform.internal.NativePlatformInternal;
import org.gradle.nativeplatform.tasks.InstallExecutable;
import org.gradle.nativeplatform.tasks.LinkExecutable;
import org.gradle.nativeplatform.toolchain.NativeToolChain;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainInternal;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainRegistryInternal;
import org.gradle.nativeplatform.toolchain.internal.PlatformToolProvider;
import org.gradle.platform.base.Platform;
import org.gradle.platform.base.ToolChain;

@Incubating
public class CppExecutablePlugin
implements Plugin<ProjectInternal> {
    public void apply(final ProjectInternal project) {
        project.getPluginManager().apply(CppBasePlugin.class);
        DirectoryVar buildDirectory = project.getLayout().getBuildDirectory();
        ConfigurationContainer configurations = project.getConfigurations();
        TaskContainerInternal tasks = project.getTasks();
        ProviderFactory providers = project.getProviders();
        CppCompile compile = (CppCompile)tasks.create("compileCpp", CppCompile.class);
        compile.includes("src/main/headers");
        compile.includes(configurations.getByName("cppCompileIncludePath"));
        ConfigurableFileTree sourceTree = project.fileTree((Object)"src/main/cpp");
        sourceTree.include(new String[]{"**/*.cpp"});
        sourceTree.include(new String[]{"**/*.c++"});
        compile.source(sourceTree);
        compile.setCompilerArgs(Collections.emptyList());
        compile.setMacros(Collections.emptyMap());
        compile.setObjectFileDir((Provider<? extends Directory>)buildDirectory.dir("main/objs"));
        DefaultNativePlatform currentPlatform = new DefaultNativePlatform("current");
        compile.setTargetPlatform((NativePlatform)currentPlatform);
        NativeToolChain toolChain = (NativeToolChain)((NativeToolChainRegistryInternal)project.getModelRegistry().realize("toolChains", NativeToolChainRegistryInternal.class)).getForPlatform((Platform)currentPlatform);
        compile.setToolChain(toolChain);
        LinkExecutable link = (LinkExecutable)tasks.create("linkMain", LinkExecutable.class);
        link.source((Object)compile.getObjectFileDirectory().getAsFileTree());
        link.lib((Object)configurations.getByName("nativeLink"));
        link.setLinkerArgs(Collections.emptyList());
        final PlatformToolProvider toolProvider = ((NativeToolChainInternal)toolChain).select((NativePlatformInternal)currentPlatform);
        Provider exeLocation = buildDirectory.file(providers.provider((Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                return toolProvider.getExecutableName("exe/" + project.getName());
            }
        }));
        link.setOutputFile(exeLocation);
        link.setTargetPlatform((NativePlatform)currentPlatform);
        link.setToolChain(toolChain);
        final InstallExecutable install = (InstallExecutable)tasks.create("installMain", InstallExecutable.class);
        install.setPlatform((NativePlatform)currentPlatform);
        install.setToolChain((ToolChain)toolChain);
        install.setDestinationDir(buildDirectory.dir("install/" + project.getName()));
        install.setExecutable((Provider)link.getBinaryFile());
        install.onlyIf((Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task element) {
                return install.getExecutable().exists();
            }
        });
        install.lib((Object)configurations.getByName("nativeRuntime"));
        tasks.getByName("assemble").dependsOn(new Object[]{install});
    }
}

