/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.swift.plugins;

import java.util.Collections;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ConfigurablePublishArtifact;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.attributes.Usage;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.language.swift.plugins.SwiftBasePlugin;
import org.gradle.language.swift.tasks.SwiftCompile;
import org.gradle.nativeplatform.platform.NativePlatform;
import org.gradle.nativeplatform.platform.internal.DefaultNativePlatform;
import org.gradle.nativeplatform.platform.internal.NativePlatformInternal;
import org.gradle.nativeplatform.tasks.LinkSharedLibrary;
import org.gradle.nativeplatform.toolchain.NativeToolChain;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainInternal;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainRegistryInternal;
import org.gradle.platform.base.Platform;

@Incubating
public class SwiftModulePlugin
implements Plugin<Project> {
    public void apply(Project project) {
        project.getPluginManager().apply(SwiftBasePlugin.class);
        final SwiftCompile compile = (SwiftCompile)project.getTasks().create("compileSwift", SwiftCompile.class);
        compile.includes(project.getConfigurations().getByName("swiftImportPath"));
        ConfigurableFileTree sourceTree = project.fileTree((Object)"src/main/swift");
        sourceTree.include(new String[]{"**/*.swift"});
        compile.source(sourceTree);
        compile.setCompilerArgs(Collections.emptyList());
        compile.setMacros(Collections.emptyMap());
        compile.setModuleName(project.getName());
        compile.setObjectFileDir(project.file((Object)"build/main/objs"));
        DefaultNativePlatform currentPlatform = new DefaultNativePlatform("current");
        compile.setTargetPlatform((NativePlatform)currentPlatform);
        NativeToolChain toolChain = (NativeToolChain)((NativeToolChainRegistryInternal)((ProjectInternal)project).getModelRegistry().realize("toolChains", NativeToolChainRegistryInternal.class)).getForPlatform((Platform)currentPlatform);
        compile.setToolChain(toolChain);
        final LinkSharedLibrary link = (LinkSharedLibrary)project.getTasks().create("linkMain", LinkSharedLibrary.class);
        link.source((Object)compile.getObjectFileDirectory().getAsFileTree().matching((PatternFilterable)new PatternSet().include(new String[]{"**/*.obj", "**/*.o"})));
        link.lib((Object)project.getConfigurations().getByName("nativeLink"));
        link.setLinkerArgs(Collections.emptyList());
        String libFileName = ((NativeToolChainInternal)toolChain).select((NativePlatformInternal)currentPlatform).getSharedLibraryName("build/lib/" + project.getName());
        link.setOutputFile(project.file((Object)libFileName));
        link.setTargetPlatform((NativePlatform)currentPlatform);
        link.setToolChain(toolChain);
        project.getTasks().getByName("assemble").dependsOn(new Object[]{link});
        Configuration api = project.getConfigurations().getByName("api");
        Configuration apiElements = (Configuration)project.getConfigurations().create("swiftApiElements");
        apiElements.extendsFrom(new Configuration[]{api});
        apiElements.setCanBeResolved(false);
        apiElements.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)project.getObjects().named(Usage.class, "swift-api"));
        apiElements.getOutgoing().artifact((Object)project.file((Object)"build/main/objs"), (Action)new Action<ConfigurablePublishArtifact>(){

            public void execute(ConfigurablePublishArtifact artifact) {
                artifact.builtBy(new Object[]{compile});
            }
        });
        Configuration implementation = project.getConfigurations().getByName("implementation");
        Configuration linkElements = (Configuration)project.getConfigurations().create("linkElements");
        linkElements.extendsFrom(new Configuration[]{implementation});
        linkElements.setCanBeResolved(false);
        linkElements.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)project.getObjects().named(Usage.class, "native-link"));
        linkElements.getOutgoing().artifact((Object)link.getOutputFile(), (Action)new Action<ConfigurablePublishArtifact>(){

            public void execute(ConfigurablePublishArtifact artifact) {
                artifact.builtBy(new Object[]{link});
            }
        });
        Configuration runtimeElements = (Configuration)project.getConfigurations().create("runtimeElements");
        runtimeElements.extendsFrom(new Configuration[]{implementation});
        runtimeElements.setCanBeResolved(false);
        runtimeElements.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)project.getObjects().named(Usage.class, "native-runtime"));
        runtimeElements.getOutgoing().artifact((Object)link.getOutputFile(), (Action)new Action<ConfigurablePublishArtifact>(){

            public void execute(ConfigurablePublishArtifact artifact) {
                artifact.builtBy(new Object[]{link});
            }
        });
    }
}

