/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.workers.internal;

import net.jcip.annotations.ThreadSafe;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.CallableBuildOperation;
import org.gradle.internal.progress.BuildOperationDescriptor;
import org.gradle.internal.progress.BuildOperationState;
import org.gradle.internal.work.WorkerLeaseRegistry;
import org.gradle.process.internal.health.memory.MemoryHolder;
import org.gradle.process.internal.health.memory.MemoryManager;
import org.gradle.process.internal.health.memory.TotalPhysicalMemoryProvider;
import org.gradle.workers.IsolationMode;
import org.gradle.workers.internal.DaemonForkOptions;
import org.gradle.workers.internal.DefaultWorkResult;
import org.gradle.workers.internal.WorkSpec;
import org.gradle.workers.internal.Worker;
import org.gradle.workers.internal.WorkerDaemonClient;
import org.gradle.workers.internal.WorkerDaemonClientsManager;
import org.gradle.workers.internal.WorkerDaemonExpiration;
import org.gradle.workers.internal.WorkerFactory;
import org.gradle.workers.internal.WorkerProtocol;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class WorkerDaemonFactory
implements WorkerFactory,
Stoppable {
    private final WorkerDaemonClientsManager clientsManager;
    private final MemoryManager memoryManager;
    private final WorkerDaemonExpiration workerDaemonExpiration;
    private final WorkerLeaseRegistry workerLeaseRegistry;
    private final BuildOperationExecutor buildOperationExecutor;

    public WorkerDaemonFactory(WorkerDaemonClientsManager clientsManager, MemoryManager memoryManager, WorkerLeaseRegistry workerLeaseRegistry, BuildOperationExecutor buildOperationExecutor) {
        this.clientsManager = clientsManager;
        this.memoryManager = memoryManager;
        this.workerDaemonExpiration = new WorkerDaemonExpiration(clientsManager, WorkerDaemonFactory.getTotalPhysicalMemory());
        memoryManager.addMemoryHolder((MemoryHolder)this.workerDaemonExpiration);
        this.workerLeaseRegistry = workerLeaseRegistry;
        this.buildOperationExecutor = buildOperationExecutor;
    }

    @Override
    public <T extends WorkSpec> Worker<T> getWorker(final Class<? extends WorkerProtocol<T>> workerImplementationClass, final DaemonForkOptions forkOptions) {
        return new Worker<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public DefaultWorkResult execute(T spec, WorkerLeaseRegistry.WorkerLease parentWorkerWorkerLease, BuildOperationState parentBuildOperation) {
                WorkerLeaseRegistry.WorkerLeaseCompletion workerLease = parentWorkerWorkerLease.startChild();
                try {
                    WorkerDaemonClient client = WorkerDaemonFactory.this.clientsManager.reserveIdleClient(forkOptions);
                    if (client == null) {
                        client = WorkerDaemonFactory.this.clientsManager.reserveNewClient(workerImplementationClass, forkOptions);
                    }
                    try {
                        DefaultWorkResult defaultWorkResult = this.executeInClient(client, spec, parentBuildOperation);
                        WorkerDaemonFactory.this.clientsManager.release(client);
                        return defaultWorkResult;
                    }
                    catch (Throwable throwable) {
                        WorkerDaemonFactory.this.clientsManager.release(client);
                        throw throwable;
                    }
                }
                finally {
                    workerLease.leaseFinish();
                }
            }

            @Override
            public DefaultWorkResult execute(T spec) {
                return this.execute(spec, WorkerDaemonFactory.this.workerLeaseRegistry.getCurrentWorkerLease(), WorkerDaemonFactory.this.buildOperationExecutor.getCurrentOperation());
            }

            private DefaultWorkResult executeInClient(final WorkerDaemonClient<T> client, final T spec, final BuildOperationState parentBuildOperation) {
                return (DefaultWorkResult)WorkerDaemonFactory.this.buildOperationExecutor.call((CallableBuildOperation)new CallableBuildOperation<DefaultWorkResult>(){

                    public DefaultWorkResult call(BuildOperationContext context) {
                        return client.execute(spec);
                    }

                    public BuildOperationDescriptor.Builder description() {
                        return BuildOperationDescriptor.displayName((String)spec.getDisplayName()).parent(parentBuildOperation);
                    }
                });
            }
        };
    }

    @Override
    public IsolationMode getIsolationMode() {
        return IsolationMode.PROCESS;
    }

    public void stop() {
        this.memoryManager.removeMemoryHolder((MemoryHolder)this.workerDaemonExpiration);
    }

    private static long getTotalPhysicalMemory() {
        try {
            return TotalPhysicalMemoryProvider.getTotalPhysicalMemory();
        }
        catch (UnsupportedOperationException e) {
            return -1L;
        }
    }
}

